/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.geom.jts;

import cats.syntax.package;
import java.io.Serializable;
import lucuma.core.geom.Shape;
import lucuma.core.geom.ShapeExpression;
import lucuma.core.geom.ShapeExpression$BoundingBox$;
import lucuma.core.geom.ShapeExpression$Difference$;
import lucuma.core.geom.ShapeExpression$Ellipse$;
import lucuma.core.geom.ShapeExpression$Empty$;
import lucuma.core.geom.ShapeExpression$FlipP$;
import lucuma.core.geom.ShapeExpression$FlipQ$;
import lucuma.core.geom.ShapeExpression$Intersection$;
import lucuma.core.geom.ShapeExpression$Point$;
import lucuma.core.geom.ShapeExpression$Polygon$;
import lucuma.core.geom.ShapeExpression$Rectangle$;
import lucuma.core.geom.ShapeExpression$Rotate$;
import lucuma.core.geom.ShapeExpression$RotateAroundOffset$;
import lucuma.core.geom.ShapeExpression$Translate$;
import lucuma.core.geom.ShapeExpression$Union$;
import lucuma.core.geom.ShapeInterpreter;
import lucuma.core.geom.jts.Jts$;
import lucuma.core.geom.jts.JtsShape$;
import lucuma.core.geom.jts.syntax$all$;
import lucuma.core.math.Angle$package$;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Offset;
import lucuma.core.math.Offset$;
import lucuma.core.math.Offset$Component$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.AffineTransformation$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;

public final class JtsShapeInterpreter$
implements ShapeInterpreter,
Serializable {
    private static final Geometry EmptyGeometry;
    public static final JtsShapeInterpreter$ MODULE$;

    private JtsShapeInterpreter$() {
    }

    static {
        MODULE$ = new JtsShapeInterpreter$();
        EmptyGeometry = Jts$.MODULE$.geometryFactory().createPoint();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JtsShapeInterpreter$.class);
    }

    private Geometry toGeometry(ShapeExpression e) {
        ShapeExpression shapeExpression = e;
        if (ShapeExpression$Empty$.MODULE$.equals(shapeExpression)) {
            return EmptyGeometry;
        }
        if (shapeExpression instanceof ShapeExpression.Ellipse) {
            ShapeExpression.Ellipse ellipse = ShapeExpression$Ellipse$.MODULE$.unapply((ShapeExpression.Ellipse)shapeExpression);
            Offset offset = ellipse._1();
            Offset offset2 = ellipse._2();
            Offset a = offset;
            Offset b = offset2;
            return this.safeRectangularBoundedShape$1(a, b, (Function1 & Serializable)_$2 -> _$2.createEllipse());
        }
        if (shapeExpression instanceof ShapeExpression.Polygon) {
            List<Offset> list;
            ShapeExpression.Polygon polygon = ShapeExpression$Polygon$.MODULE$.unapply((ShapeExpression.Polygon)shapeExpression);
            List<Offset> os = list = polygon._1();
            return this.safePolygon$1(os);
        }
        if (shapeExpression instanceof ShapeExpression.Rectangle) {
            ShapeExpression.Rectangle rectangle = ShapeExpression$Rectangle$.MODULE$.unapply((ShapeExpression.Rectangle)shapeExpression);
            Offset offset = rectangle._1();
            Offset offset3 = rectangle._2();
            Offset a = offset;
            Offset b = offset3;
            return this.safeRectangularBoundedShape$1(a, b, (Function1 & Serializable)_$3 -> _$3.createRectangle());
        }
        if (shapeExpression instanceof ShapeExpression.Point) {
            Offset offset;
            ShapeExpression.Point point = ShapeExpression$Point$.MODULE$.unapply((ShapeExpression.Point)shapeExpression);
            Offset a = offset = point._1();
            return syntax$all$.MODULE$.point(a);
        }
        if (shapeExpression instanceof ShapeExpression.BoundingBox) {
            ShapeExpression.BoundingBox boundingBox = ShapeExpression$BoundingBox$.MODULE$.unapply((ShapeExpression.BoundingBox)shapeExpression);
            ShapeExpression shapeExpression2 = boundingBox._1();
            ShapeExpression e2 = shapeExpression2;
            Tuple2<Offset, Offset> tuple2 = Jts$.MODULE$.boundingOffsets(this.toGeometry(e2));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Offset a = (Offset)tuple2._1();
            Offset b = (Offset)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
            Offset a2 = (Offset)tuple22._1();
            Offset b2 = (Offset)tuple22._2();
            return this.safeRectangularBoundedShape$1(a2, b2, (Function1 & Serializable)_$4 -> _$4.createRectangle());
        }
        if (shapeExpression instanceof ShapeExpression.Difference) {
            ShapeExpression.Difference difference = ShapeExpression$Difference$.MODULE$.unapply((ShapeExpression.Difference)shapeExpression);
            ShapeExpression shapeExpression3 = difference._1();
            ShapeExpression shapeExpression4 = difference._2();
            ShapeExpression a = shapeExpression3;
            ShapeExpression b = shapeExpression4;
            return this.toGeometry(a).difference(this.toGeometry(b));
        }
        if (shapeExpression instanceof ShapeExpression.Intersection) {
            ShapeExpression.Intersection intersection = ShapeExpression$Intersection$.MODULE$.unapply((ShapeExpression.Intersection)shapeExpression);
            ShapeExpression shapeExpression5 = intersection._1();
            ShapeExpression shapeExpression6 = intersection._2();
            ShapeExpression a = shapeExpression5;
            ShapeExpression b = shapeExpression6;
            return this.toGeometry(a).intersection(this.toGeometry(b));
        }
        if (shapeExpression instanceof ShapeExpression.Union) {
            ShapeExpression.Union union = ShapeExpression$Union$.MODULE$.unapply((ShapeExpression.Union)shapeExpression);
            ShapeExpression shapeExpression7 = union._1();
            ShapeExpression shapeExpression8 = union._2();
            ShapeExpression a = shapeExpression7;
            ShapeExpression b = shapeExpression8;
            return this.toGeometry(a).union(this.toGeometry(b));
        }
        if (shapeExpression instanceof ShapeExpression.FlipP) {
            ShapeExpression shapeExpression9;
            ShapeExpression.FlipP flipP = ShapeExpression$FlipP$.MODULE$.unapply((ShapeExpression.FlipP)shapeExpression);
            ShapeExpression e3 = shapeExpression9 = flipP._1();
            return AffineTransformation$.MODULE$.scaleInstance(-1.0, 1.0).transform(this.toGeometry(e3));
        }
        if (shapeExpression instanceof ShapeExpression.FlipQ) {
            ShapeExpression shapeExpression10;
            ShapeExpression.FlipQ flipQ = ShapeExpression$FlipQ$.MODULE$.unapply((ShapeExpression.FlipQ)shapeExpression);
            ShapeExpression e4 = shapeExpression10 = flipQ._1();
            return AffineTransformation$.MODULE$.scaleInstance(1.0, -1.0).transform(this.toGeometry(e4));
        }
        if (shapeExpression instanceof ShapeExpression.Rotate) {
            ShapeExpression.Rotate rotate = ShapeExpression$Rotate$.MODULE$.unapply((ShapeExpression.Rotate)shapeExpression);
            ShapeExpression shapeExpression11 = rotate._1();
            long l = rotate._2();
            ShapeExpression e5 = shapeExpression11;
            long a = l;
            Angle$package$ angle$package$ = Angle$package$.MODULE$;
            Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
            long angle$proxy1 = a;
            return AffineTransformation$.MODULE$.rotationInstance(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this.toDoubleDegrees(angle$proxy1)))).transform(this.toGeometry(e5));
        }
        if (shapeExpression instanceof ShapeExpression.RotateAroundOffset) {
            ShapeExpression.RotateAroundOffset rotateAroundOffset = ShapeExpression$RotateAroundOffset$.MODULE$.unapply((ShapeExpression.RotateAroundOffset)shapeExpression);
            ShapeExpression shapeExpression12 = rotateAroundOffset._1();
            long l = rotateAroundOffset._2();
            Offset offset = rotateAroundOffset._3();
            ShapeExpression e6 = shapeExpression12;
            long a = l;
            Offset o = offset;
            Coordinate c = syntax$all$.MODULE$.coordinate(o);
            Angle$package$ angle$package$ = Angle$package$.MODULE$;
            Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
            long angle$proxy2 = a;
            return AffineTransformation$.MODULE$.rotationInstance(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this.toDoubleDegrees(angle$proxy2))), c.x(), c.y()).transform(this.toGeometry(e6));
        }
        if (shapeExpression instanceof ShapeExpression.Translate) {
            ShapeExpression.Translate translate = ShapeExpression$Translate$.MODULE$.unapply((ShapeExpression.Translate)shapeExpression);
            ShapeExpression shapeExpression13 = translate._1();
            Offset offset = translate._2();
            ShapeExpression e7 = shapeExpression13;
            Offset o = offset;
            Coordinate c = syntax$all$.MODULE$.coordinate(o);
            return AffineTransformation$.MODULE$.translationInstance(c.x(), c.y()).transform(this.toGeometry(e7));
        }
        throw new MatchError((Object)shapeExpression);
    }

    @Override
    public Shape interpret(ShapeExpression e) {
        return JtsShape$.MODULE$.apply(this.toGeometry(e));
    }

    private final Geometry safeRectangularBoundedShape$1(Offset a, Offset b, Function1 f) {
        if (package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToLong((long)a.p()), Offset$Component$.MODULE$.orderComponent()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)b.p())) || package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToLong((long)a.q()), Offset$Component$.MODULE$.orderComponent()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)b.q()))) {
            return EmptyGeometry;
        }
        return (Geometry)f.apply((Object)syntax$all$.MODULE$.shapeFactory(a, b));
    }

    private final Geometry safePolygon$1(List os) {
        List list;
        if (os.toSet().size() < 3) {
            return EmptyGeometry;
        }
        if (package.all$.MODULE$.catsSyntaxEq(os.head(), Offset$.MODULE$.given_Order_Offset()).$eq$eq$eq(os.last())) {
            list = os;
        } else {
            Offset offset = (Offset)os.last();
            list = os.$colon$colon((Object)offset);
        }
        List os2 = list;
        return Jts$.MODULE$.geometryFactory().createPolygon((Coordinate[])os2.map((Function1 & Serializable)_$1 -> syntax$all$.MODULE$.coordinate((Offset)_$1)).toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
    }
}

