/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math;

import cats.Foldable;
import cats.Show;
import cats.Show$;
import cats.kernel.Eq$;
import cats.kernel.Monoid;
import cats.kernel.Order;
import cats.kernel.Semigroup$;
import cats.package$;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.core.math.Coordinates;
import lucuma.core.math.CoordinatesOptics;
import lucuma.core.math.Declination;
import lucuma.core.math.Declination$;
import lucuma.core.math.RightAscension;
import lucuma.core.math.RightAscension$;
import lucuma.core.math.package$package$;
import lucuma.core.optics.Format;
import monocle.PLens;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class Coordinates$
implements CoordinatesOptics,
Mirror.Product,
Serializable {
    private static Format fromHmsDms;
    private static PLens rightAscension;
    private static PLens declination;
    private static final Coordinates Zero;
    private static final Coordinates SouthPole;
    private static final Coordinates NorthPole;
    private volatile Object given_Order_Coordinates$lzy1;
    private volatile Object given_Show_Coordinates$lzy1;
    public static final Coordinates$ MODULE$;

    private Coordinates$() {
    }

    static {
        MODULE$ = new Coordinates$();
        CoordinatesOptics.$init$(MODULE$);
        Zero = MODULE$.apply(package$package$.MODULE$.RA().Zero(), package$package$.MODULE$.Dec().Zero());
        SouthPole = MODULE$.apply(package$package$.MODULE$.RA().Zero(), package$package$.MODULE$.Dec().Min());
        NorthPole = MODULE$.apply(package$package$.MODULE$.RA().Zero(), package$package$.MODULE$.Dec().Max());
        Statics.releaseFence();
    }

    public Format fromHmsDms() {
        return fromHmsDms;
    }

    public PLens rightAscension() {
        return rightAscension;
    }

    public PLens declination() {
        return declination;
    }

    @Override
    public void lucuma$core$math$CoordinatesOptics$_setter_$fromHmsDms_$eq(Format x$0) {
        fromHmsDms = x$0;
    }

    @Override
    public void lucuma$core$math$CoordinatesOptics$_setter_$rightAscension_$eq(PLens x$0) {
        rightAscension = x$0;
    }

    @Override
    public void lucuma$core$math$CoordinatesOptics$_setter_$declination_$eq(PLens x$0) {
        declination = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Coordinates$.class);
    }

    public Coordinates apply(RightAscension ra, Declination dec) {
        return new Coordinates(ra, dec);
    }

    public Coordinates unapply(Coordinates x$1) {
        return x$1;
    }

    public Coordinates Zero() {
        return Zero;
    }

    public Coordinates SouthPole() {
        return SouthPole;
    }

    public Coordinates NorthPole() {
        return NorthPole;
    }

    public Option<Coordinates> fromRadians(double ra, double dec) {
        return Declination$.MODULE$.fromRadians(dec).map((Function1 & Serializable)_$2 -> MODULE$.apply(package$package$.MODULE$.RA().fromRadians(ra), (Declination)_$2));
    }

    public Coordinates unsafeFromRadians(double ra, double dec) {
        return this.apply(package$package$.MODULE$.RA().fromRadians(ra), Declination$.MODULE$.unsafeFromRadians(dec));
    }

    public <F> Coordinates centerOf(Object coords, Foldable<F> evidence$1) {
        Tuple3 tuple3 = (Tuple3)package.all$.MODULE$.toFoldableOps(coords, evidence$1).foldMap((Function1 & Serializable)x$1 -> {
            Coordinates coordinates = x$1;
            if (coordinates != null) {
                Coordinates coordinates2 = MODULE$.unapply(coordinates);
                RightAscension rightAscension = coordinates2._1();
                Declination declination = coordinates2._2();
                RightAscension ra = rightAscension;
                Declination dec = declination;
                return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(Math.cos(dec.toRadians()) * Math.cos(ra.toRadians()))), (Object)BoxesRunTime.boxToDouble((double)(Math.cos(dec.toRadians()) * Math.sin(ra.toRadians()))), (Object)BoxesRunTime.boxToDouble((double)Math.sin(dec.toRadians())));
            }
            throw new MatchError((Object)coordinates);
        }, (Monoid)Semigroup$.MODULE$.catsKernelCommutativeGroupForTuple3(Semigroup$.MODULE$.catsKernelCommutativeGroupForDouble(), Semigroup$.MODULE$.catsKernelCommutativeGroupForDouble(), Semigroup$.MODULE$.catsKernelCommutativeGroupForDouble()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double x0 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double y0 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double z0 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x0), (Object)BoxesRunTime.boxToDouble((double)y0), (Object)BoxesRunTime.boxToDouble((double)z0));
        double x02 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double y02 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double z02 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        long count = package.all$.MODULE$.toUnorderedFoldableOps(coords, evidence$1).size();
        Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(x02 / (double)count)), (Object)BoxesRunTime.boxToDouble((double)(y02 / (double)count)), (Object)BoxesRunTime.boxToDouble((double)(z02 / (double)count)));
        double x = BoxesRunTime.unboxToDouble((Object)tuple33._1());
        double y = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        double z = BoxesRunTime.unboxToDouble((Object)tuple33._3());
        double ra = Math.atan2(y, x);
        double hyp = Math.hypot(x, y);
        double dec = Math.atan2(z, hyp);
        return this.apply(RightAscension$.MODULE$.fromRadians(ra), Declination$.MODULE$.unsafeFromRadians(dec));
    }

    public final Order<Coordinates> given_Order_Coordinates() {
        Object object = this.given_Order_Coordinates$lzy1;
        if (object instanceof Order) {
            return (Order)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Order)this.given_Order_Coordinates$lzyINIT1();
    }

    private Object given_Order_Coordinates$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Order_Coordinates$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Order order = null;
                    try {
                        order = package$.MODULE$.Order().by((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.ra(), (Object)c.dec()), Eq$.MODULE$.catsKernelOrderForTuple2(RightAscension$.MODULE$.given_Order_RightAscension(), Declination$.MODULE$.given_Order_Declination()));
                        object2 = order == null ? LazyVals.NullValue$.MODULE$ : order;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Order_Coordinates$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return order;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Show<Coordinates> given_Show_Coordinates() {
        Object object = this.given_Show_Coordinates$lzy1;
        if (object instanceof Show) {
            return (Show)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Show)this.given_Show_Coordinates$lzyINIT1();
    }

    private Object given_Show_Coordinates$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Show_Coordinates$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Show show = null;
                    try {
                        show = Show$.MODULE$.fromToString();
                        object2 = show == null ? LazyVals.NullValue$.MODULE$ : show;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Show_Coordinates$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return show;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Coordinates.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Coordinates fromProduct(Product x$0) {
        return new Coordinates((RightAscension)x$0.productElement(0), (Declination)x$0.productElement(1));
    }
}

