/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math;

import cats.Foldable;
import cats.Show;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.core.math.Angle$package$;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Coordinates$;
import lucuma.core.math.CoordinatesDiff;
import lucuma.core.math.CoordinatesDiff$;
import lucuma.core.math.Declination;
import lucuma.core.math.Declination$;
import lucuma.core.math.Offset;
import lucuma.core.math.Offset$;
import lucuma.core.math.RightAscension;
import lucuma.core.math.RightAscension$;
import lucuma.core.math.package$package$;
import lucuma.core.optics.Format;
import lucuma.core.optics.syntax.PrismOps$;
import lucuma.core.syntax.package$all$;
import monocle.PLens;
import monocle.PPrism;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public final class Coordinates
implements Product,
Serializable {
    private final RightAscension ra;
    private final Declination dec;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Coordinates$.class.getDeclaredField("given_Show_Coordinates$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Coordinates$.class.getDeclaredField("given_Order_Coordinates$lzy1"));

    public static Coordinates NorthPole() {
        return Coordinates$.MODULE$.NorthPole();
    }

    public static Coordinates SouthPole() {
        return Coordinates$.MODULE$.SouthPole();
    }

    public static Coordinates Zero() {
        return Coordinates$.MODULE$.Zero();
    }

    public static Coordinates apply(RightAscension rightAscension, Declination declination) {
        return Coordinates$.MODULE$.apply(rightAscension, declination);
    }

    public static <F> Coordinates centerOf(Object object, Foldable<F> foldable) {
        return Coordinates$.MODULE$.centerOf(object, foldable);
    }

    public static PLens declination() {
        return Coordinates$.MODULE$.declination();
    }

    public static Format fromHmsDms() {
        return Coordinates$.MODULE$.fromHmsDms();
    }

    public static Coordinates fromProduct(Product product) {
        return Coordinates$.MODULE$.fromProduct(product);
    }

    public static Option<Coordinates> fromRadians(double d, double d2) {
        return Coordinates$.MODULE$.fromRadians(d, d2);
    }

    public static Order<Coordinates> given_Order_Coordinates() {
        return Coordinates$.MODULE$.given_Order_Coordinates();
    }

    public static Show<Coordinates> given_Show_Coordinates() {
        return Coordinates$.MODULE$.given_Show_Coordinates();
    }

    public static PLens rightAscension() {
        return Coordinates$.MODULE$.rightAscension();
    }

    public static Coordinates unapply(Coordinates coordinates) {
        return Coordinates$.MODULE$.unapply(coordinates);
    }

    public static Coordinates unsafeFromRadians(double d, double d2) {
        return Coordinates$.MODULE$.unsafeFromRadians(d, d2);
    }

    public static /* synthetic */ void lucuma$core$math$CoordinatesOptics$_setter_$declination_$eq(PLens pLens) {
        Coordinates$.MODULE$.lucuma$core$math$CoordinatesOptics$_setter_$declination_$eq(pLens);
    }

    public static /* synthetic */ void lucuma$core$math$CoordinatesOptics$_setter_$fromHmsDms_$eq(Format format) {
        Coordinates$.MODULE$.lucuma$core$math$CoordinatesOptics$_setter_$fromHmsDms_$eq(format);
    }

    public static /* synthetic */ void lucuma$core$math$CoordinatesOptics$_setter_$rightAscension_$eq(PLens pLens) {
        Coordinates$.MODULE$.lucuma$core$math$CoordinatesOptics$_setter_$rightAscension_$eq(pLens);
    }

    public Coordinates(RightAscension ra, Declination dec) {
        this.ra = ra;
        this.dec = dec;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Coordinates)) return false;
        Coordinates coordinates = (Coordinates)object;
        RightAscension rightAscension = this.ra();
        RightAscension rightAscension2 = coordinates.ra();
        if (rightAscension == null) {
            if (rightAscension2 != null) {
                return false;
            }
        } else if (!((Object)rightAscension).equals(rightAscension2)) return false;
        Declination declination = this.dec();
        Declination declination2 = coordinates.dec();
        if (declination == null) {
            if (declination2 == null) return true;
            return false;
        } else {
            if (!((Object)declination).equals(declination2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Coordinates;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Coordinates";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "ra";
        }
        if (1 == n2) {
            return "dec";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public RightAscension ra() {
        return this.ra;
    }

    public Declination dec() {
        return this.dec;
    }

    public Tuple2<Coordinates, Object> shiftWithCarry(long dRA, long dDec) {
        Tuple2<Declination, Object> tuple2 = this.dec().offset(dDec);
        if (tuple2 != null) {
            Declination declination = (Declination)tuple2._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Declination dec\u02b9 = declination;
            if (!bl) {
                return Tuple2$.MODULE$.apply((Object)Coordinates$.MODULE$.apply(this.ra().offset(dRA), dec\u02b9), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Declination dec\u02b92 = declination;
            if (bl) {
                return Tuple2$.MODULE$.apply((Object)Coordinates$.MODULE$.apply(this.ra().flip().offset(dRA), dec\u02b92), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        throw new MatchError(tuple2);
    }

    public Coordinates shift(long dRA, long dDec) {
        return (Coordinates)this.shiftWithCarry(dRA, dDec)._1();
    }

    public CoordinatesDiff diff(Coordinates x) {
        double d;
        double dist;
        double alf = x.ra().toRadians();
        double alf0 = this.ra().toRadians();
        double limitDistance = 4.0E-7;
        Angle$package$ angle$package$ = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
        long angle$proxy1 = this.dec().toAngle();
        Angle$package$ angle$package$2 = angle$package$;
        Angle$package$Angle$ Angle$_this2 = Angle$_this;
        long angle$proxy2 = angle$proxy1;
        double sd0 = Math.sin(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this2.toDoubleDegrees(angle$proxy2))));
        Angle$package$ angle$package$3 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this3 = Angle$package$Angle$.MODULE$;
        long angle$proxy3 = x.dec().toAngle();
        Angle$package$ angle$package$4 = angle$package$3;
        Angle$package$Angle$ Angle$_this4 = Angle$_this3;
        long angle$proxy4 = angle$proxy3;
        double sd = Math.sin(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this4.toDoubleDegrees(angle$proxy4))));
        Angle$package$ angle$package$5 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this5 = Angle$package$Angle$.MODULE$;
        long angle$proxy5 = this.dec().toAngle();
        Angle$package$ angle$package$6 = angle$package$5;
        Angle$package$Angle$ Angle$_this6 = Angle$_this5;
        long angle$proxy6 = angle$proxy5;
        double cd0 = Math.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this6.toDoubleDegrees(angle$proxy6))));
        Angle$package$ angle$package$7 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this7 = Angle$package$Angle$.MODULE$;
        long angle$proxy7 = x.dec().toAngle();
        Angle$package$ angle$package$8 = angle$package$7;
        Angle$package$Angle$ Angle$_this8 = Angle$_this7;
        long angle$proxy8 = angle$proxy7;
        double cd = Math.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this8.toDoubleDegrees(angle$proxy8))));
        Angle$package$ angle$package$9 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this9 = Angle$package$Angle$.MODULE$;
        long angle$proxy9 = Angle$package$Angle$.MODULE$.minusAngle(x.ra().toAngle(), this.ra().toAngle());
        Angle$package$ angle$package$10 = Angle$package$.MODULE$;
        Angle$package$ angle$package$11 = angle$package$9;
        Angle$package$Angle$ Angle$_this10 = Angle$_this9;
        long angle$proxy10 = angle$proxy9;
        double cosda = Math.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this10.toDoubleDegrees(angle$proxy10))));
        double cosd = sd0 * sd + cd0 * cd * cosda;
        double acosValue = Math.acos(cosd);
        double d2 = dist = Predef$.MODULE$.double2Double(acosValue).isNaN() ? 0.0 : acosValue;
        if (dist > limitDistance) {
            double sind = Math.sin(dist);
            double pcospa = (sd * cd0 - cd * sd0 * cosda) / sind;
            double absValue = Math.abs(pcospa);
            double cospa = absValue > 1.0 ? pcospa / absValue : pcospa;
            double sinpa = cd * Math.sin(alf - alf0) / sind;
            double pphi = Math.acos(cospa);
            d = sinpa < 0.0 ? Math.PI * 2 - pphi : pphi;
        } else {
            d = 0.0;
        }
        double phi = d;
        return CoordinatesDiff$.MODULE$.apply(Angle$package$Angle$.MODULE$.fromDoubleDegrees(phi * 180.0 / Math.PI), Angle$package$Angle$.MODULE$.fromDoubleDegrees(dist * 180.0 / Math.PI));
    }

    public long angularDistance(Coordinates that) {
        Angle$package$ angle$package$ = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
        long angle$proxy11 = this.dec().toAngle();
        double \u03c61 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this.toDoubleDegrees(angle$proxy11)));
        Angle$package$ angle$package$2 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this2 = Angle$package$Angle$.MODULE$;
        long angle$proxy12 = that.dec().toAngle();
        double \u03c62 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this2.toDoubleDegrees(angle$proxy12)));
        Angle$package$ angle$package$3 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this3 = Angle$package$Angle$.MODULE$;
        long angle$proxy13 = Angle$package$Angle$.MODULE$.minusAngle(that.dec().toAngle(), this.dec().toAngle());
        double \u0394\u03c6 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this3.toDoubleDegrees(angle$proxy13)));
        Angle$package$ angle$package$4 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this4 = Angle$package$Angle$.MODULE$;
        long angle$proxy14 = Angle$package$Angle$.MODULE$.minusAngle(that.ra().toAngle(), this.ra().toAngle());
        double \u0394\u03bb = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this4.toDoubleDegrees(angle$proxy14)));
        double a = Math.sin(\u0394\u03c6 / (double)2) * Math.sin(\u0394\u03c6 / (double)2) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.sin(\u0394\u03bb / (double)2) * Math.sin(\u0394\u03bb / (double)2);
        return Angle$package$Angle$.MODULE$.fromDoubleRadians((double)2 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)));
    }

    public Coordinates interpolate(Coordinates that, double f) {
        Angle$package$ angle$package$ = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
        long angle$proxy15 = this.angularDistance(that);
        double \u03b4 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this.toDoubleDegrees(angle$proxy15)));
        if (package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToDouble((double)\u03b4), (Eq)Eq$.MODULE$.catsKernelInstancesForDouble()).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0))) {
            return this;
        }
        Angle$package$ angle$package$2 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this2 = Angle$package$Angle$.MODULE$;
        long angle$proxy16 = this.dec().toAngle();
        double \u03c61 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this2.toDoubleDegrees(angle$proxy16)));
        Angle$package$ angle$package$3 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this3 = Angle$package$Angle$.MODULE$;
        long angle$proxy17 = that.dec().toAngle();
        double \u03c62 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this3.toDoubleDegrees(angle$proxy17)));
        Angle$package$ angle$package$4 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this4 = Angle$package$Angle$.MODULE$;
        long angle$proxy18 = this.ra().toAngle();
        double \u03bb1 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this4.toDoubleDegrees(angle$proxy18)));
        Angle$package$ angle$package$5 = Angle$package$.MODULE$;
        Angle$package$Angle$ Angle$_this5 = Angle$package$Angle$.MODULE$;
        long angle$proxy19 = that.ra().toAngle();
        double \u03bb2 = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this5.toDoubleDegrees(angle$proxy19)));
        double a = Math.sin((1.0 - f) * \u03b4) / Math.sin(\u03b4);
        double b = Math.sin(f * \u03b4) / Math.sin(\u03b4);
        double x = a * Math.cos(\u03c61) * Math.cos(\u03bb1) + b * Math.cos(\u03c62) * Math.cos(\u03bb2);
        double y = a * Math.cos(\u03c61) * Math.sin(\u03bb1) + b * Math.cos(\u03c62) * Math.sin(\u03bb2);
        double z = a * Math.sin(\u03c61) + b * Math.sin(\u03c62);
        double \u03c6i = Math.atan2(z, Math.sqrt(x * x + y * y));
        double \u03bbi = Math.atan2(y, x);
        PPrism pPrism = package$all$.MODULE$.ToPrismOps(package$package$.MODULE$.Dec().fromAngle());
        return Coordinates$.MODULE$.apply((RightAscension)package$package$.MODULE$.RA().fromHourAngle().get((Object)BoxesRunTime.boxToLong((long)Angle$package$Angle$.MODULE$.hourAngle().get().apply$mcJJ$sp(Angle$package$Angle$.MODULE$.fromDoubleRadians(\u03bbi)))), (Declination)PrismOps$.MODULE$.unsafeGet$extension(pPrism, BoxesRunTime.boxToLong((long)Angle$package$Angle$.MODULE$.fromDoubleRadians(\u03c6i))));
    }

    public Option<Coordinates> offsetBy(long posAngle, Offset offset) {
        if (package.all$.MODULE$.catsSyntaxEq((Object)offset, Offset$.MODULE$.given_Order_Offset()).$eq$bang$eq((Object)Offset$.MODULE$.Zero())) {
            Angle$package$ angle$package$ = Angle$package$.MODULE$;
            Angle$package$Angle$ Angle$_this = Angle$package$Angle$.MODULE$;
            long angle$proxy20 = posAngle;
            Angle$package$ angle$package$2 = angle$package$;
            Angle$package$Angle$ Angle$_this2 = Angle$_this;
            long angle$proxy21 = angle$proxy20;
            double paCos = Math.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this2.toDoubleDegrees(angle$proxy21))));
            Angle$package$ angle$package$3 = Angle$package$.MODULE$;
            Angle$package$Angle$ Angle$_this3 = Angle$package$Angle$.MODULE$;
            long angle$proxy22 = posAngle;
            Angle$package$ angle$package$4 = angle$package$3;
            Angle$package$Angle$ Angle$_this4 = Angle$_this3;
            long angle$proxy23 = angle$proxy22;
            double paSin = Math.sin(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this4.toDoubleDegrees(angle$proxy23))));
            Offset$ offset$ = Offset$.MODULE$;
            long component$proxy1 = offset.p();
            double pDeg = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(Angle$package$Angle$.MODULE$.fromMicroarcseconds(component$proxy1));
            Offset$ offset$2 = Offset$.MODULE$;
            long component$proxy2 = offset.q();
            double qDeg = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(Angle$package$Angle$.MODULE$.fromMicroarcseconds(component$proxy2));
            double dRa = pDeg * paCos + qDeg * paSin;
            double dDec = -pDeg * paSin + qDeg * paCos;
            Angle$package$ angle$package$5 = Angle$package$.MODULE$;
            Angle$package$Angle$ Angle$_this5 = Angle$package$Angle$.MODULE$;
            long angle$proxy24 = this.dec().toAngle();
            Angle$package$ angle$package$6 = angle$package$5;
            Angle$package$Angle$ Angle$_this6 = Angle$_this5;
            long angle$proxy25 = angle$proxy24;
            double decCos = Math.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(Angle$_this6.toDoubleDegrees(angle$proxy25))));
            return Declination$.MODULE$.fromDoubleDegrees(Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(this.dec().toAngle()) + dDec).filter((Function1 & Serializable)_$1 -> decCos != 0.0).map((Function1 & Serializable)dec -> {
                RightAscension newRa = RightAscension$.MODULE$.fromDoubleDegrees(Angle$package$Angle$.MODULE$.toDoubleDegrees(this.ra().toAngle()) + dRa / decCos);
                return Coordinates$.MODULE$.apply(newRa, (Declination)dec);
            });
        }
        Coordinates coordinates = (Coordinates)package.all$.MODULE$.catsSyntaxOptionId((Object)this);
        return OptionIdOps$.MODULE$.some$extension((Object)coordinates);
    }

    public Tuple2<Object, Object> toRadians() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.ra().toRadians()), (Object)BoxesRunTime.boxToDouble((double)this.dec().toRadians()));
    }

    public String toString() {
        return Coordinates$.MODULE$.fromHmsDms().productToString(this, $less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl());
    }

    public Coordinates copy(RightAscension ra, Declination dec) {
        return new Coordinates(ra, dec);
    }

    public RightAscension copy$default$1() {
        return this.ra();
    }

    public Declination copy$default$2() {
        return this.dec();
    }

    public RightAscension _1() {
        return this.ra();
    }

    public Declination _2() {
        return this.dec();
    }
}

