/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math;

import cats.Show;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.package;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.cats.package$;
import eu.timepit.refined.internal.WitnessAs$;
import eu.timepit.refined.numeric;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lucuma.core.math.Epoch$;
import lucuma.core.math.Epoch$Scheme$;
import lucuma.core.optics.Format;
import lucuma.core.optics.syntax.PrismOps$;
import lucuma.core.optics.syntax.package$all$;
import monocle.PPrism;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;

public final class Epoch {
    private final Scheme scheme;
    private final int toMilliyears;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Epoch$.class.getDeclaredField("given_Show_Epoch$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Epoch$.class.getDeclaredField("given_Order_Epoch$lzy1"));

    public static Epoch B1950() {
        return Epoch$.MODULE$.B1950();
    }

    public static Epoch J2000() {
        return Epoch$.MODULE$.J2000();
    }

    public static PPrism fromString() {
        return Epoch$.MODULE$.fromString();
    }

    public static Format fromStringNoScheme() {
        return Epoch$.MODULE$.fromStringNoScheme();
    }

    public static Order<Epoch> given_Order_Epoch() {
        return Epoch$.MODULE$.given_Order_Epoch();
    }

    public static Show<Epoch> given_Show_Epoch() {
        return Epoch$.MODULE$.given_Show_Epoch();
    }

    public static /* synthetic */ void lucuma$core$math$EpochOptics$_setter_$fromString_$eq(PPrism pPrism) {
        Epoch$.MODULE$.lucuma$core$math$EpochOptics$_setter_$fromString_$eq(pPrism);
    }

    public static /* synthetic */ void lucuma$core$math$EpochOptics$_setter_$fromStringNoScheme_$eq(Format format) {
        Epoch$.MODULE$.lucuma$core$math$EpochOptics$_setter_$fromStringNoScheme_$eq(format);
    }

    public Epoch(Scheme scheme, int toMilliyears) {
        this.scheme = scheme;
        this.toMilliyears = toMilliyears;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public int toMilliyears() {
        return this.toMilliyears;
    }

    public double epochYear() {
        return (double)BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)this.toMilliyears()))) / 1000.0;
    }

    public double untilInstant(Instant i) {
        return this.untilLocalDateTime(LocalDateTime.ofInstant(i, ZoneOffset.UTC));
    }

    public double untilLocalDateTime(LocalDateTime ldt) {
        return this.untilJulianDay(Epoch$Scheme$.MODULE$.toJulianDay(ldt));
    }

    public double untilJulianDay(double jd) {
        return this.untilEpochYear(this.scheme().fromJulianDayToEpochYears(jd));
    }

    public double untilEpochYear(double epochYear) {
        return epochYear - this.epochYear();
    }

    public Option<Epoch> plusYears(double y) {
        return this.scheme().fromEpochYears(this.epochYear() + y);
    }

    public boolean equals(Object a) {
        Object object = a;
        if (object instanceof Epoch) {
            Epoch e = (Epoch)object;
            return package.all$.MODULE$.catsSyntaxEq((Object)this.scheme(), Epoch$Scheme$.MODULE$.given_Order_Scheme()).$eq$eq$eq((Object)e.scheme()) && package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToInteger((int)this.toMilliyears()), (Eq)package$.MODULE$.refTypeOrder((Order)Eq$.MODULE$.catsKernelInstancesForInt(), RefType$.MODULE$.refinedRefType())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)e.toMilliyears()));
        }
        return false;
    }

    public int hashCode() {
        return this.scheme().hashCode() ^ BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)this.toMilliyears())));
    }

    public String toString() {
        PPrism pPrism = package$all$.MODULE$.ToPrismOps(Epoch$.MODULE$.fromString());
        return PrismOps$.MODULE$.asFormat$extension(pPrism).taggedToString("Epoch", this, $less$colon$less$.MODULE$.refl());
    }

    public static abstract class Scheme {
        private final char prefix;
        private final double yearBasis;
        private final double julianBasis;
        private final double lengthOfYear;
        public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Epoch$Scheme$.class.getDeclaredField("given_Show_Scheme$lzy1"));
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Epoch$Scheme$.class.getDeclaredField("given_Order_Scheme$lzy1"));

        public static Order<Scheme> given_Order_Scheme() {
            return Epoch$Scheme$.MODULE$.given_Order_Scheme();
        }

        public static Show<Scheme> given_Show_Scheme() {
            return Epoch$Scheme$.MODULE$.given_Show_Scheme();
        }

        public static int ordinal(Scheme scheme) {
            return Epoch$Scheme$.MODULE$.ordinal(scheme);
        }

        public static double toJulianDay(LocalDateTime localDateTime) {
            return Epoch$Scheme$.MODULE$.toJulianDay(localDateTime);
        }

        public Scheme(char prefix, double yearBasis, double julianBasis, double lengthOfYear) {
            this.prefix = prefix;
            this.yearBasis = yearBasis;
            this.julianBasis = julianBasis;
            this.lengthOfYear = lengthOfYear;
        }

        public char prefix() {
            return this.prefix;
        }

        public double yearBasis() {
            return this.yearBasis;
        }

        public double julianBasis() {
            return this.julianBasis;
        }

        public double lengthOfYear() {
            return this.lengthOfYear;
        }

        public Epoch fromIntegralYears(int years) {
            return this.fromMilliyearsUnsafe(BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)years))) * 1000);
        }

        public Epoch fromMilliyears(int mys) {
            return new Epoch(this, mys);
        }

        public Option<Epoch> fromIntMilliyears(int mys) {
            return eu.timepit.refined.package$.MODULE$.refineV().apply((Object)BoxesRunTime.boxToInteger((int)mys), boolean.And$.MODULE$.andValidate(boolean.Not$.MODULE$.notValidate(numeric.Less$.MODULE$.lessValidate(WitnessAs$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1900000), (Object)BoxesRunTime.boxToInteger((int)1900000)), (Numeric)Numeric.IntIsIntegral$.MODULE$)), boolean.Not$.MODULE$.notValidate(numeric.Greater$.MODULE$.greaterValidate(WitnessAs$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3000999), (Object)BoxesRunTime.boxToInteger((int)3000999)), (Numeric)Numeric.IntIsIntegral$.MODULE$)))).map((Function1 & Serializable)_$1 -> this.fromIntMilliyears$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1))).toOption();
        }

        public Epoch fromMilliyearsUnsafe(int mys) {
            return (Epoch)this.fromIntMilliyears(mys).get();
        }

        public Option<Epoch> fromLocalDateTime(LocalDateTime ldt) {
            return this.fromJulianDay(Epoch$Scheme$.MODULE$.toJulianDay(ldt));
        }

        public Option<Epoch> fromJulianDay(double jd) {
            return this.fromEpochYears(this.fromJulianDayToEpochYears(jd));
        }

        public Option<Epoch> fromEpochYears(double epochYear) {
            return this.fromIntMilliyears((int)(epochYear * 1000.0));
        }

        public double fromLocalDateTimeToEpochYears(LocalDateTime ldt) {
            return this.fromJulianDayToEpochYears(Epoch$Scheme$.MODULE$.toJulianDay(ldt));
        }

        public double fromJulianDayToEpochYears(double jd) {
            return this.yearBasis() + (jd - this.julianBasis()) / this.lengthOfYear();
        }

        private final /* synthetic */ Epoch fromIntMilliyears$$anonfun$1(int _$1) {
            return new Epoch(this, _$1);
        }
    }
}

