/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math;

import cats.Show;
import cats.kernel.Order;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import lucuma.core.math.JulianDate$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class JulianDate
implements Product,
Serializable {
    private final int dayNumber;
    private final long nanoAdjustment;
    private final double toDouble;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(JulianDate$.class.getDeclaredField("given_Show_JulianDate$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JulianDate$.class.getDeclaredField("given_Order_JulianDate$lzy1"));

    public static Instant Epoch() {
        return JulianDate$.MODULE$.Epoch();
    }

    public static JulianDate J2000() {
        return JulianDate$.MODULE$.J2000();
    }

    public static int SecondsPerDay() {
        return JulianDate$.MODULE$.SecondsPerDay();
    }

    public static JulianDate fromDoubleApprox(double d) {
        return JulianDate$.MODULE$.fromDoubleApprox(d);
    }

    public static Order<JulianDate> given_Order_JulianDate() {
        return JulianDate$.MODULE$.given_Order_JulianDate();
    }

    public static Show<JulianDate> given_Show_JulianDate() {
        return JulianDate$.MODULE$.given_Show_JulianDate();
    }

    public static JulianDate ofInstant(Instant instant2) {
        return JulianDate$.MODULE$.ofInstant(instant2);
    }

    public static JulianDate ofLocalDateTime(LocalDateTime localDateTime) {
        return JulianDate$.MODULE$.ofLocalDateTime(localDateTime);
    }

    public static JulianDate unapply(JulianDate julianDate) {
        return JulianDate$.MODULE$.unapply(julianDate);
    }

    public JulianDate(int dayNumber, long nanoAdjustment) {
        this.dayNumber = dayNumber;
        this.nanoAdjustment = nanoAdjustment;
        if (dayNumber < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"dayNumber >= 0");
        }
        if (nanoAdjustment < JulianDate$.lucuma$core$math$JulianDate$$$MinAdjustment) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("nanoAdjustment >= " + JulianDate$.lucuma$core$math$JulianDate$$$MinAdjustment));
        }
        if (nanoAdjustment > JulianDate$.lucuma$core$math$JulianDate$$$MaxAdjustment) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("nanoAdjustment <= " + JulianDate$.lucuma$core$math$JulianDate$$$MaxAdjustment));
        }
        this.toDouble = (double)dayNumber + (double)nanoAdjustment / (double)JulianDate$.lucuma$core$math$JulianDate$$$NanoPerDay;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.dayNumber());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.nanoAdjustment()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JulianDate)) return false;
        JulianDate julianDate = (JulianDate)object;
        if (this.dayNumber() != julianDate.dayNumber()) return false;
        if (this.nanoAdjustment() != julianDate.nanoAdjustment()) return false;
        if (!julianDate.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof JulianDate;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "JulianDate";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger((int)this._1());
        }
        if (1 == n2) {
            return BoxesRunTime.boxToLong((long)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "dayNumber";
        }
        if (1 == n2) {
            return "nanoAdjustment";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int dayNumber() {
        return this.dayNumber;
    }

    public long nanoAdjustment() {
        return this.nanoAdjustment;
    }

    public double toDouble() {
        return this.toDouble;
    }

    public double toModifiedDouble() {
        long h = (long)JulianDate$.lucuma$core$math$JulianDate$$$SecondsPerHalfDay * (long)JulianDate$.lucuma$core$math$JulianDate$$$Billion;
        int d = this.dayNumber() - 2400000;
        long n = this.nanoAdjustment() - h;
        Tuple2.mcIJ.sp sp2 = n >= JulianDate$.lucuma$core$math$JulianDate$$$MinAdjustment ? new Tuple2.mcIJ.sp(d, n) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(d - 1)), (Object)BoxesRunTime.boxToLong((long)(n + (long)JulianDate$.MODULE$.SecondsPerDay() * (long)JulianDate$.lucuma$core$math$JulianDate$$$Billion)));
        int d\u02b9 = sp2._1$mcI$sp();
        long n\u02b9 = sp2._2$mcJ$sp();
        return (double)d\u02b9 + (double)n\u02b9 / (double)JulianDate$.lucuma$core$math$JulianDate$$$NanoPerDay;
    }

    public Instant toInstant() {
        return JulianDate$.MODULE$.Epoch().plus((long)this.dayNumber(), ChronoUnit.DAYS).plusNanos(this.nanoAdjustment());
    }

    public int _1() {
        return this.dayNumber();
    }

    public long _2() {
        return this.nanoAdjustment();
    }
}

