/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Constants$;
import lucuma.core.math.Coordinates;
import lucuma.core.math.Place;
import lucuma.core.math.skycalc.ImprovedSkyCalc$;
import lucuma.core.math.skycalc.ImprovedSkyCalcMethods;
import lucuma.core.math.skycalc.ImprovedSkyCalcMethods$DoubleRef$;
import lucuma.core.math.skycalc.SkyCalcResults;
import lucuma.core.math.skycalc.SkyCalcResults$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ImprovedSkyCalc
implements ImprovedSkyCalcMethods,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ImprovedSkyCalc.class.getDeclaredField("DoubleRef$lzy1"));
    private int XFORM_FROMSTD;
    private int XFORM_TOSTDEP;
    private int XFORM_JUSTPRE;
    private int XFORM_DOAPPAR;
    private double[] DELTS;
    private volatile Object DoubleRef$lzy1;
    private final Place place;
    private final double degreesLatitude;
    private final double hoursLongitude;
    private final double siteAltitude;

    public static ImprovedSkyCalc apply(Place place) {
        return ImprovedSkyCalc$.MODULE$.apply(place);
    }

    public static ImprovedSkyCalc fromProduct(Product product) {
        return ImprovedSkyCalc$.MODULE$.fromProduct(product);
    }

    public static ImprovedSkyCalc unapply(ImprovedSkyCalc improvedSkyCalc) {
        return ImprovedSkyCalc$.MODULE$.unapply(improvedSkyCalc);
    }

    public ImprovedSkyCalc(Place place) {
        this.place = place;
        ImprovedSkyCalcMethods.$init$(this);
        this.degreesLatitude = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place.latitude().toAngle());
        this.hoursLongitude = -Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place.longitude()) / (double)15;
        this.siteAltitude = place.altitudeDouble();
        Statics.releaseFence();
    }

    @Override
    public int XFORM_FROMSTD() {
        return this.XFORM_FROMSTD;
    }

    @Override
    public int XFORM_TOSTDEP() {
        return this.XFORM_TOSTDEP;
    }

    @Override
    public int XFORM_JUSTPRE() {
        return this.XFORM_JUSTPRE;
    }

    @Override
    public int XFORM_DOAPPAR() {
        return this.XFORM_DOAPPAR;
    }

    @Override
    public double[] DELTS() {
        return this.DELTS;
    }

    @Override
    public final ImprovedSkyCalcMethods$DoubleRef$ DoubleRef() {
        Object object = this.DoubleRef$lzy1;
        if (object instanceof ImprovedSkyCalcMethods$DoubleRef$) {
            return (ImprovedSkyCalcMethods$DoubleRef$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ImprovedSkyCalcMethods$DoubleRef$)this.DoubleRef$lzyINIT1();
    }

    private Object DoubleRef$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DoubleRef$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ImprovedSkyCalcMethods$DoubleRef$ improvedSkyCalcMethods$DoubleRef$ = null;
                    try {
                        improvedSkyCalcMethods$DoubleRef$ = new ImprovedSkyCalcMethods$DoubleRef$(this);
                        object2 = improvedSkyCalcMethods$DoubleRef$ == null ? LazyVals.NullValue$.MODULE$ : improvedSkyCalcMethods$DoubleRef$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DoubleRef$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return improvedSkyCalcMethods$DoubleRef$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_FROMSTD_$eq(int x$0) {
        this.XFORM_FROMSTD = x$0;
    }

    @Override
    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_TOSTDEP_$eq(int x$0) {
        this.XFORM_TOSTDEP = x$0;
    }

    @Override
    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_JUSTPRE_$eq(int x$0) {
        this.XFORM_JUSTPRE = x$0;
    }

    @Override
    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_DOAPPAR_$eq(int x$0) {
        this.XFORM_DOAPPAR = x$0;
    }

    @Override
    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$DELTS_$eq(double[] x$0) {
        this.DELTS = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ImprovedSkyCalc)) return false;
        ImprovedSkyCalc improvedSkyCalc = (ImprovedSkyCalc)object;
        Place place = this.place();
        Place place2 = improvedSkyCalc.place();
        if (place == null) {
            if (place2 != null) {
                return false;
            }
        } else if (!((Object)place).equals(place2)) return false;
        if (!improvedSkyCalc.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ImprovedSkyCalc;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ImprovedSkyCalc";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "place";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Place place() {
        return this.place;
    }

    public double degreesLatitude() {
        return this.degreesLatitude;
    }

    public double hoursLongitude() {
        return this.hoursLongitude;
    }

    public double siteAltitude() {
        return this.siteAltitude;
    }

    public SkyCalcResults calculate(Coordinates coords, Instant instant2, boolean calculateMoon) {
        ImprovedSkyCalcMethods.DoubleRef jdut = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef sid = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef curepoch = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        this.setup_time_place(instant2, this.hoursLongitude(), jdut, sid, curepoch);
        double objra = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(coords.ra().toAngle()) / (double)15;
        double objdec = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(coords.dec().toAngle());
        double objepoch = 2000.0;
        return this.getCircumstances(this.degreesLatitude(), this.siteAltitude(), objra, objdec, objepoch, curepoch.d(), sid.d(), this.degreesLatitude(), jdut, calculateMoon, coords);
    }

    private SkyCalcResults getCircumstances(double degreesLatitude, double siteAltitude, double objra, double objdec, double objepoch, double curep, double sid, double lat, ImprovedSkyCalcMethods.DoubleRef jdut, boolean calculateMoon, Coordinates coords) {
        Double lunarSkyBrightness = Predef$.MODULE$.double2Double(0.0);
        double lunarDistance = 0.0;
        double lunarIlluminatedFraction = 0.0;
        double totalSkyBrightness = 0.0;
        double lunarPhaseAngle = 0.0;
        double sunAltitude = 0.0;
        double lunarElevation = 0.0;
        ImprovedSkyCalcMethods.DoubleRef az = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef par = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef curra = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef curdec = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        this.cooxform(objra, objdec, objepoch, curep, curra, curdec, this.XFORM_JUSTPRE(), this.XFORM_FROMSTD());
        double ha = this.adj_time(sid - curra.d());
        double alt = this.altit(curdec.d(), ha, lat, az, par);
        double airmass = this.getAirmass(alt);
        double altitude = alt;
        double azimuth = az.d();
        double parallacticAngle = par.d();
        double hourAngle = ha;
        if (calculateMoon) {
            ImprovedSkyCalcMethods.DoubleRef ramoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef decmoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef distmoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef georamoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef geodecmoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef geodistmoon = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef rasun = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef decsun = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef distsun = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef x = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef y = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef z = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef toporasun = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            ImprovedSkyCalcMethods.DoubleRef topodecsun = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
            double elevsea = siteAltitude;
            this.accusun(jdut.d(), sid, degreesLatitude, rasun, decsun, distsun, toporasun, topodecsun, x, y, z);
            sunAltitude = this.altit(topodecsun.d(), sid - toporasun.d(), degreesLatitude, az, new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1()));
            this.accumoon(jdut.d(), degreesLatitude, sid, elevsea, georamoon, geodecmoon, geodistmoon, ramoon, decmoon, distmoon);
            lunarElevation = this.altit(decmoon.d(), sid - ramoon.d(), degreesLatitude, az, new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1()));
            lunarSkyBrightness = null;
            lunarDistance = Constants$.MODULE$.DegsInRadian() * this.subtend(ramoon.d(), decmoon.d(), objra, objdec);
            lunarPhaseAngle = Constants$.MODULE$.DegsInRadian() * this.subtend(ramoon.d(), decmoon.d(), toporasun.d(), topodecsun.d());
            if (lunarElevation > -2.0 && lunarElevation > 0.0 && altitude > 0.5 && sunAltitude < -9.0) {
                lunarSkyBrightness = Predef$.MODULE$.double2Double(this.lunskybright(lunarPhaseAngle, lunarDistance, Constants$.MODULE$.KZen(), lunarElevation, altitude, distmoon.d()));
            }
            totalSkyBrightness = this.sb(180.0 - lunarPhaseAngle, lunarDistance, 90.0 - lunarElevation, 90.0 - altitude, 90.0 - sunAltitude, distmoon.d());
            lunarIlluminatedFraction = 0.5 * (1.0 - Math.cos(this.subtend(ramoon.d(), decmoon.d(), rasun.d(), decsun.d())));
        }
        return SkyCalcResults$.MODULE$.apply(altitude, azimuth, parallacticAngle, airmass, hourAngle, (float)lunarIlluminatedFraction, Predef$.MODULE$.Double2double(lunarSkyBrightness), totalSkyBrightness, lunarPhaseAngle, sunAltitude, lunarDistance, lunarElevation, coords, this.place());
    }

    public double getSiderealTime(Instant instant2) {
        double jd = this.instant_to_jd(instant2);
        return this.lst(jd, this.hoursLongitude());
    }

    public ZonedDateTime getLst(Instant instant2) {
        double lstHours = this.getSiderealTime(instant2);
        return this.getLst(lstHours, instant2);
    }

    public ImprovedSkyCalc copy(Place place) {
        return new ImprovedSkyCalc(place);
    }

    public Place copy$default$1() {
        return this.place();
    }

    public Place _1() {
        return this.place();
    }
}

