/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import coulomb.ops.SimplifiedUnit;
import coulomb.ops.standard.div;
import coulomb.policy.spire.standard$;
import coulomb.quantity;
import coulomb.quantity$package$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lucuma.core.math.Constants$;
import lucuma.core.math.JulianDate$;
import lucuma.core.math.skycalc.ImprovedSkyCalcMethods$DoubleRef$;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import spire.math.ConvertableFrom;
import spire.math.ConvertableTo$;
import spire.math.Fractional$;
import spire.std.package;

public interface ImprovedSkyCalcMethods {
    public static void $init$(ImprovedSkyCalcMethods $this) {
        $this.lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_FROMSTD_$eq(1);
        $this.lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_TOSTDEP_$eq(-1);
        $this.lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_JUSTPRE_$eq(1);
        $this.lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_DOAPPAR_$eq(0);
        $this.lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$DELTS_$eq(new double[]{-2.72, 3.86, 10.46, 17.2, 21.16, 23.62, 24.02, 23.93, 24.33, 26.77, 29.15, 31.07, 33.15, 35.73, 40.18, 45.48, 50.54, 54.34, 56.86, 60.78, 62.97});
    }

    public int XFORM_FROMSTD();

    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_FROMSTD_$eq(int var1);

    public int XFORM_TOSTDEP();

    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_TOSTDEP_$eq(int var1);

    public int XFORM_JUSTPRE();

    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_JUSTPRE_$eq(int var1);

    public int XFORM_DOAPPAR();

    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$XFORM_DOAPPAR_$eq(int var1);

    public double[] DELTS();

    public void lucuma$core$math$skycalc$ImprovedSkyCalcMethods$_setter_$DELTS_$eq(double[] var1);

    public static ImprovedSkyCalcMethods$DoubleRef$ DoubleRef$(ImprovedSkyCalcMethods $this) {
        return $this.DoubleRef();
    }

    default public ImprovedSkyCalcMethods$DoubleRef$ DoubleRef() {
        return new ImprovedSkyCalcMethods$DoubleRef$(this);
    }

    public static ZonedDateTime getLst$(ImprovedSkyCalcMethods $this, double lstHours, Instant instant2) {
        return $this.getLst(lstHours, instant2);
    }

    default public ZonedDateTime getLst(double lstHours, Instant instant2) {
        ZonedDateTime zdt = instant2.atZone(ZoneOffset.UTC);
        int h = zdt.getHour();
        boolean nextDay = lstHours < (double)h;
        return this.setHours(zdt, lstHours, nextDay);
    }

    private ZonedDateTime setHours(ZonedDateTime zdt, double hours, boolean nextDay) {
        int h = (int)hours;
        double md = (hours - (double)h) * 60.0;
        int min = (int)md;
        double sd = (md - (double)min) * 60.0;
        int sec = (int)sd;
        int ns = (int)((sd - (double)sec) * (double)Constants$.MODULE$.NanosInSecond());
        ZonedDateTime newZDT = zdt.with(LocalTime.of(h, min, sec, ns));
        if (nextDay) {
            return newZDT.plusHours(24L);
        }
        return newZDT;
    }

    public static double getAirmass$(ImprovedSkyCalcMethods $this, double alt) {
        return $this.getAirmass(alt);
    }

    default public double getAirmass(double alt) {
        double secz = this.secant_z(alt);
        if (secz < 0.0) {
            return 0.0;
        }
        if (secz < 12.0) {
            return this.true_airmass(secz);
        }
        return secz;
    }

    public static void setup_time_place$(ImprovedSkyCalcMethods $this, Instant instant2, double longit, DoubleRef jdut, DoubleRef sid, DoubleRef curepoch) {
        $this.setup_time_place(instant2, longit, jdut, sid, curepoch);
    }

    default public void setup_time_place(Instant instant2, double longit, DoubleRef jdut, DoubleRef sid, DoubleRef curepoch) {
        double jd = this.instant_to_jd(instant2);
        sid.d_$eq(this.lst(jd, longit));
        jdut.d_$eq(jd);
        curepoch.d_$eq(2000.0 + (jd - JulianDate$.MODULE$.J2000().toDouble()) / 365.25);
    }

    public static void cooxform$(ImprovedSkyCalcMethods $this, double rin, double din, double std_epoch, double date_epoch, DoubleRef rout, DoubleRef dout, int just_precess, int from_std) {
        $this.cooxform(rin, din, std_epoch, date_epoch, rout, dout, just_precess, from_std);
    }

    default public void cooxform(double rin, double din, double std_epoch, double date_epoch, DoubleRef rout, DoubleRef dout, int just_precess, int from_std) {
        double ti = 0.0;
        double tf = 0.0;
        double zeta = 0.0;
        double z = 0.0;
        double theta = 0.0;
        double cosz = 0.0;
        double coszeta = 0.0;
        double costheta = 0.0;
        double sinz = 0.0;
        double sinzeta = 0.0;
        double sintheta = 0.0;
        double[][] p = new double[4][4];
        double[][] n = new double[4][4];
        double[][] r = new double[4][4];
        double[][] t = new double[4][4];
        double radian_ra = 0.0;
        double radian_dec = 0.0;
        DoubleRef del_psi = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef del_eps = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        double eps = 0.0;
        double[] orig = new double[4];
        double[] fin = new double[4];
        int i = 0;
        int j = 0;
        int k = 0;
        ti = (std_epoch - 2000.0) / 100.0;
        tf = (date_epoch - 2000.0 - 100.0 * ti) / 100.0;
        zeta = (2306.2181 + 1.39656 * ti + 1.39E-4 * ti * ti) * tf + (0.30188 - 3.44E-4 * ti) * tf * tf + 0.017998 * tf * tf * tf;
        z = zeta + (0.7928 + 4.1E-4 * ti) * tf * tf + 2.05E-4 * tf * tf * tf;
        theta = (2004.3109 - 0.8533 * ti - 2.17E-4 * ti * ti) * tf - (0.42665 + 2.17E-4 * ti) * tf * tf - 0.041833 * tf * tf * tf;
        cosz = Math.cos(z /= Constants$.MODULE$.ArcsecsInRadian());
        coszeta = Math.cos(zeta /= Constants$.MODULE$.ArcsecsInRadian());
        costheta = Math.cos(theta /= Constants$.MODULE$.ArcsecsInRadian());
        sinz = Math.sin(z);
        sinzeta = Math.sin(zeta);
        sintheta = Math.sin(theta);
        p[1][1] = coszeta * cosz * costheta - sinzeta * sinz;
        p[1][2] = -1.0 * sinzeta * cosz * costheta - coszeta * sinz;
        p[1][3] = -1.0 * cosz * sintheta;
        p[2][1] = coszeta * sinz * costheta + sinzeta * cosz;
        p[2][2] = -1.0 * sinzeta * sinz * costheta + coszeta * cosz;
        p[2][3] = -1.0 * sinz * sintheta;
        p[3][1] = coszeta * sintheta;
        p[3][2] = -1.0 * sinzeta * sintheta;
        p[3][3] = costheta;
        if (just_precess == this.XFORM_DOAPPAR()) {
            this.nutation_params(date_epoch, del_psi, del_eps);
            eps = 0.409105;
            n[1][1] = 1.0;
            n[2][2] = 1.0;
            n[3][3] = 1.0;
            n[1][2] = -1.0 * del_psi.d() * Math.cos(eps);
            n[1][3] = -1.0 * del_psi.d() * Math.sin(eps);
            n[2][1] = -1.0 * n[1][2];
            n[2][3] = -1.0 * del_eps.d();
            n[3][1] = -1.0 * n[1][3];
            n[3][2] = -1.0 * n[2][3];
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = 0.0;
                    for (k = 1; k <= 3; ++k) {
                        double[] dArray = r[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + p[i][k] * n[k][j];
                    }
                }
            }
        } else {
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = p[i][j];
                }
            }
        }
        if (from_std == this.XFORM_TOSTDEP()) {
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    t[i][j] = r[j][i];
                }
            }
            for (i = 1; i <= 3; ++i) {
                for (j = 1; j <= 3; ++j) {
                    r[i][j] = t[i][j];
                }
            }
        }
        radian_ra = rin / Constants$.MODULE$.HrsInRadian();
        radian_dec = din / Constants$.MODULE$.DegsInRadian();
        orig[1] = Math.cos(radian_dec) * Math.cos(radian_ra);
        orig[2] = Math.cos(radian_dec) * Math.sin(radian_ra);
        orig[3] = Math.sin(radian_dec);
        if (from_std == this.XFORM_TOSTDEP() && just_precess == this.XFORM_DOAPPAR()) {
            this.aberrate(date_epoch, orig, from_std);
        }
        for (i = 1; i <= 3; ++i) {
            fin[i] = 0.0;
            for (j = 1; j <= 3; ++j) {
                int n3 = i;
                fin[n3] = fin[n3] + r[i][j] * orig[j];
            }
        }
        if (from_std == this.XFORM_FROMSTD() && just_precess == this.XFORM_DOAPPAR()) {
            this.aberrate(date_epoch, fin, from_std);
        }
        this.xyz_cel(fin[1], fin[2], fin[3], rout, dout);
    }

    public static void nutation_params$(ImprovedSkyCalcMethods $this, double date_epoch, DoubleRef del_psi, DoubleRef del_ep) {
        $this.nutation_params(date_epoch, del_psi, del_ep);
    }

    default public void nutation_params(double date_epoch, DoubleRef del_psi, DoubleRef del_ep) {
        double T = 0.0;
        double jd = 0.0;
        double L = 0.0;
        double Lprime = 0.0;
        double M = 0.0;
        double Mprime = 0.0;
        double Omega = 0.0;
        jd = (date_epoch - 2000.0) * 365.25 + JulianDate$.MODULE$.J2000().toDouble();
        T = (jd - 2415020.0) / 36525.0;
        L = 279.6967 + (36000.7689 + 3.03E-4 * T) * T;
        Lprime = 270.4342 + (481267.8831 - 0.001133 * T) * T;
        M = 358.4758 + (35999.0498 - 1.5E-4 * T) * T;
        Mprime = 296.1046 + (477198.8491 + 0.009192 * T) * T;
        Omega = 259.1833 - (1934.142 - 0.002078 * T) * T;
        del_psi.d_$eq(-1.0 * (17.2327 + 0.01737 * T) * Math.sin(Omega /= Constants$.MODULE$.DegsInRadian()) - (1.2729 + 1.3E-4 * T) * Math.sin(2.0 * (L /= Constants$.MODULE$.DegsInRadian())) + 0.2088 * Math.sin((double)2 * Omega) - 0.2037 * Math.sin((double)2 * (Lprime /= Constants$.MODULE$.DegsInRadian())) + (0.1261 - 3.1E-4 * T) * Math.sin(M /= Constants$.MODULE$.DegsInRadian()) + 0.0675 * Math.sin(Mprime /= Constants$.MODULE$.DegsInRadian()) - (0.0497 - 1.2E-4 * T) * Math.sin((double)2 * L + M) - 0.0342 * Math.sin((double)2 * Lprime - Omega) - 0.0261 * Math.sin((double)2 * Lprime + Mprime) + 0.0214 * Math.sin((double)2 * L - M) - 0.0149 * Math.sin((double)2 * L - (double)2 * Lprime + Mprime) + 0.0124 * Math.sin((double)2 * L - Omega) + 0.0114 * Math.sin((double)2 * Lprime - Mprime));
        del_ep.d_$eq((9.21 + 9.1E-4 * T) * Math.cos(Omega) + (0.5522 - 2.9E-4 * T) * Math.cos((double)2 * L) - 0.0904 * Math.cos((double)2 * Omega) + 0.0884 * Math.cos(2.0 * Lprime) + 0.0216 * Math.cos((double)2 * L + M) + 0.0183 * Math.cos((double)2 * Lprime - Omega) + 0.0113 * Math.cos((double)2 * Lprime + Mprime) - 0.0093 * Math.cos((double)2 * L - M) - 0.0066 * Math.cos((double)2 * L - Omega));
        del_psi.d_$eq(del_psi.d() / Constants$.MODULE$.ArcsecsInRadian());
        del_ep.d_$eq(del_ep.d() / Constants$.MODULE$.ArcsecsInRadian());
    }

    public static void xyz_cel$(ImprovedSkyCalcMethods $this, double x0, double y0, double z0, DoubleRef ra, DoubleRef dec) {
        $this.xyz_cel(x0, y0, z0, ra, dec);
    }

    default public void xyz_cel(double x0, double y0, double z0, DoubleRef ra, DoubleRef dec) {
        double x = x0;
        double y = y0;
        double z = z0;
        double mod = 0.0;
        double xy = 0.0;
        mod = Math.sqrt(x * x + y * y + z * z);
        if (mod > 0.0) {
            z /= mod;
        } else {
            System.out.println("Bad data in xyz_cel .... zero modulus position vector.\n");
            ra.d_$eq(0.0);
            dec.d_$eq(0.0);
            return;
        }
        xy = Math.sqrt((x /= mod) * x + (y /= mod) * y);
        if (xy < 1.0E-11) {
            ra.d_$eq(0.0);
            dec.d_$eq(Constants$.MODULE$.HalfPi());
            if (z < 0.0) {
                dec.d_$eq(dec.d() * -1.0);
            }
        } else {
            dec.d_$eq(Math.asin(z));
            ra.d_$eq(this.atan_circ(x, y));
        }
        ra.d_$eq(ra.d() * Constants$.MODULE$.HrsInRadian());
        dec.d_$eq(dec.d() * Constants$.MODULE$.DegsInRadian());
    }

    public static void aberrate$(ImprovedSkyCalcMethods $this, double epoch, double[] vec, int from_std) {
        $this.aberrate(epoch, vec, from_std);
    }

    default public void aberrate(double epoch, double[] vec, int from_std) {
        double jd = 0.0;
        double jd1 = 0.0;
        double jd2 = 0.0;
        double Xdot = 0.0;
        double Ydot = 0.0;
        double Zdot = 0.0;
        DoubleRef ras = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef decs = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef dists = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef topora = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef topodec = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef x = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef y = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef z = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef x1 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef y1 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef z1 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef x2 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef y2 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef z2 = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        double norm = 0.0;
        jd = JulianDate$.MODULE$.J2000().toDouble() + (epoch - 2000.0) * 365.25;
        jd1 = jd - Constants$.MODULE$.EarthDiff();
        jd2 = jd + Constants$.MODULE$.EarthDiff();
        this.accusun(jd1, 0.0, 0.0, ras, decs, dists, topora, topodec, x1, y1, z1);
        this.accusun(jd2, 0.0, 0.0, ras, decs, dists, topora, topodec, x2, y2, z2);
        this.accusun(jd, 0.0, 0.0, ras, decs, dists, topora, topodec, x, y, z);
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        int ql$proxy4 = Constants$.MODULE$.SpeedOfLight();
        Xdot = Constants$.MODULE$.MetersPerSecondInAUPerDay() * (x2.d() - x1.d()) / (2.0 * Constants$.MODULE$.EarthDiff() * (double)ql$proxy4);
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        int ql$proxy5 = Constants$.MODULE$.SpeedOfLight();
        Ydot = Constants$.MODULE$.MetersPerSecondInAUPerDay() * (y2.d() - y1.d()) / (2.0 * Constants$.MODULE$.EarthDiff() * (double)ql$proxy5);
        quantity$package$ quantity$package$4 = quantity$package$.MODULE$;
        int ql$proxy6 = Constants$.MODULE$.SpeedOfLight();
        Zdot = Constants$.MODULE$.MetersPerSecondInAUPerDay() * (z2.d() - z1.d()) / (2.0 * Constants$.MODULE$.EarthDiff() * (double)ql$proxy6);
        vec[1] = vec[1] + (double)from_std * Xdot;
        vec[2] = vec[2] + (double)from_std * Ydot;
        vec[3] = vec[3] + (double)from_std * Zdot;
        norm = Math.pow(vec[1] * vec[1] + vec[2] * vec[2] + vec[3] * vec[3], 0.5);
        vec[1] = vec[1] / norm;
        vec[2] = vec[2] / norm;
        vec[3] = vec[3] / norm;
    }

    public static double atan_circ$(ImprovedSkyCalcMethods $this, double x, double y) {
        return $this.atan_circ(x, y);
    }

    default public double atan_circ(double x, double y) {
        double theta = 0.0;
        if (x != 0.0 || y != 0.0) {
            for (theta = Math.atan2(y, x); theta < 0.0; theta += Constants$.MODULE$.TwoPi()) {
            }
            return theta;
        }
        return 0.0;
    }

    public static void accusun$(ImprovedSkyCalcMethods $this, double jd0, double lst, double geolat, DoubleRef ra, DoubleRef dec, DoubleRef dist, DoubleRef topora, DoubleRef topodec, DoubleRef x, DoubleRef y, DoubleRef z) {
        $this.accusun(jd0, lst, geolat, ra, dec, dist, topora, topodec, x, y, z);
    }

    default public void accusun(double jd0, double lst, double geolat, DoubleRef ra, DoubleRef dec, DoubleRef dist, DoubleRef topora, DoubleRef topodec, DoubleRef x, DoubleRef y, DoubleRef z) {
        double jd = jd0;
        double L = 0.0;
        double T = 0.0;
        double Tsq = 0.0;
        double Tcb = 0.0;
        double M = 0.0;
        double e = 0.0;
        double Cent = 0.0;
        double nu = 0.0;
        double sunlong = 0.0;
        double Mrad = 0.0;
        double nurad = 0.0;
        double R = 0.0;
        double A = 0.0;
        double B = 0.0;
        double C = 0.0;
        double D = 0.0;
        double E = 0.0;
        double H = 0.0;
        double xtop = 0.0;
        double ytop = 0.0;
        double ztop = 0.0;
        double topodist = 0.0;
        double l = 0.0;
        double m = 0.0;
        double n = 0.0;
        DoubleRef xgeo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef ygeo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef zgeo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        jd += this.etcorr(jd) / (double)Constants$.MODULE$.SecsInDay();
        T = (jd - 2415020.0) / 36525.0;
        Tsq = T * T;
        Tcb = T * Tsq;
        L = 279.69668 + 36000.76892 * T + 3.025E-4 * Tsq;
        M = 358.47583 + 35999.04975 * T - 1.5E-4 * Tsq - 3.3E-6 * Tcb;
        e = 0.01675104 - 4.18E-5 * T - 1.26E-7 * Tsq;
        L = this.circulo(L);
        M = this.circulo(M);
        A = 153.23 + 22518.7541 * T;
        B = 216.57 + 45037.5082 * T;
        C = 312.69 + 32964.3577 * T;
        D = 350.74 + 445267.1142 * T - 0.00144 * Tsq;
        E = 231.19 + 20.2 * T;
        H = 353.4 + 65928.7155 * T;
        A = this.circulo(A) / Constants$.MODULE$.DegsInRadian();
        B = this.circulo(B) / Constants$.MODULE$.DegsInRadian();
        C = this.circulo(C) / Constants$.MODULE$.DegsInRadian();
        D = this.circulo(D) / Constants$.MODULE$.DegsInRadian();
        E = this.circulo(E) / Constants$.MODULE$.DegsInRadian();
        H = this.circulo(H) / Constants$.MODULE$.DegsInRadian();
        L = L + 0.00134 * Math.cos(A) + 0.00154 * Math.cos(B) + 0.002 * Math.cos(C) + 0.00179 * Math.sin(D) + 0.00178 * Math.sin(E);
        Mrad = M / Constants$.MODULE$.DegsInRadian();
        Cent = (1.91946 - 0.004789 * T - 1.4E-5 * Tsq) * Math.sin(Mrad) + (0.020094 - 1.0E-4 * T) * Math.sin(2.0 * Mrad) + 2.93E-4 * Math.sin(3.0 * Mrad);
        sunlong = L + Cent;
        nu = M + Cent;
        nurad = nu / Constants$.MODULE$.DegsInRadian();
        R = 1.0000002 * (1.0 - e * e) / (1.0 + e * Math.cos(nurad));
        R = R + 5.43E-6 * Math.sin(A) + 1.575E-5 * Math.sin(B) + 1.627E-5 * Math.sin(C) + 3.076E-5 * Math.cos(D) + 9.27E-6 * Math.sin(H);
        dist.d_$eq(R);
        x.d_$eq(Math.cos(sunlong /= Constants$.MODULE$.DegsInRadian()));
        y.d_$eq(Math.sin(sunlong));
        z.d_$eq(0.0);
        this.eclrot(jd, y, z);
        this.geocent(lst, geolat, 0.0, xgeo, ygeo, zgeo);
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        double ql$proxy1 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        double qr$proxy1 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.AstronomicalUnit(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        .eq.colon.eq eqv$proxy1 = $less$colon$less$.MODULE$.refl();
        SimplifiedUnit.NC su$proxy1 = new SimplifiedUnit.NC();
        div.infra$.DivNC div$proxy1 = new div.infra$.DivNC((Function2)(JFunction2.mcDDD.sp & Serializable)(ql, qr) -> {
            quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
            double ql$proxy7 = ql;
            quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
            double ql$proxy8 = qr;
            double v$proxy1 = BoxesRunTime.unboxToDouble((Object)package.double$.MODULE$.DoubleAlgebra().div((Object)BoxesRunTime.boxToDouble((double)ql$proxy7), (Object)BoxesRunTime.boxToDouble((double)eqv$proxy1.apply$mcDD$sp(ql$proxy8))));
            return BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy1)));
        });
        double ql$proxy9 = div$proxy1.eval().apply$mcDDD$sp(ql$proxy1, qr$proxy1);
        xtop = x.d() - xgeo.d() * ql$proxy9;
        quantity$package$ quantity$package$4 = quantity$package$.MODULE$;
        quantity$package$ quantity$package$5 = quantity$package$.MODULE$;
        double ql$proxy2 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        double qr$proxy2 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.AstronomicalUnit(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        .eq.colon.eq eqv$proxy2 = $less$colon$less$.MODULE$.refl();
        SimplifiedUnit.NC su$proxy2 = new SimplifiedUnit.NC();
        div.infra$.DivNC div$proxy2 = new div.infra$.DivNC((Function2)(JFunction2.mcDDD.sp & Serializable)(ql, qr) -> {
            quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
            double ql$proxy10 = ql;
            quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
            double ql$proxy11 = qr;
            double v$proxy2 = BoxesRunTime.unboxToDouble((Object)package.double$.MODULE$.DoubleAlgebra().div((Object)BoxesRunTime.boxToDouble((double)ql$proxy10), (Object)BoxesRunTime.boxToDouble((double)eqv$proxy2.apply$mcDD$sp(ql$proxy11))));
            return BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy2)));
        });
        double ql$proxy12 = div$proxy2.eval().apply$mcDDD$sp(ql$proxy2, qr$proxy2);
        ytop = y.d() - ygeo.d() * ql$proxy12;
        quantity$package$ quantity$package$6 = quantity$package$.MODULE$;
        quantity$package$ quantity$package$7 = quantity$package$.MODULE$;
        double ql$proxy3 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        double qr$proxy3 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.AstronomicalUnit(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        .eq.colon.eq eqv$proxy3 = $less$colon$less$.MODULE$.refl();
        SimplifiedUnit.NC su$proxy3 = new SimplifiedUnit.NC();
        div.infra$.DivNC div$proxy3 = new div.infra$.DivNC((Function2)(JFunction2.mcDDD.sp & Serializable)(ql, qr) -> {
            quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
            double ql$proxy13 = ql;
            quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
            double ql$proxy14 = qr;
            double v$proxy3 = BoxesRunTime.unboxToDouble((Object)package.double$.MODULE$.DoubleAlgebra().div((Object)BoxesRunTime.boxToDouble((double)ql$proxy13), (Object)BoxesRunTime.boxToDouble((double)eqv$proxy3.apply$mcDD$sp(ql$proxy14))));
            return BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy3)));
        });
        double ql$proxy15 = div$proxy3.eval().apply$mcDDD$sp(ql$proxy3, qr$proxy3);
        ztop = z.d() - zgeo.d() * ql$proxy15;
        topodist = Math.sqrt(xtop * xtop + ytop * ytop + ztop * ztop);
        l = xtop / topodist;
        m = ytop / topodist;
        n = ztop / topodist;
        topora.d_$eq(this.atan_circ(l, m) * Constants$.MODULE$.HrsInRadian());
        topodec.d_$eq(Math.asin(n) * Constants$.MODULE$.DegsInRadian());
        ra.d_$eq(this.atan_circ(x.d(), y.d()) * Constants$.MODULE$.HrsInRadian());
        dec.d_$eq(Math.asin(z.d()) * Constants$.MODULE$.DegsInRadian());
        x.d_$eq(x.d() * R * (double)-1);
        y.d_$eq(y.d() * R * (double)-1);
        z.d_$eq(z.d() * R * (double)-1);
    }

    public static double etcorr$(ImprovedSkyCalcMethods $this, double jd) {
        return $this.etcorr(jd);
    }

    default public double etcorr(double jd) {
        double[] dates = new double[22];
        double year = 0.0;
        double delt = 0.0;
        int i = 0;
        for (i = 0; i <= 19; ++i) {
            dates[i] = (double)1900 + (double)i * 5.0;
        }
        dates[20] = 1998.0;
        year = 1900.0 + (jd - 2415019.5) / 365.25;
        if (year < 1998.0 && year >= 1900.0) {
            i = (int)(year - 1900.0) / 5;
            delt = this.DELTS()[i] + (this.DELTS()[i + 1] - this.DELTS()[i]) / (dates[i + 1] - dates[i]) * (year - dates[i]);
        } else if (year >= 1998.0 && year < 2100.0) {
            delt = 33.15 + 0.002164 * (jd - 2436935.4);
        } else if (year < 1900.0) {
            System.out.println("etcorr ... no ephemeris time data for < 1900.\n");
            delt = 0.0;
        } else if (year >= 2100.0) {
            System.out.println("etcorr .. very long extrapolation in delta T - inaccurate.\n");
            delt = 180.0;
        }
        return delt;
    }

    public static double circulo$(ImprovedSkyCalcMethods $this, double x) {
        return $this.circulo(x);
    }

    default public double circulo(double x) {
        int n = (int)(x / 360.0);
        return x - 360.0 * (double)n;
    }

    public static void eclrot$(ImprovedSkyCalcMethods $this, double jd, DoubleRef y, DoubleRef z) {
        $this.eclrot(jd, y, z);
    }

    default public void eclrot(double jd, DoubleRef y, DoubleRef z) {
        double incl = 0.0;
        double ypr = 0.0;
        double zpr = 0.0;
        double T = 0.0;
        T = (jd - JulianDate$.MODULE$.J2000().toDouble()) / (double)36525;
        incl = (23.439291 + T * (-0.0130042 - 1.6E-7 * T)) / Constants$.MODULE$.DegsInRadian();
        ypr = Math.cos(incl) * y.d() - Math.sin(incl) * z.d();
        zpr = Math.sin(incl) * y.d() + Math.cos(incl) * z.d();
        y.d_$eq(ypr);
        z.d_$eq(zpr);
    }

    public static void eclrot$(ImprovedSkyCalcMethods $this, double jd, DoubleRef x, DoubleRef y, DoubleRef z) {
        $this.eclrot(jd, x, y, z);
    }

    default public void eclrot(double jd, DoubleRef x, DoubleRef y, DoubleRef z) {
        double incl = 0.0;
        double ypr = 0.0;
        double zpr = 0.0;
        double T = 0.0;
        T = (jd - JulianDate$.MODULE$.J2000().toDouble()) / (double)36525;
        incl = (23.439291 + T * (-0.0130042 - 1.6E-7 * T)) / Constants$.MODULE$.DegsInRadian();
        ypr = Math.cos(incl) * y.d() - Math.sin(incl) * z.d();
        zpr = Math.sin(incl) * y.d() + Math.cos(incl) * z.d();
        y.d_$eq(ypr);
        z.d_$eq(zpr);
    }

    public static void geocent$(ImprovedSkyCalcMethods $this, double geolong0, double geolat0, double height, DoubleRef x_geo, DoubleRef y_geo, DoubleRef z_geo) {
        $this.geocent(geolong0, geolat0, height, x_geo, y_geo, z_geo);
    }

    default public void geocent(double geolong0, double geolat0, double height, DoubleRef x_geo, DoubleRef y_geo, DoubleRef z_geo) {
        double geolong = geolong0;
        double geolat = geolat0;
        double denom = 0.0;
        double C_geo = 0.0;
        double S_geo = 0.0;
        geolong /= Constants$.MODULE$.HrsInRadian();
        denom = (1.0 - Constants$.MODULE$.FlatteningOfEarth()) * Math.sin(geolat /= Constants$.MODULE$.DegsInRadian());
        denom = Math.cos(geolat) * Math.cos(geolat) + denom * denom;
        C_geo = 1.0 / Math.sqrt(denom);
        S_geo = (1.0 - Constants$.MODULE$.FlatteningOfEarth()) * (1.0 - Constants$.MODULE$.FlatteningOfEarth()) * C_geo;
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        double ql$proxy16 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        double ql$proxy17 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
        x_geo.d_$eq((C_geo += height / ql$proxy16) * Math.cos(geolat) * Math.cos(geolong));
        y_geo.d_$eq(C_geo * Math.cos(geolat) * Math.sin(geolong));
        z_geo.d_$eq((S_geo += height / ql$proxy17) * Math.sin(geolat));
    }

    public static double adj_time$(ImprovedSkyCalcMethods $this, double x0) {
        return $this.adj_time(x0);
    }

    default public double adj_time(double x0) {
        double x = x0;
        if (Math.abs(x) < 100000.0) {
            while (x > 12.0) {
                x -= 24.0;
            }
            while (x < -12.0) {
                x += 24.0;
            }
        } else {
            System.out.println("Out of bounds in adj_time!\n");
        }
        return x;
    }

    public static double altit$(ImprovedSkyCalcMethods $this, double dec0, double ha0, double lat0, DoubleRef az, DoubleRef parang) {
        return $this.altit(dec0, ha0, lat0, az, parang);
    }

    default public double altit(double dec0, double ha0, double lat0, DoubleRef az, DoubleRef parang) {
        double dec = dec0;
        double ha = ha0;
        double lat = lat0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double sinp = 0.0;
        double cosp = 0.0;
        double cosdec = 0.0;
        double sindec = 0.0;
        double cosha = 0.0;
        double sinha = 0.0;
        double coslat = 0.0;
        double sinlat = 0.0;
        cosdec = Math.cos(dec /= Constants$.MODULE$.DegsInRadian());
        sindec = Math.sin(dec);
        cosha = Math.cos(ha /= Constants$.MODULE$.HrsInRadian());
        sinha = Math.sin(ha);
        coslat = Math.cos(lat /= Constants$.MODULE$.DegsInRadian());
        sinlat = Math.sin(lat);
        x = Constants$.MODULE$.DegsInRadian() * Math.asin(cosdec * cosha * coslat + sindec * sinlat);
        y = sindec * coslat - cosdec * cosha * sinlat;
        z = -1.0 * cosdec * sinha;
        az.d_$eq(Math.atan2(z, y));
        if (cosdec != 0.0) {
            sinp = -1.0 * Math.sin(az.d()) * coslat / cosdec;
            cosp = -1.0 * Math.cos(az.d()) * cosha - Math.sin(az.d()) * sinha * sinlat;
            parang.d_$eq(Math.atan2(sinp, cosp) * Constants$.MODULE$.DegsInRadian());
        } else if (lat >= 0.0) {
            parang.d_$eq(180.0);
        } else {
            parang.d_$eq(0.0);
        }
        az.d_$eq(az.d() * Constants$.MODULE$.DegsInRadian());
        while (az.d() < 0.0) {
            az.d_$eq(az.d() + 360.0);
        }
        while (az.d() >= 360.0) {
            az.d_$eq(az.d() - 360.0);
        }
        return x;
    }

    public static double secant_z$(ImprovedSkyCalcMethods $this, double alt) {
        return $this.secant_z(alt);
    }

    default public double secant_z(double alt) {
        double secz = 0.0;
        secz = alt != 0.0 ? 1.0 / Math.sin(alt / Constants$.MODULE$.DegsInRadian()) : 100.0;
        if (secz > 100.0) {
            secz = 100.0;
        }
        if (secz < -100.0) {
            secz = -100.0;
        }
        return secz;
    }

    public static double true_airmass$(ImprovedSkyCalcMethods $this, double secz) {
        return $this.true_airmass(secz);
    }

    default public double true_airmass(double secz) {
        double seczmin1 = 0.0;
        int i = 0;
        int ord = 4;
        double[] coef = new double[5];
        double result = 0.0;
        coef[1] = 0.002879465;
        coef[2] = 0.003033104;
        coef[3] = 0.001351167;
        coef[4] = -4.716679E-5;
        if (secz < 0.0) {
            return -1.0;
        }
        if (secz > (double)12) {
            return secz - 1.5;
        }
        seczmin1 = secz - 1.0;
        for (i = ord; i > 0; --i) {
            result = (result + coef[i]) * seczmin1;
        }
        return secz - result;
    }

    public static double instant_to_jd$(ImprovedSkyCalcMethods $this, Instant instant2) {
        return $this.instant_to_jd(instant2);
    }

    default public double instant_to_jd(Instant instant2) {
        int yr1 = 0;
        int mo1 = 1;
        int jdzpt = 1720982;
        long jdint = 0L;
        long inter = 0L;
        double jd = 0.0;
        double jdfrac = 0.0;
        ZonedDateTime date = instant2.atZone(ZoneOffset.UTC);
        if (date.getYear() <= 1900 | date.getYear() >= 2100) {
            throw new IllegalArgumentException("Date out of range.  1900 - 2100 only.");
        }
        if (date.getMonthValue() <= 2) {
            yr1 = -1;
            mo1 = 13;
        }
        jdint = (long)(365.25 * (double)(date.getYear() + yr1));
        inter = (long)(30.6001 * (double)(date.getMonthValue() + mo1));
        jdint = jdint + inter + (long)date.getDayOfMonth() + (long)jdzpt;
        jd = jdint;
        jdfrac = (double)date.getHour() / 24.0 + (double)date.getMinute() / 1440.0 + ((double)date.getSecond() + (double)date.getNano() / (double)Constants$.MODULE$.NanosInSecond()) / (double)Constants$.MODULE$.SecsInDay();
        if (jdfrac < 0.5) {
            --jdint;
            jdfrac += 0.5;
        } else {
            jdfrac -= 0.5;
        }
        jd = (double)jdint + jdfrac;
        return jd;
    }

    public static double lst$(ImprovedSkyCalcMethods $this, double jd, double longit) {
        return $this.lst(jd, longit);
    }

    default public double lst(double jd, double longit) {
        double t = 0.0;
        double ut = 0.0;
        double jdmid = 0.0;
        double jdint = 0.0;
        double jdfrac = 0.0;
        double sid_g = 0.0;
        long jdin = 0L;
        long sid_int = 0L;
        jdin = (long)jd;
        jdint = jdin;
        jdfrac = jd - jdint;
        if (jdfrac < 0.5) {
            jdmid = jdint - 0.5;
            ut = jdfrac + 0.5;
        } else {
            jdmid = jdint + 0.5;
            ut = jdfrac - 0.5;
        }
        t = (jdmid - JulianDate$.MODULE$.J2000().toDouble()) / (double)36525;
        sid_g = (24110.54841 + 8640184.812866 * t + 0.093104 * t * t - 6.2E-6 * t * t * t) / (double)Constants$.MODULE$.SecsInDay();
        sid_int = (long)sid_g;
        sid_g -= (double)sid_int;
        sid_g = sid_g + 1.0027379093 * ut - longit / 24.0;
        sid_int = (long)sid_g;
        sid_g = (sid_g - (double)sid_int) * 24.0;
        if (sid_g < 0.0) {
            return sid_g + 24.0;
        }
        return sid_g;
    }

    public static double sb$(ImprovedSkyCalcMethods $this, double mpa, double mdist, double mZD, double ZD, double sZD, double moondist0) {
        return $this.sb(mpa, mdist, mZD, ZD, sZD, moondist0);
    }

    default public double sb(double mpa, double mdist, double mZD, double ZD, double sZD, double moondist0) {
        double moondist = moondist0;
        double degrad = 57.2957795130823;
        double k = 0.172;
        double a = 2.51189;
        double Q = 27.78151;
        double saltit = 90.0 - sZD;
        double Vzen = 21.587;
        if (saltit > -18.5) {
            Vzen -= this.ztwilight(saltit);
        }
        double Bzen = 0.263 * Math.pow(a, Q - Vzen);
        double Bsky = Bzen * this.xair(ZD) * Math.pow(10.0, -0.4 * k * (this.xair(ZD) - 1.0));
        double istar = 0.0;
        double fp = 0.0;
        double Bmoon = 0.0;
        double frho = 0.0;
        if (mZD <= 90.8) {
            istar = -0.4 * (3.84 + 0.026 * Math.abs(mpa) + 4.0E-9 * Math.pow(mpa, 4.0));
            istar = Math.pow(10.0, istar) / ((moondist /= 60.27) * moondist);
            if (Math.abs(mpa) < 7.0) {
                istar *= 1.35 - 0.05 * Math.abs(mpa);
            }
            frho = (double)229087 * (1.06 + Math.cos(mdist / degrad) * Math.cos(mdist / degrad));
            fp = mdist >= 10.0 ? frho + Math.pow(10.0, 6.15 - mdist / 40.0) : (Math.abs(mdist) > 0.25 ? frho + 6.2E7 / Math.pow(mdist, 2.0) : frho + 9.9E8);
        }
        Bmoon = fp * istar * Math.pow(10.0, -0.4 * k * this.xair(mZD)) * (1.0 - Math.pow(10.0, -0.4 * k * this.xair(ZD)));
        return Q - Math.log10((Bmoon + Bsky) / 0.263) / Math.log10(a);
    }

    public static double xair$(ImprovedSkyCalcMethods $this, double z) {
        return $this.xair(z);
    }

    default public double xair(double z) {
        double degrad = 57.2957795130823;
        return 1.0 / Math.sqrt(1.0 - 0.96 * Math.pow(Math.sin(z / degrad), 2.0));
    }

    public static double lunskybright$(ImprovedSkyCalcMethods $this, double alpha0, double rho, double kzen, double altmoon, double alt, double moondist0) {
        return $this.lunskybright(alpha0, rho, kzen, altmoon, alt, moondist0);
    }

    default public double lunskybright(double alpha0, double rho, double kzen, double altmoon, double alt, double moondist0) {
        double alpha = alpha0;
        double moondist = moondist0;
        double istar = 0.0;
        double Xzm = 0.0;
        double Xo = 0.0;
        double Z = 0.0;
        double Zmoon = 0.0;
        double Bmoon = 0.0;
        double fofrho = 0.0;
        double rho_rad = 0.0;
        rho_rad = rho / Constants$.MODULE$.DegsInRadian();
        alpha = 180.0 - alpha;
        Zmoon = (90.0 - altmoon) / Constants$.MODULE$.DegsInRadian();
        Z = (90.0 - alt) / Constants$.MODULE$.DegsInRadian();
        istar = -0.4 * (3.84 + 0.026 * Math.abs(alpha) + 4.0E-9 * Math.pow(alpha, 4.0));
        istar = Math.pow(10.0, istar) / ((moondist /= 60.27) * moondist);
        if (Math.abs(alpha) < 7.0) {
            istar *= 1.35 - 0.05 * Math.abs(alpha);
        }
        fofrho = (double)229087 * (1.06 + Math.cos(rho_rad) * Math.cos(rho_rad));
        fofrho = Math.abs(rho) > 10.0 ? (fofrho += Math.pow(10.0, 6.15 - rho / 40.0)) : (Math.abs(rho) > 0.25 ? (fofrho += 6.2E7 / (rho * rho)) : (fofrho += 9.9E8));
        Xzm = Math.sqrt(1.0 - 0.96 * Math.sin(Zmoon) * Math.sin(Zmoon));
        Xzm = Xzm != 0.0 ? 1.0 / Xzm : 10000.0;
        Xo = Math.sqrt(1.0 - 0.96 * Math.sin(Z) * Math.sin(Z));
        Xo = Xo != 0.0 ? 1.0 / Xo : 10000.0;
        Bmoon = fofrho * istar * Math.pow(10.0, -0.4 * kzen * Xzm) * (1.0 - Math.pow(10.0, -0.4 * kzen * Xo));
        if (Bmoon > 0.001) {
            return 22.5 - 1.08574 * Math.log(Bmoon / 34.08);
        }
        return 99.0;
    }

    public static void accumoon$(ImprovedSkyCalcMethods $this, double jd0, double geolat, double lst, double elevsea, DoubleRef geora, DoubleRef geodec, DoubleRef geodist, DoubleRef topora, DoubleRef topodec, DoubleRef topodist) {
        $this.accumoon(jd0, geolat, lst, elevsea, geora, geodec, geodist, topora, topodec, topodist);
    }

    default public void accumoon(double jd0, double geolat, double lst, double elevsea, DoubleRef geora, DoubleRef geodec, DoubleRef geodist, DoubleRef topora, DoubleRef topodec, DoubleRef topodist) {
        double jd = jd0;
        double pie = 0.0;
        double dist = 0.0;
        double Lpr = 0.0;
        double M = 0.0;
        double Mpr = 0.0;
        double D = 0.0;
        double F = 0.0;
        double Om = 0.0;
        double T = 0.0;
        double Tsq = 0.0;
        double Tcb = 0.0;
        double e = 0.0;
        double lambda = 0.0;
        double B = 0.0;
        double beta = 0.0;
        double om1 = 0.0;
        double om2 = 0.0;
        double sinx = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        DoubleRef x_geo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef y_geo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        DoubleRef z_geo = new DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        jd += this.etcorr(jd) / (double)Constants$.MODULE$.SecsInDay();
        T = (jd - 2415020.0) / 36525.0;
        Tsq = T * T;
        Tcb = Tsq * T;
        Lpr = 270.434164 + 481267.8831 * T - 0.001133 * Tsq + 1.9E-6 * Tcb;
        M = 358.475833 + 35999.0498 * T - 1.5E-4 * Tsq - 3.3E-6 * Tcb;
        Mpr = 296.104608 + 477198.8491 * T + 0.009192 * Tsq + 1.44E-5 * Tcb;
        D = 350.737486 + 445267.1142 * T - 0.001436 * Tsq + 1.9E-6 * Tcb;
        F = 11.250889 + 483202.0251 * T - 0.003211 * Tsq - 3.0E-7 * Tcb;
        Om = 259.183275 - 1934.142 * T + 0.002078 * Tsq + 2.2E-6 * Tcb;
        Lpr = this.circulo(Lpr);
        Mpr = this.circulo(Mpr);
        M = this.circulo(M);
        D = this.circulo(D);
        F = this.circulo(F);
        Om = this.circulo(Om);
        sinx = Math.sin((51.2 + 20.2 * T) / Constants$.MODULE$.DegsInRadian());
        Lpr += 2.33E-4 * sinx;
        M -= 0.001778 * sinx;
        Mpr += 8.17E-4 * sinx;
        D += 0.002011 * sinx;
        sinx = 0.003964 * Math.sin((346.56 + 132.87 * T - 0.0091731 * Tsq) / Constants$.MODULE$.DegsInRadian());
        Lpr += sinx;
        Mpr += sinx;
        D += sinx;
        F += sinx;
        sinx = Math.sin(Om / Constants$.MODULE$.DegsInRadian());
        Lpr += 0.001964 * sinx;
        Mpr += 0.002541 * sinx;
        D += 0.001964 * sinx;
        F -= 0.024691 * sinx;
        F -= 0.004328 * Math.sin((Om + 275.05 - 2.3 * T) / Constants$.MODULE$.DegsInRadian());
        e = 1.0 - 0.002495 * T - 7.52E-6 * Tsq;
        lambda = Lpr + 6.28875 * Math.sin(Mpr /= Constants$.MODULE$.DegsInRadian()) + 1.274018 * Math.sin((double)2 * (D /= Constants$.MODULE$.DegsInRadian()) - Mpr) + 0.658309 * Math.sin((double)2 * D) + 0.213616 * Math.sin((double)2 * Mpr) - e * 0.185596 * Math.sin(M /= Constants$.MODULE$.DegsInRadian()) - 0.114336 * Math.sin((double)2 * (F /= Constants$.MODULE$.DegsInRadian())) + 0.058793 * Math.sin((double)2 * D - (double)2 * Mpr) + e * 0.057212 * Math.sin((double)2 * D - M - Mpr) + 0.05332 * Math.sin((double)2 * D + Mpr) + e * 0.045874 * Math.sin((double)2 * D - M) + e * 0.041024 * Math.sin(Mpr - M) - 0.034718 * Math.sin(D) - e * 0.030465 * Math.sin(M + Mpr) + 0.015326 * Math.sin((double)2 * D - (double)2 * F) - 0.012528 * Math.sin((double)2 * F + Mpr) - 0.01098 * Math.sin((double)2 * F - Mpr) + 0.010674 * Math.sin((double)4 * D - Mpr) + 0.010034 * Math.sin((double)3 * Mpr) + 0.008548 * Math.sin((double)4 * D - (double)2 * Mpr) - e * 0.00791 * Math.sin(M - Mpr + (double)2 * D) - e * 0.006783 * Math.sin((double)2 * D + M) + 0.005162 * Math.sin(Mpr - D);
        lambda = lambda + e * 0.005 * Math.sin(M + D) + e * 0.004049 * Math.sin(Mpr - M + (double)2 * D) + 0.003996 * Math.sin((double)2 * Mpr + (double)2 * D) + 0.003862 * Math.sin((double)4 * D) + 0.003665 * Math.sin((double)2 * D - (double)3 * Mpr) + e * 0.002695 * Math.sin((double)2 * Mpr - M) + 0.002602 * Math.sin(Mpr - (double)2 * F - (double)2 * D) + e * 0.002396 * Math.sin((double)2 * D - M - (double)2 * Mpr) - 0.002349 * Math.sin(Mpr + D) + e * e * 0.002249 * Math.sin((double)2 * D - (double)2 * M) - e * 0.002125 * Math.sin((double)2 * Mpr + M) - e * e * 0.002079 * Math.sin((double)2 * M) + e * e * 0.002059 * Math.sin((double)2 * D - Mpr - (double)2 * M) - 0.001773 * Math.sin(Mpr + (double)2 * D - (double)2 * F) - 0.001595 * Math.sin((double)2 * F + (double)2 * D) + e * 0.00122 * Math.sin((double)4 * D - M - Mpr) - 0.00111 * Math.sin((double)2 * Mpr + (double)2 * F) + 8.92E-4 * Math.sin(Mpr - (double)3 * D) - e * 8.11E-4 * Math.sin(M + Mpr + (double)2 * D) + e * 7.61E-4 * Math.sin((double)4 * D - M - (double)2 * Mpr) + e * e * 7.17E-4 * Math.sin(Mpr - (double)2 * M) + e * e * 7.04E-4 * Math.sin(Mpr - (double)2 * M - (double)2 * D) + e * 6.93E-4 * Math.sin(M - (double)2 * Mpr + (double)2 * D) + e * 5.98E-4 * Math.sin((double)2 * D - M - (double)2 * F) + 5.5E-4 * Math.sin(Mpr + (double)4 * D) + 5.38E-4 * Math.sin((double)4 * Mpr) + e * 5.21E-4 * Math.sin((double)4 * D - M) + 4.86E-4 * Math.sin((double)2 * Mpr - D);
        B = 5.128189 * Math.sin(F) + 0.280606 * Math.sin(Mpr + F) + 0.277693 * Math.sin(Mpr - F) + 0.173238 * Math.sin((double)2 * D - F) + 0.055413 * Math.sin((double)2 * D + F - Mpr) + 0.046272 * Math.sin((double)2 * D - F - Mpr) + 0.032573 * Math.sin((double)2 * D + F) + 0.017198 * Math.sin((double)2 * Mpr + F) + 0.009267 * Math.sin((double)2 * D + Mpr - F) + 0.008823 * Math.sin((double)2 * Mpr - F) + e * 0.008247 * Math.sin((double)2 * D - M - F) + 0.004323 * Math.sin((double)2 * D - F - (double)2 * Mpr) + 0.0042 * Math.sin((double)2 * D + F + Mpr) + e * 0.003372 * Math.sin(F - M - (double)2 * D) + 0.002472 * Math.sin((double)2 * D + F - M - Mpr) + e * 0.002222 * Math.sin((double)2 * D + F - M) + e * 0.002072 * Math.sin((double)2 * D - F - M - Mpr) + e * 0.001877 * Math.sin(F - M + Mpr) + 0.001828 * Math.sin((double)4 * D - F - Mpr) - e * 0.001803 * Math.sin(F + M) - 0.00175 * Math.sin((double)3 * F) + e * 0.00157 * Math.sin(Mpr - M - F) - 0.001487 * Math.sin(F + D) - e * 0.001481 * Math.sin(F + M + Mpr) + e * 0.001417 * Math.sin(F - M - Mpr) + e * 0.00135 * Math.sin(F - M) + 0.00133 * Math.sin(F - D) + 0.001106 * Math.sin(F + (double)3 * Mpr) + 0.00102 * Math.sin((double)4 * D - F) + 8.33E-4 * Math.sin(F + (double)4 * D - Mpr);
        B = B + 7.81E-4 * Math.sin(Mpr - (double)3 * F) + 6.7E-4 * Math.sin(F + (double)4 * D - (double)2 * Mpr) + 6.06E-4 * Math.sin((double)2 * D - (double)3 * F) + 5.97E-4 * Math.sin((double)2 * D + (double)2 * Mpr - F) + e * 4.92E-4 * Math.sin((double)2 * D + Mpr - M - F) + 4.5E-4 * Math.sin((double)2 * Mpr - F - (double)2 * D) + 4.39E-4 * Math.sin((double)3 * Mpr - F) + 4.23E-4 * Math.sin(F + (double)2 * D + (double)2 * Mpr) + 4.22E-4 * Math.sin((double)2 * D - F - (double)3 * Mpr) - e * 3.67E-4 * Math.sin(M + F + (double)2 * D - Mpr) - e * 3.53E-4 * Math.sin(M + F + (double)2 * D) + 3.31E-4 * Math.sin(F + (double)4 * D) + e * 3.17E-4 * Math.sin((double)2 * D + F - M + Mpr) + e * e * 3.06E-4 * Math.sin((double)2 * D - (double)2 * M - F) - 2.83E-4 * Math.sin(Mpr + (double)3 * F);
        om1 = 4.664E-4 * Math.cos(Om / Constants$.MODULE$.DegsInRadian());
        om2 = 7.54E-5 * Math.cos((Om + 275.05 - 2.3 * T) / Constants$.MODULE$.DegsInRadian());
        beta = B * (1.0 - om1 - om2);
        pie = 0.950724 + 0.051818 * Math.cos(Mpr) + 0.009531 * Math.cos((double)2 * D - Mpr) + 0.007843 * Math.cos((double)2 * D) + 0.002824 * Math.cos((double)2 * Mpr) + 8.57E-4 * Math.cos((double)2 * D + Mpr) + e * 5.33E-4 * Math.cos((double)2 * D - M) + e * 4.01E-4 * Math.cos((double)2 * D - M - Mpr) + e * 3.2E-4 * Math.cos(Mpr - M) - 2.71E-4 * Math.cos(D) - e * 2.64E-4 * Math.cos(M + Mpr) - 1.98E-4 * Math.cos((double)2 * F - Mpr) + 1.73E-4 * Math.cos((double)3 * Mpr) + 1.67E-4 * Math.cos((double)4 * D - Mpr) - e * 1.11E-4 * Math.cos(M) + 1.03E-4 * Math.cos((double)4 * D - (double)2 * Mpr) - 8.4E-5 * Math.cos((double)2 * Mpr - (double)2 * D) - e * 8.3E-5 * Math.cos((double)2 * D + M) + 7.9E-5 * Math.cos((double)2 * D + (double)2 * Mpr) + 7.2E-5 * Math.cos((double)4 * D) + e * 6.4E-5 * Math.cos((double)2 * D - M + Mpr) - e * 6.3E-5 * Math.cos((double)2 * D + M - Mpr) + e * 4.1E-5 * Math.cos(M + D) + e * 3.5E-5 * Math.cos((double)2 * Mpr - M) - 3.3E-5 * Math.cos((double)3 * Mpr - (double)2 * D) - 3.0E-5 * Math.cos(Mpr + D) - 2.9E-5 * Math.cos((double)2 * F - (double)2 * D) - e * 2.9E-5 * Math.cos((double)2 * Mpr + M) + e * e * 2.6E-5 * Math.cos((double)2 * D - (double)2 * M) - 2.3E-5 * Math.cos((double)2 * F - (double)2 * D + Mpr) + e * 1.9E-5 * Math.cos((double)4 * D - M - Mpr);
        DoubleRef l = new DoubleRef(this, Math.cos(lambda /= Constants$.MODULE$.DegsInRadian()) * Math.cos(beta /= Constants$.MODULE$.DegsInRadian()));
        DoubleRef m = new DoubleRef(this, Math.sin(lambda) * Math.cos(beta));
        DoubleRef n = new DoubleRef(this, Math.sin(beta));
        this.eclrot(jd, l, m, n);
        dist = 1.0 / Math.sin(pie / Constants$.MODULE$.DegsInRadian());
        x = l.d() * dist;
        y = m.d() * dist;
        z = n.d() * dist;
        geora.d_$eq(this.atan_circ(l.d(), m.d()) * Constants$.MODULE$.HrsInRadian());
        geodec.d_$eq(Math.asin(n.d()) * Constants$.MODULE$.DegsInRadian());
        geodist.d_$eq(dist);
        this.geocent(lst, geolat, elevsea, x_geo, y_geo, z_geo);
        topodist.d_$eq(Math.sqrt((x -= x_geo.d()) * x + (y -= y_geo.d()) * y + (z -= z_geo.d()) * z));
        l.d_$eq(x / topodist.d());
        m.d_$eq(y / topodist.d());
        n.d_$eq(z / topodist.d());
        topora.d_$eq(this.atan_circ(l.d(), m.d()) * Constants$.MODULE$.HrsInRadian());
        topodec.d_$eq(Math.asin(n.d()) * Constants$.MODULE$.DegsInRadian());
    }

    public static double ztwilight$(ImprovedSkyCalcMethods $this, double alt) {
        return $this.ztwilight(alt);
    }

    default public double ztwilight(double alt) {
        double y = 0.0;
        double val = 0.0;
        y = (-1.0 * alt - 9.0) / 9.0;
        val = ((2.0635175 * y + 1.246602) * y - 9.4084495) * y + 6.132725;
        return val;
    }

    public static double subtend$(ImprovedSkyCalcMethods $this, double ra01, double dec01, double ra02, double dec02) {
        return $this.subtend(ra01, dec01, ra02, dec02);
    }

    default public double subtend(double ra01, double dec01, double ra02, double dec02) {
        double ra1 = ra01;
        double dec1 = dec01;
        double ra2 = ra02;
        double dec2 = dec02;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        double theta = 0.0;
        ra2 /= Constants$.MODULE$.HrsInRadian();
        dec2 /= Constants$.MODULE$.DegsInRadian();
        x1 = Math.cos(ra1 /= Constants$.MODULE$.HrsInRadian()) * Math.cos(dec1 /= Constants$.MODULE$.DegsInRadian());
        y1 = Math.sin(ra1) * Math.cos(dec1);
        z1 = Math.sin(dec1);
        x2 = Math.cos(ra2) * Math.cos(dec2);
        theta = Math.acos(x1 * x2 + y1 * (y2 = Math.sin(ra2) * Math.cos(dec2)) + z1 * (z2 = Math.sin(dec2)));
        if (theta < 1.0E-5 && Math.abs(dec1) < 1.5697963267948967 && Math.abs(dec2) < 1.5697963267948967) {
            x1 = (ra2 - ra1) * Math.cos((dec1 + dec2) / 2.0);
            x2 = dec2 - dec1;
            theta = Math.sqrt(x1 * x1 + x2 * x2);
        }
        return theta;
    }

    public final class DoubleRef {
        private double d;
        private final /* synthetic */ ImprovedSkyCalcMethods $outer;

        public DoubleRef(ImprovedSkyCalcMethods $outer, double d) {
            this.d = d;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public double d() {
            return this.d;
        }

        public void d_$eq(double x$1) {
            this.d = x$1;
        }

        public String toString() {
            return BoxesRunTime.boxToDouble((double)this.d()).toString();
        }

        public final /* synthetic */ ImprovedSkyCalcMethods lucuma$core$math$skycalc$ImprovedSkyCalcMethods$DoubleRef$$$outer() {
            return this.$outer;
        }
    }
}

