/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import cats.Show;
import cats.kernel.Eq;
import java.io.Serializable;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Angle$package$HourAngle$;
import lucuma.core.math.Coordinates;
import lucuma.core.math.Declination;
import lucuma.core.math.Declination$;
import lucuma.core.math.Place;
import lucuma.core.math.skycalc.SkyCalcResults$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class SkyCalcResults
implements Product,
Serializable {
    private final double altitudeRaw;
    private final double azimuthRaw;
    private final double parallacticAngleRaw;
    private final double airmass;
    private final double hourAngleRaw;
    private final float lunarIlluminatedFraction;
    private final double lunarSkyBrightness;
    private final double totalSkyBrightness;
    private final double lunarPhaseAngleRaw;
    private final double sunAltitudeRaw;
    private final double lunarDistance;
    private final double lunarElevationRaw;
    private final Coordinates coordinates;
    private final Place place;
    private final Declination altitude;
    private final long azimuth;
    private final long parallacticAngle;
    private final long hourAngle;
    private final long lunarPhaseAngle;
    private final Declination sunAltitude;
    private final Declination lunarElevation;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SkyCalcResults$.class.getDeclaredField("SkyCalcResultsShow$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SkyCalcResults$.class.getDeclaredField("given_Eq_SkyCalcResults$lzy1"));

    public static Show<SkyCalcResults> SkyCalcResultsShow() {
        return SkyCalcResults$.MODULE$.SkyCalcResultsShow();
    }

    public static SkyCalcResults fromProduct(Product product) {
        return SkyCalcResults$.MODULE$.fromProduct(product);
    }

    public static Eq<SkyCalcResults> given_Eq_SkyCalcResults() {
        return SkyCalcResults$.MODULE$.given_Eq_SkyCalcResults();
    }

    public static SkyCalcResults unapply(SkyCalcResults skyCalcResults) {
        return SkyCalcResults$.MODULE$.unapply(skyCalcResults);
    }

    public SkyCalcResults(double altitudeRaw, double azimuthRaw, double parallacticAngleRaw, double airmass, double hourAngleRaw, float lunarIlluminatedFraction, double lunarSkyBrightness, double totalSkyBrightness, double lunarPhaseAngleRaw, double sunAltitudeRaw, double lunarDistance, double lunarElevationRaw, Coordinates coordinates, Place place) {
        this.altitudeRaw = altitudeRaw;
        this.azimuthRaw = azimuthRaw;
        this.parallacticAngleRaw = parallacticAngleRaw;
        this.airmass = airmass;
        this.hourAngleRaw = hourAngleRaw;
        this.lunarIlluminatedFraction = lunarIlluminatedFraction;
        this.lunarSkyBrightness = lunarSkyBrightness;
        this.totalSkyBrightness = totalSkyBrightness;
        this.lunarPhaseAngleRaw = lunarPhaseAngleRaw;
        this.sunAltitudeRaw = sunAltitudeRaw;
        this.lunarDistance = lunarDistance;
        this.lunarElevationRaw = lunarElevationRaw;
        this.coordinates = coordinates;
        this.place = place;
        this.altitude = (Declination)Declination$.MODULE$.fromAngleWithCarry(Angle$package$Angle$.MODULE$.fromDoubleDegrees(altitudeRaw))._1();
        this.azimuth = Angle$package$Angle$.MODULE$.fromDoubleDegrees(azimuthRaw);
        this.parallacticAngle = Angle$package$Angle$.MODULE$.fromDoubleDegrees(parallacticAngleRaw);
        this.hourAngle = Angle$package$HourAngle$.MODULE$.fromDoubleHours(hourAngleRaw);
        this.lunarPhaseAngle = Angle$package$Angle$.MODULE$.fromDoubleDegrees(lunarPhaseAngleRaw);
        this.sunAltitude = (Declination)Declination$.MODULE$.fromAngleWithCarry(Angle$package$Angle$.MODULE$.fromDoubleDegrees(sunAltitudeRaw))._1();
        this.lunarElevation = (Declination)Declination$.MODULE$.fromAngleWithCarry(Angle$package$Angle$.MODULE$.fromDoubleDegrees(lunarElevationRaw))._1();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.altitudeRaw()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.azimuthRaw()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.parallacticAngleRaw()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.airmass()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.hourAngleRaw()));
        n = Statics.mix((int)n, (int)Statics.floatHash((float)this.lunarIlluminatedFraction()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lunarSkyBrightness()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.totalSkyBrightness()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lunarPhaseAngleRaw()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sunAltitudeRaw()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lunarDistance()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lunarElevationRaw()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coordinates()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.place()));
        return Statics.finalizeHash((int)n, (int)14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SkyCalcResults)) return false;
        SkyCalcResults skyCalcResults = (SkyCalcResults)object;
        if (this.altitudeRaw() != skyCalcResults.altitudeRaw()) return false;
        if (this.azimuthRaw() != skyCalcResults.azimuthRaw()) return false;
        if (this.parallacticAngleRaw() != skyCalcResults.parallacticAngleRaw()) return false;
        if (this.airmass() != skyCalcResults.airmass()) return false;
        if (this.hourAngleRaw() != skyCalcResults.hourAngleRaw()) return false;
        if (this.lunarIlluminatedFraction() != skyCalcResults.lunarIlluminatedFraction()) return false;
        if (this.lunarSkyBrightness() != skyCalcResults.lunarSkyBrightness()) return false;
        if (this.totalSkyBrightness() != skyCalcResults.totalSkyBrightness()) return false;
        if (this.lunarPhaseAngleRaw() != skyCalcResults.lunarPhaseAngleRaw()) return false;
        if (this.sunAltitudeRaw() != skyCalcResults.sunAltitudeRaw()) return false;
        if (this.lunarDistance() != skyCalcResults.lunarDistance()) return false;
        if (this.lunarElevationRaw() != skyCalcResults.lunarElevationRaw()) return false;
        Coordinates coordinates = this.coordinates();
        Coordinates coordinates2 = skyCalcResults.coordinates();
        if (coordinates == null) {
            if (coordinates2 != null) {
                return false;
            }
        } else if (!((Object)coordinates).equals(coordinates2)) return false;
        Place place = this.place();
        Place place2 = skyCalcResults.place();
        if (place == null) {
            if (place2 == null) return true;
            return false;
        } else {
            if (!((Object)place).equals(place2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SkyCalcResults;
    }

    public int productArity() {
        return 14;
    }

    public String productPrefix() {
        return "SkyCalcResults";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToDouble((double)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToDouble((double)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToDouble((double)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToDouble((double)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToDouble((double)this._5());
            }
            case 5: {
                return BoxesRunTime.boxToFloat((float)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToDouble((double)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToDouble((double)this._8());
            }
            case 8: {
                return BoxesRunTime.boxToDouble((double)this._9());
            }
            case 9: {
                return BoxesRunTime.boxToDouble((double)this._10());
            }
            case 10: {
                return BoxesRunTime.boxToDouble((double)this._11());
            }
            case 11: {
                return BoxesRunTime.boxToDouble((double)this._12());
            }
            case 12: {
                return this._13();
            }
            case 13: {
                return this._14();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "altitudeRaw";
            }
            case 1: {
                return "azimuthRaw";
            }
            case 2: {
                return "parallacticAngleRaw";
            }
            case 3: {
                return "airmass";
            }
            case 4: {
                return "hourAngleRaw";
            }
            case 5: {
                return "lunarIlluminatedFraction";
            }
            case 6: {
                return "lunarSkyBrightness";
            }
            case 7: {
                return "totalSkyBrightness";
            }
            case 8: {
                return "lunarPhaseAngleRaw";
            }
            case 9: {
                return "sunAltitudeRaw";
            }
            case 10: {
                return "lunarDistance";
            }
            case 11: {
                return "lunarElevationRaw";
            }
            case 12: {
                return "coordinates";
            }
            case 13: {
                return "place";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double altitudeRaw() {
        return this.altitudeRaw;
    }

    public double azimuthRaw() {
        return this.azimuthRaw;
    }

    public double parallacticAngleRaw() {
        return this.parallacticAngleRaw;
    }

    public double airmass() {
        return this.airmass;
    }

    public double hourAngleRaw() {
        return this.hourAngleRaw;
    }

    public float lunarIlluminatedFraction() {
        return this.lunarIlluminatedFraction;
    }

    public double lunarSkyBrightness() {
        return this.lunarSkyBrightness;
    }

    public double totalSkyBrightness() {
        return this.totalSkyBrightness;
    }

    public double lunarPhaseAngleRaw() {
        return this.lunarPhaseAngleRaw;
    }

    public double sunAltitudeRaw() {
        return this.sunAltitudeRaw;
    }

    public double lunarDistance() {
        return this.lunarDistance;
    }

    public double lunarElevationRaw() {
        return this.lunarElevationRaw;
    }

    public Coordinates coordinates() {
        return this.coordinates;
    }

    public Place place() {
        return this.place;
    }

    public Declination altitude() {
        return this.altitude;
    }

    public long azimuth() {
        return this.azimuth;
    }

    public long parallacticAngle() {
        return this.parallacticAngle;
    }

    public long hourAngle() {
        return this.hourAngle;
    }

    public long lunarPhaseAngle() {
        return this.lunarPhaseAngle;
    }

    public Declination sunAltitude() {
        return this.sunAltitude;
    }

    public Declination lunarElevation() {
        return this.lunarElevation;
    }

    public SkyCalcResults copy(double altitudeRaw, double azimuthRaw, double parallacticAngleRaw, double airmass, double hourAngleRaw, float lunarIlluminatedFraction, double lunarSkyBrightness, double totalSkyBrightness, double lunarPhaseAngleRaw, double sunAltitudeRaw, double lunarDistance, double lunarElevationRaw, Coordinates coordinates, Place place) {
        return new SkyCalcResults(altitudeRaw, azimuthRaw, parallacticAngleRaw, airmass, hourAngleRaw, lunarIlluminatedFraction, lunarSkyBrightness, totalSkyBrightness, lunarPhaseAngleRaw, sunAltitudeRaw, lunarDistance, lunarElevationRaw, coordinates, place);
    }

    public double copy$default$1() {
        return this.altitudeRaw();
    }

    public double copy$default$2() {
        return this.azimuthRaw();
    }

    public double copy$default$3() {
        return this.parallacticAngleRaw();
    }

    public double copy$default$4() {
        return this.airmass();
    }

    public double copy$default$5() {
        return this.hourAngleRaw();
    }

    public float copy$default$6() {
        return this.lunarIlluminatedFraction();
    }

    public double copy$default$7() {
        return this.lunarSkyBrightness();
    }

    public double copy$default$8() {
        return this.totalSkyBrightness();
    }

    public double copy$default$9() {
        return this.lunarPhaseAngleRaw();
    }

    public double copy$default$10() {
        return this.sunAltitudeRaw();
    }

    public double copy$default$11() {
        return this.lunarDistance();
    }

    public double copy$default$12() {
        return this.lunarElevationRaw();
    }

    public Coordinates copy$default$13() {
        return this.coordinates();
    }

    public Place copy$default$14() {
        return this.place();
    }

    public double _1() {
        return this.altitudeRaw();
    }

    public double _2() {
        return this.azimuthRaw();
    }

    public double _3() {
        return this.parallacticAngleRaw();
    }

    public double _4() {
        return this.airmass();
    }

    public double _5() {
        return this.hourAngleRaw();
    }

    public float _6() {
        return this.lunarIlluminatedFraction();
    }

    public double _7() {
        return this.lunarSkyBrightness();
    }

    public double _8() {
        return this.totalSkyBrightness();
    }

    public double _9() {
        return this.lunarPhaseAngleRaw();
    }

    public double _10() {
        return this.sunAltitudeRaw();
    }

    public double _11() {
        return this.lunarDistance();
    }

    public double _12() {
        return this.lunarElevationRaw();
    }

    public Coordinates _13() {
        return this.coordinates();
    }

    public Place _14() {
        return this.place();
    }
}

