/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import lucuma.core.math.Constants$;
import lucuma.core.math.JulianDate;
import lucuma.core.math.JulianDate$;
import lucuma.core.math.skycalc.ImprovedSkyCalcMethods;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.runtime.IntRef;

public interface SunCalc
extends ImprovedSkyCalcMethods {
    public static double lst$(SunCalc $this, JulianDate jd, double longit) {
        return $this.lst(jd, longit);
    }

    default public double lst(JulianDate jd, double longit) {
        return this.lst(jd.toDouble(), longit);
    }

    public static double altit$(SunCalc $this, double dec, double ha, double lat) {
        return $this.altit(dec, ha, lat);
    }

    default public double altit(double dec, double ha, double lat) {
        ImprovedSkyCalcMethods.DoubleRef az = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        ImprovedSkyCalcMethods.DoubleRef parang = new ImprovedSkyCalcMethods.DoubleRef(this, this.DoubleRef().$lessinit$greater$default$1());
        return this.altit(dec, ha, lat, az, parang);
    }

    public static Option jd_sun_alt$(SunCalc $this, double alt, JulianDate jdguess0, double lat, double longit) {
        return $this.jd_sun_alt(alt, jdguess0, lat, longit);
    }

    default public Option<JulianDate> jd_sun_alt(double alt, JulianDate jdguess0, double lat, double longit) {
        double del = 0.002;
        JulianDate jdguess = jdguess0;
        Tuple2<Object, Object> sun = this.lpsun(jdguess);
        double ra = sun._1$mcD$sp();
        double dec = sun._2$mcD$sp();
        double ha = this.lst(jdguess, longit) - ra;
        double alt2 = this.altit(dec, ha, lat);
        jdguess = JulianDate$.MODULE$.fromDoubleApprox(jdguess.toDouble() + del);
        sun = this.lpsun(jdguess);
        ra = sun._1$mcD$sp();
        dec = sun._2$mcD$sp();
        double alt3 = this.altit(dec, this.lst(jdguess, longit) - ra, lat);
        double err = alt3 - alt;
        double deriv = (alt3 - alt2) / del;
        IntRef i = IntRef.create((int)0);
        while (Math.abs(err) > 0.1 && i.elem < 10) {
            jdguess = JulianDate$.MODULE$.fromDoubleApprox(jdguess.toDouble() - err / deriv);
            sun = this.lpsun(jdguess);
            ra = sun._1$mcD$sp();
            dec = sun._2$mcD$sp();
            alt3 = this.altit(dec, this.lst(jdguess, longit) - ra, lat);
            err = alt3 - alt;
            ++i.elem;
        }
        JulianDate julianDate = (JulianDate)package.all$.MODULE$.catsSyntaxOptionId((Object)jdguess);
        return OptionIdOps$.MODULE$.some$extension((Object)julianDate).filter((Function1 & Serializable)_$1 -> i$1.elem < 9);
    }

    public static double ha_alt$(SunCalc $this, double dec0, double lat0, double alt) {
        return $this.ha_alt(dec0, lat0, alt);
    }

    default public double ha_alt(double dec0, double lat0, double alt) {
        double dec = dec0;
        double lat = lat0;
        double[] min_max = null;
        try {
            min_max = this.min_max_alt(lat, dec);
        }
        catch (Exception exception) {
            return 1000.0;
        }
        if (alt < min_max[0]) {
            return 1000.0;
        }
        if (alt > min_max[1]) {
            return -1000.0;
        }
        dec = Constants$.MODULE$.HalfPi() - dec / Constants$.MODULE$.DegsInRadian();
        lat = Constants$.MODULE$.HalfPi() - lat / Constants$.MODULE$.DegsInRadian();
        double coalt = Constants$.MODULE$.HalfPi() - alt / Constants$.MODULE$.DegsInRadian();
        double x = (Math.cos(coalt) - Math.cos(dec) * Math.cos(lat)) / (Math.sin(dec) * Math.sin(lat));
        if (Math.abs(x) <= 1.0) {
            return Math.acos(x) * Constants$.MODULE$.HrsInRadian();
        }
        throw new RuntimeException("Error in ha_alt ... acos(>1).");
    }

    public static double[] min_max_alt$(SunCalc $this, double lat0, double dec0) {
        return $this.min_max_alt(lat0, dec0);
    }

    default public double[] min_max_alt(double lat0, double dec0) {
        double x;
        double lat = lat0;
        double dec = dec0;
        double min = 0.0;
        double max = 0.0;
        if (!(Math.abs(x = Math.cos(dec /= Constants$.MODULE$.DegsInRadian()) * Math.cos(lat /= Constants$.MODULE$.DegsInRadian()) + Math.sin(dec) * Math.sin(lat)) <= 1.0)) {
            throw new RuntimeException("Error in min_max_alt -- arcsin(>1)");
        }
        max = Math.asin(x) * Constants$.MODULE$.DegsInRadian();
        x = Math.sin(dec) * Math.sin(lat) - Math.cos(dec) * Math.cos(lat);
        if (!(Math.abs(x) <= 1.0)) {
            throw new RuntimeException("Error in min_max_alt -- arcsin(>1)");
        }
        min = Math.asin(x) * Constants$.MODULE$.DegsInRadian();
        return new double[]{min, max};
    }

    public static Tuple2 lpsun$(SunCalc $this, JulianDate jd) {
        return $this.lpsun(jd);
    }

    default public Tuple2<Object, Object> lpsun(JulianDate jd) {
        double n = jd.toDouble() - JulianDate$.MODULE$.J2000().toDouble();
        double L = 280.46 + 0.9856474 * n;
        double g = (357.528 + 0.9856003 * n) / Constants$.MODULE$.DegsInRadian();
        double lambda = (L + 1.915 * Math.sin(g) + 0.02 * Math.sin(2.0 * g)) / Constants$.MODULE$.DegsInRadian();
        double epsilon = (23.439 - 4.0E-7 * n) / Constants$.MODULE$.DegsInRadian();
        double x = Math.cos(lambda);
        double y = Math.cos(epsilon) * Math.sin(lambda);
        double z = Math.sin(epsilon) * Math.sin(lambda);
        double ra = this.atan_circ(x, y) * Constants$.MODULE$.HrsInRadian();
        double dec = Math.asin(z) * Constants$.MODULE$.DegsInRadian();
        return new Tuple2.mcDD.sp(ra, dec);
    }
}

