/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import cats.FunctorFilter;
import cats.FunctorFilter$;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import coulomb.ops.SimplifiedUnit;
import coulomb.ops.standard.div;
import coulomb.policy.spire.standard$;
import coulomb.quantity;
import coulomb.quantity$package$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import lucuma.core.enums.TwilightType;
import lucuma.core.enums.TwilightType$Official$;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.BoundedInterval$package$BoundedInterval$;
import lucuma.core.math.Constants$;
import lucuma.core.math.JulianDate;
import lucuma.core.math.JulianDate$;
import lucuma.core.math.Place;
import lucuma.core.math.skycalc.SunCalc;
import lucuma.core.math.skycalc.TwilightCalc$;
import lucuma.core.math.units$;
import lucuma.core.optics.Spire$;
import org.typelevel.cats.time.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction2;
import spire.math.ConvertableFrom;
import spire.math.ConvertableTo$;
import spire.math.Fractional$;
import spire.math.extras.interval.IntervalSeq;
import spire.math.extras.interval.IntervalSeq$;
import spire.std.package;

public interface TwilightCalc
extends SunCalc {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TwilightCalc$.class.getDeclaredField("DoubleRef$lzy1"));

    public static Option forDate$(TwilightCalc $this, TwilightType twilightType, LocalDate date, Place place) {
        return $this.forDate(twilightType, date, place);
    }

    default public Option<Product> forDate(TwilightType twilightType, LocalDate date, Place place) {
        double d;
        ZonedDateTime nextMidnight = date.atStartOfDay(place.timezone()).plusDays(1L);
        JulianDate jdmid = JulianDate$.MODULE$.ofInstant(nextMidnight.toInstant());
        TwilightType twilightType2 = twilightType;
        if (TwilightType$Official$.MODULE$.equals(twilightType2)) {
            quantity$package$ quantity$package$2;
            quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
            quantity$package$ quantity$package$4 = quantity$package$.MODULE$;
            quantity$package$ quantity$package$_this = quantity$package$2 = quantity$package$.MODULE$;
            int ql$proxy2 = place.altitude();
            quantity$package$ quantity$package$5 = quantity$package$2;
            int ql$proxy3 = ql$proxy2;
            double v$proxy1 = units$.MODULE$.given_ValueConversion_NonNegInt_Double().apply$mcDI$sp(ql$proxy3);
            double ql$proxy1 = BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy1)));
            double qr$proxy1 = BoxesRunTime.unboxToDouble(Constants$.MODULE$.EquatorialRadius(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.DoubleIsFractional(), (ConvertableFrom)standard$.MODULE$.ctx_ConvertableFromCoulombRational(), ConvertableTo$.MODULE$.ConvertableToDouble())));
            .eq.colon.eq eqv$proxy1 = $less$colon$less$.MODULE$.refl();
            SimplifiedUnit.NC su$proxy1 = new SimplifiedUnit.NC();
            div.infra$.DivNC div$proxy1 = new div.infra$.DivNC((Function2)(JFunction2.mcDDD.sp & Serializable)(ql, qr) -> {
                quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
                double ql$proxy4 = ql;
                quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                double ql$proxy5 = qr;
                double v$proxy2 = BoxesRunTime.unboxToDouble((Object)package.double$.MODULE$.DoubleAlgebra().div((Object)BoxesRunTime.boxToDouble((double)ql$proxy4), (Object)BoxesRunTime.boxToDouble((double)eqv$proxy1.apply$mcDD$sp(ql$proxy5))));
                return BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy2)));
            });
            double ql$proxy6 = div$proxy1.eval().apply$mcDDD$sp(ql$proxy1, qr$proxy1);
            d = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(twilightType.horizonAngle().toAngle()) + Math.sqrt(2.0 * ql$proxy6) * Constants$.MODULE$.DegsInRadian();
        } else {
            d = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(twilightType.horizonAngle().toAngle());
        }
        double angle = d;
        return this.calcTimes(angle, jdmid, place).flatMap(BoundedInterval$package$BoundedInterval$.MODULE$.openUpperFromTuple((Order)package$.MODULE$.instantInstances()).getOption());
    }

    public static IntervalSeq forBoundedInterval$(TwilightCalc $this, TwilightType twilightType, Product interval, Place place) {
        return $this.forBoundedInterval(twilightType, interval, place);
    }

    default public IntervalSeq<Instant> forBoundedInterval(TwilightType twilightType, Product interval, Place place) {
        LocalDate startDate = ((Instant)BoundedInterval$package$BoundedInterval$.MODULE$.lower(interval)).atZone(place.timezone()).toLocalDate();
        LocalDate endDate = ((Instant)BoundedInterval$package$BoundedInterval$.MODULE$.upper(interval)).atZone(place.timezone()).toLocalDate();
        List dates = (List)scala.package$.MODULE$.List().unfold((Object)startDate, (Function1 & Serializable)date -> {
            if (package.all$.MODULE$.catsSyntaxPartialOrder(date, (PartialOrder)package$.MODULE$.localdateInstances()).$less$eq((Object)endDate)) {
                Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxOptionId((Object)Tuple2$.MODULE$.apply(date, (Object)date.plusDays(1L)));
                return OptionIdOps$.MODULE$.some$extension((Object)tuple2);
            }
            return package.all$.MODULE$.none();
        });
        List twilightIntervals = (List)package.all$.MODULE$.toFunctorFilterOps((Object)dates.map((Function1 & Serializable)d -> this.forDate(twilightType, (LocalDate)d, place)), (FunctorFilter)FunctorFilter$.MODULE$.catsTraverseFilterForList()).flattenOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return ((IntervalSeq)Spire$.MODULE$.intervalListUnion((Order)package$.MODULE$.instantInstances()).get().apply((Object)twilightIntervals.map((Function1 & Serializable)_$1 -> BoundedInterval$package$BoundedInterval$.MODULE$.toInterval((Product)_$1)))).$amp(IntervalSeq$.MODULE$.apply(BoundedInterval$package$BoundedInterval$.MODULE$.toInterval(interval), (Order)package$.MODULE$.instantInstances()));
    }

    private Option<Tuple2<Instant, Instant>> calcTimes(double angle, JulianDate jdmid, Place place) {
        Tuple2<Object, Object> tuple2 = this.lpsun(jdmid);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double rasun = tuple2._1$mcD$sp();
        double decsun = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(rasun, decsun);
        double rasun2 = sp2._1$mcD$sp();
        double decsun2 = sp2._2$mcD$sp();
        double lat = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place.latitude().toAngle());
        double longit = -(Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place.longitude()) / 15.0);
        double hasunset = this.ha_alt(decsun2, lat, -angle);
        if (hasunset > 900.0) {
            return package.all$.MODULE$.none();
        }
        if (hasunset < -900.0) {
            return package.all$.MODULE$.none();
        }
        double stmid = this.lst(jdmid, longit);
        DoubleRef tmp = DoubleRef.create((double)(jdmid.toDouble() + this.adj_time(rasun2 + hasunset - stmid) / 24.0));
        return this.jd_sun_alt(-angle, JulianDate$.MODULE$.fromDoubleApprox(tmp.elem), lat, longit).flatMap((Function1 & Serializable)jdSet -> {
            tmp$1.elem = jdmid.toDouble() + this.adj_time(rasun2 - hasunset - stmid) / 24.0;
            return this.jd_sun_alt(-angle, JulianDate$.MODULE$.fromDoubleApprox(tmp$1.elem), lat, longit).map((Function1 & Serializable)jdRise -> Tuple2$.MODULE$.apply((Object)jdSet.toInstant(), (Object)jdRise.toInstant()));
        });
    }
}

