/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.kernel.Semigroup$;
import cats.syntax.OptionOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Coordinates;
import lucuma.core.math.Place;
import lucuma.core.math.skycalc.ImprovedSkyCalc;
import lucuma.core.model.ObjectTracking;
import lucuma.core.model.ObjectTracking$package$CoordinatesAtVizTime$;
import lucuma.core.util.TimeSpan$package$TimeSpan$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class package$package$
implements Serializable {
    public static final package$package$ MODULE$ = new package$package$();

    private package$package$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$package$.class);
    }

    public long duration(Tuple2<Object, Object> r) {
        return r._2$mcJ$sp() - r._1$mcJ$sp();
    }

    public long start(Tuple2<Object, Object> r) {
        return r._1$mcJ$sp();
    }

    public long end(Tuple2<Object, Object> r) {
        return r._2$mcJ$sp();
    }

    public long parallacticAngle(Place place, ObjectTracking tracking2, Instant vizTime) {
        ImprovedSkyCalc skycalc = new ImprovedSkyCalc(place);
        Coordinates c = (Coordinates)tracking2.at(vizTime).map((Function1 & Serializable)_$1 -> {
            ObjectTracking$package$CoordinatesAtVizTime$ objectTracking$package$CoordinatesAtVizTime$ = ObjectTracking$package$CoordinatesAtVizTime$.MODULE$;
            Coordinates t$proxy1 = _$1;
            return t$proxy1;
        }).getOrElse(() -> package$package$.$anonfun$2(tracking2));
        return skycalc.calculate(c, vizTime, false).parallacticAngle();
    }

    public Option<Object> averageParallacticAngle(Place place, ObjectTracking tracking2, Instant vizTime, long duration2, long samplingRate) {
        Tuple2 defined = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)vizTime.toEpochMilli()), (Object)BoxesRunTime.boxToLong((long)vizTime.plus(TimeSpan$package$TimeSpan$.MODULE$.toDuration(duration2)).toEpochMilli()));
        long rate = TimeSpan$package$TimeSpan$.MODULE$.toMilliseconds(samplingRate).toLong();
        int cnt = (int)package$.MODULE$.ceil((double)this.duration((Tuple2<Object, Object>)defined) / (double)rate);
        double preciseRate = (double)this.duration((Tuple2<Object, Object>)defined) / (double)cnt;
        IndexedSeq ts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), cnt).map((Function1)(JFunction1.mcJI.sp & Serializable)i -> (long)Math.ceil((double)MODULE$.start((Tuple2<Object, Object>)defined) + (double)i * preciseRate));
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)ts.head()) == this.start((Tuple2<Object, Object>)defined));
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)ts.last()) >= this.end((Tuple2<Object, Object>)defined));
        Vector times = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ts);
        return this.weightedMeanParallacticAngle$1(times, tracking2, place).map((Function1)(JFunction1.mcJD.sp & Serializable)ds -> Angle$package$Angle$.MODULE$.fromDoubleDegrees(ds));
    }

    public long averageParallacticAngle$default$5() {
        return TimeSpan$package$TimeSpan$.MODULE$.unsafeFromMicroseconds(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds().toMicros());
    }

    private static final Coordinates $anonfun$2(ObjectTracking tracking$1) {
        return tracking$1.baseCoordinates();
    }

    private static final /* synthetic */ Option calculate$1$$anonfun$1(ObjectTracking tracking$3, ImprovedSkyCalc skycalc$1, long t) {
        Instant at = Instant.ofEpochMilli(t);
        Option<Coordinates> coords2 = tracking$3.at(at);
        return coords2.map((Function1 & Serializable)coords -> {
            ObjectTracking$package$CoordinatesAtVizTime$ objectTracking$package$CoordinatesAtVizTime$ = ObjectTracking$package$CoordinatesAtVizTime$.MODULE$;
            Coordinates t$proxy2 = coords;
            return skycalc$1.calculate(t$proxy2, Instant.ofEpochMilli(t), false);
        });
    }

    private final Vector calculate$1(Place place$1, Vector times$1, ObjectTracking tracking$2) {
        ImprovedSkyCalc skycalc = new ImprovedSkyCalc(place$1);
        Option option = package.all$.MODULE$.catsSyntaxOption((Option)package.all$.MODULE$.toTraverseOps((Object)times$1, UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)t -> package$package$.calculate$1$$anonfun$1(tracking$2, skycalc, BoxesRunTime.unboxToLong((Object)t)), (Applicative)Invariant$.MODULE$.catsInstancesForOption()));
        return (Vector)OptionOps$.MODULE$.orEmpty$extension(option, Semigroup$.MODULE$.catsKernelMonoidForVector());
    }

    private static final Coordinates $anonfun$8(ObjectTracking tracking$6) {
        return tracking$6.baseCoordinates();
    }

    private final Option weightedMeanParallacticAngle$1(Vector times$2, ObjectTracking tracking$4, Place place$2) {
        Vector values = this.calculate$1(place$2, times$2, tracking$4);
        Tuple2 tuple2 = ((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)values.map((Function1 & Serializable)_$2 -> Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(_$2.parallacticAngle()))).zip((IterableOnce)times$2)).zip((IterableOnce)values.map((Function1 & Serializable)_$3 -> _$3.airmass()))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                double d;
                double angle = tuple2._1$mcD$sp();
                long t = tuple2._2$mcJ$sp();
                double airmass = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                if (angle < 0.0) {
                    double dec = Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(((Coordinates)tracking$4.at(Instant.ofEpochMilli(t)).map((Function1 & Serializable)_$4 -> {
                        ObjectTracking$package$CoordinatesAtVizTime$ objectTracking$package$CoordinatesAtVizTime$ = ObjectTracking$package$CoordinatesAtVizTime$.MODULE$;
                        Coordinates t$proxy3 = _$4;
                        return t$proxy3;
                    }).getOrElse(() -> package$package$.$anonfun$8(tracking$4))).dec().toAngle());
                    int normalizingFactor = dec - Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place$2.latitude().toAngle()) < (double)-10 ? 0 : (dec - Angle$package$Angle$.MODULE$.toSignedDoubleDegrees(place$2.latitude().toAngle()) < (double)10 ? 180 : 360);
                    d = angle + (double)normalizingFactor;
                } else {
                    d = angle;
                }
                double normalizedAngle = d;
                double weight = airmass <= 0.0 ? 0.0 : package$.MODULE$.pow(airmass - 1.0, 1.3);
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(normalizedAngle * weight)), (Object)BoxesRunTime.boxToDouble((double)weight));
            }
            throw new MatchError((Object)tuple22);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector weightedAngles = (Vector)tuple2._1();
        Vector weights = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)weightedAngles, (Object)weights);
        Vector weightedAngles2 = (Vector)tuple22._1();
        Vector weights2 = (Vector)tuple22._2();
        double weightedSum = BoxesRunTime.unboxToDouble((Object)weights2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (weightedSum == 0.0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)weightedAngles2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightedSum)));
    }
}

