/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc.solver;

import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Declination;
import lucuma.core.math.Declination$;
import lucuma.core.math.skycalc.SkyCalcResults;
import lucuma.core.math.skycalc.solver.AirmassConstraint$;
import lucuma.core.math.skycalc.solver.Constraint;
import lucuma.core.math.skycalc.solver.SampleRounder;
import lucuma.core.math.skycalc.solver.Samples;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class AirmassConstraint
implements Constraint<SkyCalcResults, Tuple2<Object, Declination>>,
Product,
Serializable {
    private final double min;
    private final double max;
    private final Declination MinElevation;

    public static AirmassConstraint apply(double d, double d2) {
        return AirmassConstraint$.MODULE$.apply(d, d2);
    }

    public static AirmassConstraint fromProduct(Product product) {
        return AirmassConstraint$.MODULE$.fromProduct(product);
    }

    public static AirmassConstraint unapply(AirmassConstraint airmassConstraint) {
        return AirmassConstraint$.MODULE$.unapply(airmassConstraint);
    }

    public AirmassConstraint(double min, double max) {
        this.min = min;
        this.max = max;
        this.MinElevation = (Declination)Declination$.MODULE$.fromAngleWithCarry(Angle$package$Angle$.MODULE$.fromDoubleDegrees(5.0))._1();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.min()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.max()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AirmassConstraint)) return false;
        AirmassConstraint airmassConstraint = (AirmassConstraint)object;
        if (this.min() != airmassConstraint.min()) return false;
        if (this.max() != airmassConstraint.max()) return false;
        if (!airmassConstraint.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AirmassConstraint;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "AirmassConstraint";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        if (0 == n2) {
            d = this._1();
        } else if (1 == n2) {
            d = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "min";
        }
        if (1 == n2) {
            return "max";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    @Override
    public <R> boolean metAt(Samples<SkyCalcResults> samples, Instant i, SampleRounder<R, Tuple2<Object, Declination>> evidence$1) {
        return BoxesRunTime.unboxToBoolean((Object)samples.map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)r.airmass()), (Object)r.altitude())).valueAt(i, evidence$1).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double airmass = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                Declination elevation = (Declination)tuple2._2();
                return package.all$.MODULE$.catsSyntaxPartialOrder((Object)elevation, Declination$.MODULE$.given_Order_Declination()).$greater$eq((Object)this.MinElevation) && airmass >= this.min() && airmass <= this.max();
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse(AirmassConstraint::metAt$$anonfun$9));
    }

    public AirmassConstraint copy(double min, double max) {
        return new AirmassConstraint(min, max);
    }

    public double copy$default$1() {
        return this.min();
    }

    public double copy$default$2() {
        return this.max();
    }

    public double _1() {
        return this.min();
    }

    public double _2() {
        return this.max();
    }

    private static final boolean metAt$$anonfun$9() {
        return false;
    }
}

