/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc.solver;

import java.io.Serializable;
import java.time.Duration;
import lucuma.core.math.Declination;
import lucuma.core.math.skycalc.SkyCalcResults;
import lucuma.core.math.skycalc.solver.AirmassConstraint$;
import lucuma.core.math.skycalc.solver.AirmassSolver$;
import lucuma.core.math.skycalc.solver.ConstraintSolver;
import lucuma.core.math.skycalc.solver.Solver$;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class AirmassSolver
extends ConstraintSolver<Object, Object, SkyCalcResults, Tuple2<Object, Declination>>
implements Product,
Serializable {
    private final double min;
    private final double max;
    private final Duration tolerance;

    public static AirmassSolver apply(double d, double d2, Duration duration2) {
        return AirmassSolver$.MODULE$.apply(d, d2, duration2);
    }

    public static AirmassSolver fromProduct(Product product) {
        return AirmassSolver$.MODULE$.fromProduct(product);
    }

    public static AirmassSolver unapply(AirmassSolver airmassSolver) {
        return AirmassSolver$.MODULE$.unapply(airmassSolver);
    }

    public static Duration $lessinit$greater$default$3() {
        return AirmassSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public AirmassSolver(double min, double max, Duration tolerance) {
        this.min = min;
        this.max = max;
        this.tolerance = tolerance;
        super(AirmassConstraint$.MODULE$.apply(min, max), tolerance, Solver$.MODULE$.DefaultSolver());
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.min()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.max()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tolerance()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AirmassSolver)) return false;
        AirmassSolver airmassSolver = (AirmassSolver)object;
        if (this.min() != airmassSolver.min()) return false;
        if (this.max() != airmassSolver.max()) return false;
        Duration duration2 = this.tolerance();
        Duration duration3 = airmassSolver.tolerance();
        if (duration2 == null) {
            if (duration3 != null) {
                return false;
            }
        } else if (!((Object)duration2).equals(duration3)) return false;
        if (!airmassSolver.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AirmassSolver;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "AirmassSolver";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToDouble((double)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToDouble((double)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "min";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "tolerance";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Duration tolerance() {
        return this.tolerance;
    }

    public AirmassSolver copy(double min, double max, Duration tolerance) {
        return new AirmassSolver(min, max, tolerance);
    }

    public double copy$default$1() {
        return this.min();
    }

    public double copy$default$2() {
        return this.max();
    }

    public Duration copy$default$3() {
        return this.tolerance();
    }

    public double _1() {
        return this.min();
    }

    public double _2() {
        return this.max();
    }

    public Duration _3() {
        return this.tolerance();
    }
}

