/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.skycalc.solver;

import java.io.Serializable;
import java.time.Duration;
import lucuma.core.math.Declination;
import lucuma.core.math.skycalc.SkyCalcResults;
import lucuma.core.math.skycalc.solver.ConstraintSolver;
import lucuma.core.math.skycalc.solver.ElevationConstraint$;
import lucuma.core.math.skycalc.solver.ElevationSolver$;
import lucuma.core.math.skycalc.solver.Solver$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ElevationSolver
extends ConstraintSolver<Object, Object, SkyCalcResults, Declination>
implements Product,
Serializable {
    private final Declination min;
    private final Declination max;
    private final Duration tolerance;

    public static ElevationSolver apply(Declination declination, Declination declination2, Duration duration2) {
        return ElevationSolver$.MODULE$.apply(declination, declination2, duration2);
    }

    public static ElevationSolver fromProduct(Product product) {
        return ElevationSolver$.MODULE$.fromProduct(product);
    }

    public static ElevationSolver unapply(ElevationSolver elevationSolver) {
        return ElevationSolver$.MODULE$.unapply(elevationSolver);
    }

    public static Duration $lessinit$greater$default$3() {
        return ElevationSolver$.MODULE$.$lessinit$greater$default$3();
    }

    public ElevationSolver(Declination min, Declination max, Duration tolerance) {
        this.min = min;
        this.max = max;
        this.tolerance = tolerance;
        super(ElevationConstraint$.MODULE$.apply(min, max), tolerance, Solver$.MODULE$.DefaultSolver());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ElevationSolver)) return false;
        ElevationSolver elevationSolver = (ElevationSolver)object;
        Declination declination = this.min();
        Declination declination2 = elevationSolver.min();
        if (declination == null) {
            if (declination2 != null) {
                return false;
            }
        } else if (!((Object)declination).equals(declination2)) return false;
        Declination declination3 = this.max();
        Declination declination4 = elevationSolver.max();
        if (declination3 == null) {
            if (declination4 != null) {
                return false;
            }
        } else if (!((Object)declination3).equals(declination4)) return false;
        Duration duration2 = this.tolerance();
        Duration duration3 = elevationSolver.tolerance();
        if (duration2 == null) {
            if (duration3 != null) {
                return false;
            }
        } else if (!((Object)duration2).equals(duration3)) return false;
        if (!elevationSolver.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ElevationSolver;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ElevationSolver";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "min";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "tolerance";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Declination min() {
        return this.min;
    }

    public Declination max() {
        return this.max;
    }

    public Duration tolerance() {
        return this.tolerance;
    }

    public ElevationSolver copy(Declination min, Declination max, Duration tolerance) {
        return new ElevationSolver(min, max, tolerance);
    }

    public Declination copy$default$1() {
        return this.min();
    }

    public Declination copy$default$2() {
        return this.max();
    }

    public Duration copy$default$3() {
        return this.tolerance();
    }

    public Declination _1() {
        return this.min();
    }

    public Declination _2() {
        return this.max();
    }

    public Duration _3() {
        return this.tolerance();
    }
}

