/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.math.validation;

import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import lucuma.core.math.Angle$package$;
import lucuma.core.math.Angle$package$Angle$;
import lucuma.core.math.Angle$package$HourAngle$;
import lucuma.core.math.Declination;
import lucuma.core.math.Declination$;
import lucuma.core.math.Epoch;
import lucuma.core.math.Epoch$;
import lucuma.core.math.RightAscension;
import lucuma.core.math.RightAscension$;
import lucuma.core.optics.ValidSplitEpi;
import lucuma.core.optics.ValidWedge;
import lucuma.core.syntax.string$;
import lucuma.core.validation.InputValidSplitEpi$;
import lucuma.core.validation.InputValidWedge$;
import lucuma.core.validation.package$;
import lucuma.refined.Predicate;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import spire.math.Rational$;

public interface MathValidators {
    public static void $init$(MathValidators $this) {
        Predicate.given_Predicate_String_Empty p$proxy1 = new Predicate.given_Predicate_String_Empty();
        Predicate.given_Predicate_T_Not given_Predicate_T_Not_this = new Predicate.given_Predicate_T_Not((Predicate)p$proxy1);
        Predicate.given_Predicate_String_Empty given_Predicate_String_Empty_this = (Predicate.given_Predicate_String_Empty)given_Predicate_T_Not_this.lucuma$refined$Predicate$given_Predicate_T_Not$$inline$p();
        $this.lucuma$core$math$validation$MathValidators$_setter_$epoch_$eq(InputValidSplitEpi$.MODULE$.fromPrism(Epoch$.MODULE$.fromString(), (String)Refined.package.Refined$.MODULE$.unsafeApply((Object)"Invalid epoch")));
        Predicate.given_Predicate_String_Empty p$proxy4 = new Predicate.given_Predicate_String_Empty();
        Predicate.given_Predicate_T_Not given_Predicate_T_Not_this2 = new Predicate.given_Predicate_T_Not((Predicate)p$proxy4);
        Predicate.given_Predicate_String_Empty given_Predicate_String_Empty_this2 = (Predicate.given_Predicate_String_Empty)given_Predicate_T_Not_this2.lucuma$refined$Predicate$given_Predicate_T_Not$$inline$p();
        $this.lucuma$core$math$validation$MathValidators$_setter_$epochNoScheme_$eq(InputValidWedge$.MODULE$.fromFormat(Epoch$.MODULE$.fromStringNoScheme(), (String)Refined.package.Refined$.MODULE$.unsafeApply((Object)"Invalid epoch")));
        $this.lucuma$core$math$validation$MathValidators$_setter_$angleArcSec_$eq(InputValidSplitEpi$.MODULE$.apply((Function1 & Serializable)_$1 -> package$.MODULE$.toEitherErrorsUnsafe(string$.MODULE$.parseBigDecimalOption((String)_$1).map((Function1 & Serializable)as -> Angle$package$Angle$.MODULE$.fromBigDecimalArcseconds((BigDecimal)as)).toRight(MathValidators::$init$$$anonfun$1$$anonfun$2)), (Function1 & Serializable)a -> MathValidators.$init$$$anonfun$2(BoxesRunTime.unboxToLong((Object)a))));
        $this.lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleSignedArcSec_$eq(InputValidWedge$.MODULE$.apply((Function1 & Serializable)_$2 -> package$.MODULE$.toEitherErrorsUnsafe(string$.MODULE$.parseBigDecimalOption((String)_$2).map(Angle$package$Angle$.MODULE$.signedDecimalArcseconds().reverseGet()).map((Function1)(JFunction1.mcJJ.sp & Serializable)angle -> this.truncateAngleSignedArcSec(angle)).toRight(MathValidators::$init$$$anonfun$3$$anonfun$2)), (Function1 & Serializable)a -> this.$init$$$anonfun$4(BoxesRunTime.unboxToLong((Object)a))));
        $this.lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleDegrees_$eq(InputValidWedge$.MODULE$.apply((Function1 & Serializable)_$3 -> package$.MODULE$.toEitherErrorsUnsafe(string$.MODULE$.parseBigDecimalOption((String)_$3).map((Function1 & Serializable)ds -> Angle$package$Angle$.MODULE$.fromBigDecimalDegrees((BigDecimal)ds)).map((Function1)(JFunction1.mcJJ.sp & Serializable)angle -> this.truncateDegrees(angle)).toRight(MathValidators::$init$$$anonfun$5$$anonfun$3)), (Function1 & Serializable)a -> this.$init$$$anonfun$6(BoxesRunTime.unboxToLong((Object)a))));
        $this.lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleSignedDegrees_$eq(InputValidWedge$.MODULE$.apply($this.truncatedAngleDegrees().getValid(), (Function1 & Serializable)a -> this.$init$$$anonfun$7(BoxesRunTime.unboxToLong((Object)a))));
        $this.lucuma$core$math$validation$MathValidators$_setter_$rightAscension_$eq(InputValidSplitEpi$.MODULE$.apply((Function1 & Serializable)s -> package$.MODULE$.toEitherErrorsUnsafe(((Option)RightAscension$.MODULE$.fromStringHMS().getOption().apply(s)).toRight(MathValidators::$init$$$anonfun$8$$anonfun$1)), RightAscension$.MODULE$.fromStringHMS().reverseGet()));
        $this.lucuma$core$math$validation$MathValidators$_setter_$truncatedRA_$eq(InputValidWedge$.MODULE$.apply($this.rightAscension().getValid().andThen((Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)ra -> this.truncateRA((RightAscension)ra))), (Function1 & Serializable)ra -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)RightAscension$.MODULE$.fromStringHMS().reverseGet().apply((Object)this.truncateRA((RightAscension)ra))), 3)));
        $this.lucuma$core$math$validation$MathValidators$_setter_$declination_$eq(InputValidSplitEpi$.MODULE$.apply((Function1 & Serializable)s -> package$.MODULE$.toEitherErrorsUnsafe(((Option)Declination$.MODULE$.fromStringSignedDMS().getOption().apply(s)).toRight(MathValidators::$init$$$anonfun$11$$anonfun$1)), Declination$.MODULE$.fromStringSignedDMS().reverseGet()));
        $this.lucuma$core$math$validation$MathValidators$_setter_$truncatedDec_$eq(InputValidWedge$.MODULE$.apply($this.declination().getValid().andThen((Function1 & Serializable)_$5 -> _$5.map((Function1 & Serializable)dec -> this.truncateDec((Declination)dec))), (Function1 & Serializable)dec -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)Declination$.MODULE$.fromStringSignedDMS().reverseGet().apply((Object)this.truncateDec((Declination)dec))), 4).replace("-00:00:00.00", "+00:00:00.00")));
    }

    public ValidSplitEpi<Object, String, Epoch> epoch();

    public void lucuma$core$math$validation$MathValidators$_setter_$epoch_$eq(ValidSplitEpi var1);

    public ValidWedge<Object, String, Epoch> epochNoScheme();

    public void lucuma$core$math$validation$MathValidators$_setter_$epochNoScheme_$eq(ValidWedge var1);

    public ValidSplitEpi<Object, String, Object> angleArcSec();

    public void lucuma$core$math$validation$MathValidators$_setter_$angleArcSec_$eq(ValidSplitEpi var1);

    private long truncateAngleSignedArcSec(long angle) {
        return BoxesRunTime.unboxToLong((Object)Angle$package$Angle$.MODULE$.signedDecimalArcseconds().reverseGet().apply((Object)((BigDecimal)Angle$package$Angle$.MODULE$.signedDecimalArcseconds().get().apply((Object)BoxesRunTime.boxToLong((long)angle))).$times(BigDecimal$.MODULE$.int2bigDecimal(100)).setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).$div(BigDecimal$.MODULE$.int2bigDecimal(100)).$plus(BigDecimal$.MODULE$.double2bigDecimal(0.0))));
    }

    public ValidWedge<Object, String, Object> truncatedAngleSignedArcSec();

    public void lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleSignedArcSec_$eq(ValidWedge var1);

    private long truncateDegrees(long angle) {
        return Angle$package$Angle$.MODULE$.fromBigDecimalDegrees(Angle$package$Angle$.MODULE$.toBigDecimalDegrees(angle).$times(BigDecimal$.MODULE$.int2bigDecimal(100)).setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).$div(BigDecimal$.MODULE$.int2bigDecimal(100)).$plus(BigDecimal$.MODULE$.double2bigDecimal(0.0)));
    }

    public ValidWedge<Object, String, Object> truncatedAngleDegrees();

    public void lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleDegrees_$eq(ValidWedge var1);

    public ValidWedge<Object, String, Object> truncatedAngleSignedDegrees();

    public void lucuma$core$math$validation$MathValidators$_setter_$truncatedAngleSignedDegrees_$eq(ValidWedge var1);

    public ValidSplitEpi<Object, String, RightAscension> rightAscension();

    public void lucuma$core$math$validation$MathValidators$_setter_$rightAscension_$eq(ValidSplitEpi var1);

    private RightAscension truncateRA(RightAscension ra) {
        long microSecs = Rational$.MODULE$.apply(Angle$package$HourAngle$.MODULE$.toMicroseconds(ra.toHourAngle()), 1000L).round().toLong() * 1000L;
        return RightAscension$.MODULE$.apply(Angle$package$HourAngle$.MODULE$.fromMicroseconds(microSecs));
    }

    public ValidWedge<Object, String, RightAscension> truncatedRA();

    public void lucuma$core$math$validation$MathValidators$_setter_$truncatedRA_$eq(ValidWedge var1);

    public ValidSplitEpi<Object, String, Declination> declination();

    public void lucuma$core$math$validation$MathValidators$_setter_$declination_$eq(ValidSplitEpi var1);

    private Declination truncateDec(Declination dec) {
        Angle$package$ angle$package$ = Angle$package$.MODULE$;
        long angle$proxy2 = dec.toAngle();
        long microArcSecs = Rational$.MODULE$.apply(angle$proxy2, 10000L).round().toLong() * 10000L;
        return (Declination)Declination$.MODULE$.fromAngleWithCarry(Angle$package$Angle$.MODULE$.fromMicroarcseconds(microArcSecs))._1();
    }

    public ValidWedge<Object, String, Declination> truncatedDec();

    public void lucuma$core$math$validation$MathValidators$_setter_$truncatedDec_$eq(ValidWedge var1);

    private static String $init$$$anonfun$1$$anonfun$2() {
        return "Invalid Angle";
    }

    private static /* synthetic */ String $init$$$anonfun$2(long a) {
        Angle$package$ angle$package$ = Angle$package$.MODULE$;
        long angle$proxy1 = a;
        return BoxesRunTime.boxToDouble((double)((double)angle$proxy1 / 1000000.0)).toString();
    }

    private static String $init$$$anonfun$3$$anonfun$2() {
        return "Invalid Angle";
    }

    private /* synthetic */ String $init$$$anonfun$4(long a) {
        return StringOps$.MODULE$.format$extension("%.2f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Angle$package$Angle$.MODULE$.signedDecimalArcseconds().get().apply((Object)BoxesRunTime.boxToLong((long)this.truncateAngleSignedArcSec(a)))})).replace("-0.00", "0.00");
    }

    private static String $init$$$anonfun$5$$anonfun$3() {
        return "Invalid Angle";
    }

    private /* synthetic */ String $init$$$anonfun$6(long a) {
        return StringOps$.MODULE$.format$extension("%.2f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Angle$package$Angle$.MODULE$.toBigDecimalDegrees(this.truncateDegrees(a))})).replace("360.00", "0.00");
    }

    private /* synthetic */ String $init$$$anonfun$7(long a) {
        return StringOps$.MODULE$.format$extension("%.2f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Angle$package$Angle$.MODULE$.toSignedBigDecimalDegrees(this.truncateDegrees(a))})).replace("-0.00", "0.00").replaceAll("^180.00", "-180.00");
    }

    private static String $init$$$anonfun$8$$anonfun$1() {
        return "Invalid Right Ascension";
    }

    private static String $init$$$anonfun$11$$anonfun$1() {
        return "Invalid Declination";
    }
}

