/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.model;

import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.package$;
import cats.syntax.package;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import java.io.Serializable;
import java.net.URI;
import lucuma.core.model.OrcidId;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class OrcidId$
implements Serializable {
    private static final Regex ValueRegex;
    private static final Regex UriRegex;
    private volatile Object given_Eq_OrcidId$lzy1;
    private volatile Object given_Encoder_OrcidId$lzy1;
    private volatile Object given_Decoder_OrcidId$lzy1;
    public static final OrcidId$ MODULE$;

    private OrcidId$() {
    }

    static {
        MODULE$ = new OrcidId$();
        String ValuePat = "(\\d{4})-(\\d{4})-(\\d{4})-(\\d{3})([\\dX])";
        ValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(ValuePat));
        UriRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("https://orcid.org/" + ValuePat));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OrcidId$.class);
    }

    public OrcidId unapply(OrcidId x$1) {
        return x$1;
    }

    private Either<String, OrcidId> parseWith(String s, Regex re) {
        List list;
        Option option;
        String string2 = s;
        if (string2 != null && !(option = re.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(5) == 0) {
            String string3 = (String)list.apply(0);
            String string4 = (String)list.apply(1);
            String string5 = (String)list.apply(2);
            String string6 = (String)list.apply(3);
            String string7 = (String)list.apply(4);
            String a = string3;
            String b = string4;
            String c = string5;
            String d = string6;
            String x = string7;
            String string8 = this.checkDigit(a + b + c + d);
            String string9 = x;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                return scala.package$.MODULE$.Right().apply((Object)new OrcidId(a, b, c, d, x){});
            }
            return scala.package$.MODULE$.Left().apply((Object)("Invalid ORCID id (bad checksum): " + s));
        }
        return scala.package$.MODULE$.Left().apply((Object)("Invalid ORCID id: " + s));
    }

    public Either<String, OrcidId> fromUri(URI uri) {
        return this.parseWith(uri.toString(), UriRegex);
    }

    public Either<String, OrcidId> fromValue(String s) {
        return this.parseWith(s, ValueRegex);
    }

    public Either<String, OrcidId> parse(String s) {
        return (Either)Try$.MODULE$.apply(() -> OrcidId$.parse$$anonfun$1(s)).filter((Function1 & Serializable)uri -> package.eq$.MODULE$.catsSyntaxEq((Object)uri.getScheme(), (Eq)Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq((Object)"https") && package.eq$.MODULE$.catsSyntaxEq((Object)uri.getHost(), (Eq)Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq((Object)"orcid.org")).fold((Function1 & Serializable)_$1 -> MODULE$.fromValue(s), (Function1 & Serializable)uri -> MODULE$.fromUri((URI)uri));
    }

    public final Eq<OrcidId> given_Eq_OrcidId() {
        Object object = this.given_Eq_OrcidId$lzy1;
        if (object instanceof Eq) {
            return (Eq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Eq)this.given_Eq_OrcidId$lzyINIT1();
    }

    private Object given_Eq_OrcidId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Eq_OrcidId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Eq eq2 = null;
                    try {
                        eq2 = package$.MODULE$.Eq().by((Function1 & Serializable)_$2 -> _$2.value(), (Eq)Eq$.MODULE$.catsKernelInstancesForString());
                        object2 = eq2 == null ? LazyVals.NullValue$.MODULE$ : eq2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Eq_OrcidId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return eq2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Encoder<OrcidId> given_Encoder_OrcidId() {
        Object object = this.given_Encoder_OrcidId$lzy1;
        if (object instanceof Encoder) {
            return (Encoder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Encoder)this.given_Encoder_OrcidId$lzyINIT1();
    }

    private Object given_Encoder_OrcidId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Encoder_OrcidId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Encoder encoder = null;
                    try {
                        encoder = Encoder$.MODULE$.apply(Encoder$.MODULE$.encodeString()).contramap((Function1 & Serializable)_$3 -> _$3.value());
                        object2 = encoder == null ? LazyVals.NullValue$.MODULE$ : encoder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Encoder_OrcidId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return encoder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Decoder<OrcidId> given_Decoder_OrcidId() {
        Object object = this.given_Decoder_OrcidId$lzy1;
        if (object instanceof Decoder) {
            return (Decoder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Decoder)this.given_Decoder_OrcidId$lzyINIT1();
    }

    private Object given_Decoder_OrcidId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.given_Decoder_OrcidId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Decoder decoder = null;
                    try {
                        decoder = Decoder$.MODULE$.apply(Decoder$.MODULE$.decodeString()).emap((Function1 & Serializable)s -> MODULE$.fromValue((String)s));
                        object2 = decoder == null ? LazyVals.NullValue$.MODULE$ : decoder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.given_Decoder_OrcidId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return decoder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OrcidId.OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String checkDigit(String baseDigits) {
        Predef$.MODULE$.require(StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(baseDigits), (Function1 & Serializable)c -> OrcidId$.checkDigit$$anonfun$1(BoxesRunTime.unboxToChar((Object)c))));
        int total = BoxesRunTime.unboxToInt((Object)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(baseDigits), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(acc, c) -> OrcidId$.$anonfun$1(BoxesRunTime.unboxToInt((Object)acc), BoxesRunTime.unboxToChar((Object)c))));
        int remainder = total % 11;
        int result = (12 - remainder) % 11;
        if (result == 10) {
            return "X";
        }
        return BoxesRunTime.boxToInteger((int)result).toString();
    }

    private static final URI parse$$anonfun$1(String s$1) {
        return URI.create(s$1);
    }

    private static final /* synthetic */ boolean checkDigit$$anonfun$1(char c) {
        return c >= '0' && c <= '9';
    }

    private static final /* synthetic */ int $anonfun$1(int acc, char c) {
        int digit = c - 48;
        return (acc + digit) * 2;
    }
}

