/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.model;

import cats.kernel.Order;
import eu.timepit.refined.api.Refined;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import lucuma.core.enums.Instrument;
import lucuma.core.enums.ProgramType;
import lucuma.core.enums.ProgramType$;
import lucuma.core.enums.ScienceSubtype;
import lucuma.core.model.InstrumentProgramReference;
import lucuma.core.model.ProgramReference$;
import lucuma.core.model.ProgramReference$Calibration$;
import lucuma.core.model.ProgramReference$Commissioning$;
import lucuma.core.model.ProgramReference$Engineering$;
import lucuma.core.model.ProgramReference$Example$;
import lucuma.core.model.ProgramReference$Library$;
import lucuma.core.model.ProgramReference$Monitoring$;
import lucuma.core.model.ProgramReference$Science$;
import lucuma.core.model.ProgramReference$System$;
import lucuma.core.model.ProposalReference;
import lucuma.core.model.Semester;
import lucuma.core.model.SemesterlyInstrumentProgramReference;
import lucuma.core.model.SemesterlyProgramReference;
import lucuma.core.optics.Format;
import monocle.PPrism;
import scala.Product;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public interface ProgramReference
extends Product,
Serializable {
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$.class.getDeclaredField("given_Ordering_ProgramReference$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$.class.getDeclaredField("given_Order_ProgramReference$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$.class.getDeclaredField("given_Encoder_ProgramReference$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$.class.getDeclaredField("given_Decoder_ProgramReference$lzy1"));

    public static Format<String, ProgramReference> fromString() {
        return ProgramReference$.MODULE$.fromString();
    }

    public static Decoder<ProgramReference> given_Decoder_ProgramReference() {
        return ProgramReference$.MODULE$.given_Decoder_ProgramReference();
    }

    public static Encoder<ProgramReference> given_Encoder_ProgramReference() {
        return ProgramReference$.MODULE$.given_Encoder_ProgramReference();
    }

    public static Order<ProgramReference> given_Order_ProgramReference() {
        return ProgramReference$.MODULE$.given_Order_ProgramReference();
    }

    public static Ordering<ProgramReference> given_Ordering_ProgramReference() {
        return ProgramReference$.MODULE$.given_Ordering_ProgramReference();
    }

    public static int ordinal(ProgramReference programReference) {
        return ProgramReference$.MODULE$.ordinal(programReference);
    }

    public ProgramType programType();

    public String label();

    public static class Calibration
    implements Product,
    SemesterlyInstrumentProgramReference {
        private final Semester semester;
        private final Instrument instrument;
        private final int index;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Calibration$.class.getDeclaredField("given_Order_Calibration$lzy1"));

        public static Calibration apply(Semester semester, Instrument instrument, int n) {
            return ProgramReference$Calibration$.MODULE$.apply(semester, instrument, n);
        }

        public static Calibration fromProduct(Product product) {
            return ProgramReference$Calibration$.MODULE$.fromProduct(product);
        }

        public static Format<String, Calibration> fromString() {
            return ProgramReference$Calibration$.MODULE$.fromString();
        }

        public static Order<Calibration> given_Order_Calibration() {
            return ProgramReference$Calibration$.MODULE$.given_Order_Calibration();
        }

        public static Calibration unapply(Calibration calibration) {
            return ProgramReference$Calibration$.MODULE$.unapply(calibration);
        }

        public Calibration(Semester semester, Instrument instrument, int index) {
            this.semester = semester;
            this.instrument = instrument;
            this.index = index;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Calibration)) return false;
            Calibration calibration = (Calibration)object;
            Semester semester = this.semester();
            Semester semester2 = calibration.semester();
            if (semester == null) {
                if (semester2 != null) {
                    return false;
                }
            } else if (!((Object)semester).equals(semester2)) return false;
            Instrument instrument = this.instrument();
            Instrument instrument2 = calibration.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            if (this.index() != calibration.index()) return false;
            if (!calibration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Calibration;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Calibration";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "semester";
                }
                case 1: {
                    return "instrument";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Semester semester() {
            return this.semester;
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Calibration;
        }

        public Calibration copy(Semester semester, Instrument instrument, int index) {
            return new Calibration(semester, instrument, index);
        }

        public Semester copy$default$1() {
            return this.semester();
        }

        public Instrument copy$default$2() {
            return this.instrument();
        }

        public int copy$default$3() {
            return this.index();
        }

        public Semester _1() {
            return this.semester();
        }

        public Instrument _2() {
            return this.instrument();
        }

        public int _3() {
            return this.index();
        }
    }

    public static class Commissioning
    implements Product,
    SemesterlyInstrumentProgramReference {
        private final Semester semester;
        private final Instrument instrument;
        private final int index;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Commissioning$.class.getDeclaredField("given_Order_Commissioning$lzy1"));

        public static Commissioning apply(Semester semester, Instrument instrument, int n) {
            return ProgramReference$Commissioning$.MODULE$.apply(semester, instrument, n);
        }

        public static Commissioning fromProduct(Product product) {
            return ProgramReference$Commissioning$.MODULE$.fromProduct(product);
        }

        public static Format<String, Commissioning> fromString() {
            return ProgramReference$Commissioning$.MODULE$.fromString();
        }

        public static Order<Commissioning> given_Order_Commissioning() {
            return ProgramReference$Commissioning$.MODULE$.given_Order_Commissioning();
        }

        public static Commissioning unapply(Commissioning commissioning) {
            return ProgramReference$Commissioning$.MODULE$.unapply(commissioning);
        }

        public Commissioning(Semester semester, Instrument instrument, int index) {
            this.semester = semester;
            this.instrument = instrument;
            this.index = index;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Commissioning)) return false;
            Commissioning commissioning = (Commissioning)object;
            Semester semester = this.semester();
            Semester semester2 = commissioning.semester();
            if (semester == null) {
                if (semester2 != null) {
                    return false;
                }
            } else if (!((Object)semester).equals(semester2)) return false;
            Instrument instrument = this.instrument();
            Instrument instrument2 = commissioning.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            if (this.index() != commissioning.index()) return false;
            if (!commissioning.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Commissioning;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Commissioning";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "semester";
                }
                case 1: {
                    return "instrument";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Semester semester() {
            return this.semester;
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Commissioning;
        }

        public Commissioning copy(Semester semester, Instrument instrument, int index) {
            return new Commissioning(semester, instrument, index);
        }

        public Semester copy$default$1() {
            return this.semester();
        }

        public Instrument copy$default$2() {
            return this.instrument();
        }

        public int copy$default$3() {
            return this.index();
        }

        public Semester _1() {
            return this.semester();
        }

        public Instrument _2() {
            return this.instrument();
        }

        public int _3() {
            return this.index();
        }
    }

    public static class Engineering
    implements Product,
    SemesterlyInstrumentProgramReference {
        private final Semester semester;
        private final Instrument instrument;
        private final int index;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Engineering$.class.getDeclaredField("given_Order_Engineering$lzy1"));

        public static Engineering apply(Semester semester, Instrument instrument, int n) {
            return ProgramReference$Engineering$.MODULE$.apply(semester, instrument, n);
        }

        public static Engineering fromProduct(Product product) {
            return ProgramReference$Engineering$.MODULE$.fromProduct(product);
        }

        public static Format<String, Engineering> fromString() {
            return ProgramReference$Engineering$.MODULE$.fromString();
        }

        public static Order<Engineering> given_Order_Engineering() {
            return ProgramReference$Engineering$.MODULE$.given_Order_Engineering();
        }

        public static Engineering unapply(Engineering engineering) {
            return ProgramReference$Engineering$.MODULE$.unapply(engineering);
        }

        public Engineering(Semester semester, Instrument instrument, int index) {
            this.semester = semester;
            this.instrument = instrument;
            this.index = index;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Engineering)) return false;
            Engineering engineering = (Engineering)object;
            Semester semester = this.semester();
            Semester semester2 = engineering.semester();
            if (semester == null) {
                if (semester2 != null) {
                    return false;
                }
            } else if (!((Object)semester).equals(semester2)) return false;
            Instrument instrument = this.instrument();
            Instrument instrument2 = engineering.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            if (this.index() != engineering.index()) return false;
            if (!engineering.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Engineering;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Engineering";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "semester";
                }
                case 1: {
                    return "instrument";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Semester semester() {
            return this.semester;
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Engineering;
        }

        public Engineering copy(Semester semester, Instrument instrument, int index) {
            return new Engineering(semester, instrument, index);
        }

        public Semester copy$default$1() {
            return this.semester();
        }

        public Instrument copy$default$2() {
            return this.instrument();
        }

        public int copy$default$3() {
            return this.index();
        }

        public Semester _1() {
            return this.semester();
        }

        public Instrument _2() {
            return this.instrument();
        }

        public int _3() {
            return this.index();
        }
    }

    public static class Example
    implements Product,
    InstrumentProgramReference {
        private final Instrument instrument;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Example$.class.getDeclaredField("given_Order_Example$lzy1"));

        public static Example apply(Instrument instrument) {
            return ProgramReference$Example$.MODULE$.apply(instrument);
        }

        public static Example fromProduct(Product product) {
            return ProgramReference$Example$.MODULE$.fromProduct(product);
        }

        public static PPrism<String, String, Example, Example> fromString() {
            return ProgramReference$Example$.MODULE$.fromString();
        }

        public static Order<Example> given_Order_Example() {
            return ProgramReference$Example$.MODULE$.given_Order_Example();
        }

        public static Example unapply(Example example) {
            return ProgramReference$Example$.MODULE$.unapply(example);
        }

        public Example(Instrument instrument) {
            this.instrument = instrument;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Example)) return false;
            Example example = (Example)object;
            Instrument instrument = this.instrument();
            Instrument instrument2 = example.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            if (!example.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Example;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Example";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "instrument";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Example;
        }

        @Override
        public String label() {
            return "G-" + this.programType().abbreviation() + "-" + this.instrument().referenceName();
        }

        public Example copy(Instrument instrument) {
            return new Example(instrument);
        }

        public Instrument copy$default$1() {
            return this.instrument();
        }

        public Instrument _1() {
            return this.instrument();
        }
    }

    public static class Library
    implements Product,
    InstrumentProgramReference {
        private final Instrument instrument;
        private final String description;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Library$.class.getDeclaredField("given_Order_Library$lzy1"));

        public static Library apply(Instrument instrument, String string2) {
            return ProgramReference$Library$.MODULE$.apply(instrument, string2);
        }

        public static Library fromProduct(Product product) {
            return ProgramReference$Library$.MODULE$.fromProduct(product);
        }

        public static PPrism<String, String, Library, Library> fromString() {
            return ProgramReference$Library$.MODULE$.fromString();
        }

        public static Order<Library> given_Order_Library() {
            return ProgramReference$Library$.MODULE$.given_Order_Library();
        }

        public static Library unapply(Library library) {
            return ProgramReference$Library$.MODULE$.unapply(library);
        }

        public Library(Instrument instrument, String description) {
            this.instrument = instrument;
            this.description = description;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Library)) return false;
            Library library = (Library)object;
            Instrument instrument = this.instrument();
            Instrument instrument2 = library.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            String string2 = this.description();
            String string3 = library.description();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!library.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Library;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Library";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "instrument";
            }
            if (1 == n2) {
                return "description";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        public String description() {
            return this.description;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Library;
        }

        @Override
        public String label() {
            return "G-" + this.programType().abbreviation() + "-" + this.instrument().referenceName() + "-" + Refined.package.Refined$.MODULE$.value((Object)this.description());
        }

        public Library copy(Instrument instrument, String description) {
            return new Library(instrument, description);
        }

        public Instrument copy$default$1() {
            return this.instrument();
        }

        public String copy$default$2() {
            return this.description();
        }

        public Instrument _1() {
            return this.instrument();
        }

        public String _2() {
            return this.description();
        }
    }

    public static class Monitoring
    implements Product,
    SemesterlyInstrumentProgramReference {
        private final Semester semester;
        private final Instrument instrument;
        private final int index;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Monitoring$.class.getDeclaredField("given_Order_Monitoring$lzy1"));

        public static Monitoring apply(Semester semester, Instrument instrument, int n) {
            return ProgramReference$Monitoring$.MODULE$.apply(semester, instrument, n);
        }

        public static Monitoring fromProduct(Product product) {
            return ProgramReference$Monitoring$.MODULE$.fromProduct(product);
        }

        public static Format<String, Monitoring> fromString() {
            return ProgramReference$Monitoring$.MODULE$.fromString();
        }

        public static Order<Monitoring> given_Order_Monitoring() {
            return ProgramReference$Monitoring$.MODULE$.given_Order_Monitoring();
        }

        public static Monitoring unapply(Monitoring monitoring) {
            return ProgramReference$Monitoring$.MODULE$.unapply(monitoring);
        }

        public Monitoring(Semester semester, Instrument instrument, int index) {
            this.semester = semester;
            this.instrument = instrument;
            this.index = index;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Monitoring)) return false;
            Monitoring monitoring = (Monitoring)object;
            Semester semester = this.semester();
            Semester semester2 = monitoring.semester();
            if (semester == null) {
                if (semester2 != null) {
                    return false;
                }
            } else if (!((Object)semester).equals(semester2)) return false;
            Instrument instrument = this.instrument();
            Instrument instrument2 = monitoring.instrument();
            if (instrument == null) {
                if (instrument2 != null) {
                    return false;
                }
            } else if (!instrument.equals(instrument2)) return false;
            if (this.index() != monitoring.index()) return false;
            if (!monitoring.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Monitoring;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Monitoring";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "semester";
                }
                case 1: {
                    return "instrument";
                }
                case 2: {
                    return "index";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Semester semester() {
            return this.semester;
        }

        @Override
        public Instrument instrument() {
            return this.instrument;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Monitoring;
        }

        public Monitoring copy(Semester semester, Instrument instrument, int index) {
            return new Monitoring(semester, instrument, index);
        }

        public Semester copy$default$1() {
            return this.semester();
        }

        public Instrument copy$default$2() {
            return this.instrument();
        }

        public int copy$default$3() {
            return this.index();
        }

        public Semester _1() {
            return this.semester();
        }

        public Instrument _2() {
            return this.instrument();
        }

        public int _3() {
            return this.index();
        }
    }

    public static class Science
    implements Product,
    SemesterlyProgramReference {
        private final ProposalReference proposal;
        private final ScienceSubtype scienceSubtype;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$Science$.class.getDeclaredField("given_Order_Science$lzy1"));

        public static Science apply(ProposalReference proposalReference, ScienceSubtype scienceSubtype) {
            return ProgramReference$Science$.MODULE$.apply(proposalReference, scienceSubtype);
        }

        public static Science fromProduct(Product product) {
            return ProgramReference$Science$.MODULE$.fromProduct(product);
        }

        public static Format<String, Science> fromString() {
            return ProgramReference$Science$.MODULE$.fromString();
        }

        public static Order<Science> given_Order_Science() {
            return ProgramReference$Science$.MODULE$.given_Order_Science();
        }

        public static Science unapply(Science science) {
            return ProgramReference$Science$.MODULE$.unapply(science);
        }

        public Science(ProposalReference proposal, ScienceSubtype scienceSubtype) {
            this.proposal = proposal;
            this.scienceSubtype = scienceSubtype;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Science)) return false;
            Science science = (Science)object;
            ProposalReference proposalReference = this.proposal();
            ProposalReference proposalReference2 = science.proposal();
            if (proposalReference == null) {
                if (proposalReference2 != null) {
                    return false;
                }
            } else if (!((Object)proposalReference).equals(proposalReference2)) return false;
            ScienceSubtype scienceSubtype = this.scienceSubtype();
            ScienceSubtype scienceSubtype2 = science.scienceSubtype();
            if (scienceSubtype == null) {
                if (scienceSubtype2 != null) {
                    return false;
                }
            } else if (!scienceSubtype.equals(scienceSubtype2)) return false;
            if (!science.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Science;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Science";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "proposal";
            }
            if (1 == n2) {
                return "scienceSubtype";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ProposalReference proposal() {
            return this.proposal;
        }

        public ScienceSubtype scienceSubtype() {
            return this.scienceSubtype;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.Science;
        }

        @Override
        public Semester semester() {
            return this.proposal().semester();
        }

        @Override
        public String label() {
            return this.proposal().label() + "-" + this.scienceSubtype().letter();
        }

        public Science copy(ProposalReference proposal, ScienceSubtype scienceSubtype) {
            return new Science(proposal, scienceSubtype);
        }

        public ProposalReference copy$default$1() {
            return this.proposal();
        }

        public ScienceSubtype copy$default$2() {
            return this.scienceSubtype();
        }

        public ProposalReference _1() {
            return this.proposal();
        }

        public ScienceSubtype _2() {
            return this.scienceSubtype();
        }
    }

    public static class System
    implements Product,
    ProgramReference {
        private final String description;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ProgramReference$System$.class.getDeclaredField("given_Order_System$lzy1"));

        public static System apply(String string2) {
            return ProgramReference$System$.MODULE$.apply(string2);
        }

        public static System fromProduct(Product product) {
            return ProgramReference$System$.MODULE$.fromProduct(product);
        }

        public static PPrism<String, String, System, System> fromString() {
            return ProgramReference$System$.MODULE$.fromString();
        }

        public static Order<System> given_Order_System() {
            return ProgramReference$System$.MODULE$.given_Order_System();
        }

        public static System unapply(System system) {
            return ProgramReference$System$.MODULE$.unapply(system);
        }

        public System(String description) {
            this.description = description;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof System)) return false;
            System system = (System)object;
            String string2 = this.description();
            String string3 = system.description();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!system.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof System;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "System";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "description";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String description() {
            return this.description;
        }

        @Override
        public ProgramType programType() {
            return ProgramType$.System;
        }

        @Override
        public String label() {
            return this.programType().abbreviation() + "-" + Refined.package.Refined$.MODULE$.value((Object)this.description());
        }

        public System copy(String description) {
            return new System(description);
        }

        public String copy$default$1() {
            return this.description();
        }

        public String _1() {
            return this.description();
        }
    }
}

