/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.model;

import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import lucuma.core.enums.TimingWindowInclusion;
import lucuma.core.math.BoundedInterval$package$BoundedInterval$;
import lucuma.core.model.TimingWindow$;
import lucuma.core.model.TimingWindowEnd;
import lucuma.core.model.TimingWindowEnd$;
import lucuma.core.model.TimingWindowEnd$After$;
import lucuma.core.model.TimingWindowEnd$At$;
import lucuma.core.model.TimingWindowRepeat;
import lucuma.core.model.TimingWindowRepeat$;
import lucuma.core.util.TimeSpan$package$TimeSpan$;
import lucuma.core.util.Timestamp$package$Timestamp$;
import lucuma.core.util.Timestamp$package$Timestamp$orderTimestamp$;
import org.typelevel.cats.time.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import spire.math.Interval$;
import spire.math.extras.interval.IntervalSeq;
import spire.math.extras.interval.IntervalSeq$;

public final class TimingWindow
implements Product,
Serializable {
    private final TimingWindowInclusion inclusion;
    private final Instant start;
    private final Option<TimingWindowEnd> end;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TimingWindow$.class.getDeclaredField("given_Order_TimingWindow$lzy1"));

    public static TimingWindow apply(TimingWindowInclusion timingWindowInclusion, Instant instant2, Option<TimingWindowEnd> option) {
        return TimingWindow$.MODULE$.apply(timingWindowInclusion, instant2, option);
    }

    public static TimingWindow fromProduct(Product product) {
        return TimingWindow$.MODULE$.fromProduct(product);
    }

    public static Order<TimingWindow> given_Order_TimingWindow() {
        return TimingWindow$.MODULE$.given_Order_TimingWindow();
    }

    public static TimingWindow unapply(TimingWindow timingWindow) {
        return TimingWindow$.MODULE$.unapply(timingWindow);
    }

    public TimingWindow(TimingWindowInclusion inclusion, Instant start, Option<TimingWindowEnd> end) {
        this.inclusion = inclusion;
        this.start = start;
        this.end = end;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TimingWindow)) return false;
        TimingWindow timingWindow = (TimingWindow)object;
        TimingWindowInclusion timingWindowInclusion = this.inclusion();
        TimingWindowInclusion timingWindowInclusion2 = timingWindow.inclusion();
        if (timingWindowInclusion == null) {
            if (timingWindowInclusion2 != null) {
                return false;
            }
        } else if (!timingWindowInclusion.equals(timingWindowInclusion2)) return false;
        Instant instant2 = this.start();
        Instant instant3 = timingWindow.start();
        if (instant2 == null) {
            if (instant3 != null) {
                return false;
            }
        } else if (!((Object)instant2).equals(instant3)) return false;
        Option<TimingWindowEnd> option = this.end();
        Option<TimingWindowEnd> option2 = timingWindow.end();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TimingWindow;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TimingWindow";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "inclusion";
            }
            case 1: {
                return "start";
            }
            case 2: {
                return "end";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TimingWindowInclusion inclusion() {
        return this.inclusion;
    }

    public Instant start() {
        return this.start;
    }

    public Option<TimingWindowEnd> end() {
        return this.end;
    }

    public Option<Object> duration() {
        return this.end().flatMap((Function1 & Serializable)x$1 -> {
            TimingWindowEnd timingWindowEnd = x$1;
            if (timingWindowEnd instanceof TimingWindowEnd.At) {
                Instant instant2;
                TimingWindowEnd.At at = TimingWindowEnd$At$.MODULE$.unapply((TimingWindowEnd.At)timingWindowEnd);
                Instant ts = instant2 = at._1();
                return TimeSpan$package$TimeSpan$.MODULE$.between(this.start(), ts);
            }
            if (timingWindowEnd instanceof TimingWindowEnd.After) {
                TimingWindowEnd.After after = TimingWindowEnd$After$.MODULE$.unapply((TimingWindowEnd.After)timingWindowEnd);
                long l = after._1();
                Option<TimingWindowRepeat> option = after._2();
                long d = l;
                Long l2 = (Long)package.all$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToLong((long)d));
                return OptionIdOps$.MODULE$.some$extension((Object)l2);
            }
            throw new MatchError((Object)timingWindowEnd);
        });
    }

    public boolean isValid() {
        return this.end().flatMap((Function1 & Serializable)s -> TimingWindowEnd$.MODULE$.at().getOption(s)).forall((Function1 & Serializable)_$6 -> package.all$.MODULE$.catsSyntaxPartialOrder((Object)_$6.instant(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$greater((Object)this.start()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IntervalSeq<Instant> toIntervalSeq(Product within) {
        IntervalSeq intervalSeq;
        Instant windowStart = Timestamp$package$Timestamp$.MODULE$.toInstant(this.start());
        Option<TimingWindowEnd> option = this.end();
        if (None$.MODULE$.equals(option)) {
            intervalSeq = IntervalSeq$.MODULE$.atOrAbove((Object)windowStart, (Order)package$.MODULE$.instantInstances());
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            TimingWindowEnd timingWindowEnd = (TimingWindowEnd)((Some)option).value();
            if (timingWindowEnd instanceof TimingWindowEnd.At) {
                Instant instant2;
                TimingWindowEnd.At at = TimingWindowEnd$At$.MODULE$.unapply((TimingWindowEnd.At)timingWindowEnd);
                Instant instant3 = instant2 = at._1();
                intervalSeq = IntervalSeq$.MODULE$.apply(Interval$.MODULE$.apply((Object)windowStart, (Object)Timestamp$package$Timestamp$.MODULE$.toInstant(instant3), (Order)package$.MODULE$.instantInstances()), (Order)package$.MODULE$.instantInstances());
            } else {
                if (!(timingWindowEnd instanceof TimingWindowEnd.After)) throw new MatchError(option);
                TimingWindowEnd.After after = TimingWindowEnd$After$.MODULE$.unapply((TimingWindowEnd.After)timingWindowEnd);
                long l = after._1();
                Option<TimingWindowRepeat> option2 = after._2();
                long duration2 = l;
                if (None$.MODULE$.equals(option2)) {
                    intervalSeq = IntervalSeq$.MODULE$.apply(Interval$.MODULE$.apply((Object)windowStart, (Object)windowStart.plus(TimeSpan$package$TimeSpan$.MODULE$.toDuration(duration2)), (Order)package$.MODULE$.instantInstances()), (Order)package$.MODULE$.instantInstances());
                } else {
                    TimingWindowRepeat timingWindowRepeat;
                    long duration3 = l;
                    if (!(option2 instanceof Some) || (timingWindowRepeat = (TimingWindowRepeat)((Some)option2).value()) == null) throw new MatchError(option);
                    TimingWindowRepeat timingWindowRepeat2 = TimingWindowRepeat$.MODULE$.unapply(timingWindowRepeat);
                    long l2 = timingWindowRepeat2._1();
                    Option<Object> option3 = timingWindowRepeat2._2();
                    long period = l2;
                    if (option3 instanceof Some) {
                        int times = BoxesRunTime.unboxToInt((Object)((Some)option3).value());
                        Instant nearestStart = TimingWindow.windowStartForPeriod$1(windowStart, within, period);
                        intervalSeq = TimingWindow.intervalsForStarts$1((List)scala.package$.MODULE$.List().unfold((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)nearestStart), (Function1 & Serializable)_$9 -> {
                            Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxOptionId(_$9);
                            return OptionIdOps$.MODULE$.some$extension((Object)tuple2).filter((Function1 & Serializable)_$10 -> BoxesRunTime.unboxToInt((Object)_$10._1()) <= BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)times)))).filter((Function1 & Serializable)_$11 -> package.all$.MODULE$.catsSyntaxPartialOrder(_$11._2(), (PartialOrder)package$.MODULE$.instantInstances()).$less$eq(BoundedInterval$package$BoundedInterval$.MODULE$.upper(within))).map((Function1 & Serializable)x$1 -> {
                                int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                                Instant instant2 = (Instant)x$1._2();
                                return Tuple2$.MODULE$.apply((Object)instant2, (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(n + 1)), (Object)instant2.plus(TimeSpan$package$TimeSpan$.MODULE$.toDuration(period))));
                            });
                        }), TimeSpan$package$TimeSpan$.MODULE$.toDuration(duration3));
                    } else {
                        long duration4 = l;
                        long period2 = l2;
                        if (!None$.MODULE$.equals(option3)) throw new MatchError(option);
                        Instant nearestStart = TimingWindow.windowStartForPeriod$1(windowStart, within, period2);
                        intervalSeq = TimingWindow.intervalsForStarts$1((List)scala.package$.MODULE$.List().unfold((Object)nearestStart, (Function1 & Serializable)_$12 -> {
                            Instant instant2 = (Instant)package.all$.MODULE$.catsSyntaxOptionId(_$12);
                            return OptionIdOps$.MODULE$.some$extension((Object)instant2).filter((Function1 & Serializable)i -> package.all$.MODULE$.catsSyntaxPartialOrder(i, (PartialOrder)package$.MODULE$.instantInstances()).$less$eq(BoundedInterval$package$BoundedInterval$.MODULE$.upper(within))).map((Function1 & Serializable)start -> Tuple2$.MODULE$.apply(start, (Object)start.plus(TimeSpan$package$TimeSpan$.MODULE$.toDuration(period2))));
                        }), TimeSpan$package$TimeSpan$.MODULE$.toDuration(duration4));
                    }
                }
            }
        }
        IntervalSeq intervals = intervalSeq;
        return intervals.$amp(BoundedInterval$package$BoundedInterval$.MODULE$.apply(IntervalSeq$.MODULE$, within, (Order)package$.MODULE$.instantInstances()));
    }

    public TimingWindow copy(TimingWindowInclusion inclusion, Instant start, Option<TimingWindowEnd> end) {
        return new TimingWindow(inclusion, start, end);
    }

    public TimingWindowInclusion copy$default$1() {
        return this.inclusion();
    }

    public Instant copy$default$2() {
        return this.start();
    }

    public Option<TimingWindowEnd> copy$default$3() {
        return this.end();
    }

    public TimingWindowInclusion _1() {
        return this.inclusion();
    }

    public Instant _2() {
        return this.start();
    }

    public Option<TimingWindowEnd> _3() {
        return this.end();
    }

    private static final IntervalSeq intervalsForStarts$1(List starts, Duration duration2) {
        return (IntervalSeq)starts.map((Function1 & Serializable)start -> IntervalSeq$.MODULE$.apply(Interval$.MODULE$.apply(start, (Object)start.plus(duration2), (Order)package$.MODULE$.instantInstances()), (Order)package$.MODULE$.instantInstances())).foldLeft((Object)IntervalSeq$.MODULE$.empty((Order)package$.MODULE$.instantInstances()), (Function2 & Serializable)(_$7, _$8) -> _$7.$bar(_$8));
    }

    private static final Instant windowStartForPeriod$1(Instant windowStart$1, Product within$1, long period) {
        return (Instant)package.all$.MODULE$.catsSyntaxOrder((Object)windowStart$1.plusMillis(TimeSpan$package$TimeSpan$.MODULE$.toDuration(period).multipliedBy(Duration.between(windowStart$1, (Temporal)BoundedInterval$package$BoundedInterval$.MODULE$.lower(within$1)).toMillis() / TimeSpan$package$TimeSpan$.MODULE$.toDuration(period).toMillis()).toMillis()), (Order)package$.MODULE$.instantInstances()).max((Object)windowStart$1);
    }
}

