/*
 * Decompiled with CFR 0.152.
 */
package lucuma.core.util;

import cats.kernel.Comparison;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import lucuma.core.util.TimeSpan$package$;
import lucuma.core.util.TimeSpan$package$TimeSpan$;
import lucuma.core.util.Timestamp$package$Timestamp$;
import lucuma.core.util.Timestamp$package$Timestamp$orderTimestamp$;
import lucuma.core.util.TimestampInterval$;
import lucuma.core.util.TimestampInterval$Overlap$;
import org.typelevel.cats.time.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;

public class TimestampInterval {
    private final Instant start;
    private final Instant end;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TimestampInterval$.class.getDeclaredField("given_Order_TimestampInterval$lzy1"));

    public static TimestampInterval All() {
        return TimestampInterval$.MODULE$.All();
    }

    public static TimestampInterval between(Instant instant2, Instant instant3) {
        return TimestampInterval$.MODULE$.between(instant2, instant3);
    }

    public static TimestampInterval empty(Instant instant2) {
        return TimestampInterval$.MODULE$.empty(instant2);
    }

    public static TimestampInterval from(Instant instant2) {
        return TimestampInterval$.MODULE$.from(instant2);
    }

    public static Order<TimestampInterval> given_Order_TimestampInterval() {
        return TimestampInterval$.MODULE$.given_Order_TimestampInterval();
    }

    public static TimestampInterval until(Instant instant2) {
        return TimestampInterval$.MODULE$.until(instant2);
    }

    public TimestampInterval(Instant start, Instant end) {
        this.start = start;
        this.end = end;
        if (!package.order$.MODULE$.catsSyntaxPartialOrder((Object)start, (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less$eq((Object)end)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("start time (" + start + ") must be <= end time (" + end + ")"));
        }
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Option<Object> timeSpan() {
        return TimeSpan$package$TimeSpan$.MODULE$.between(this.start(), this.end());
    }

    public long boundedTimeSpan() {
        return BoxesRunTime.unboxToLong((Object)this.timeSpan().getOrElse(TimestampInterval::boundedTimeSpan$$anonfun$1));
    }

    public boolean contains(Instant time2) {
        return package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.start(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less$eq((Object)time2) && package.order$.MODULE$.catsSyntaxPartialOrder((Object)time2, (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less((Object)this.end());
    }

    public boolean containsInstant(Instant time2) {
        return package.order$.MODULE$.catsSyntaxPartialOrder((Object)Timestamp$package$Timestamp$.MODULE$.toInstant(this.start()), (PartialOrder)package$.MODULE$.instantInstances()).$less$eq((Object)time2) && package.order$.MODULE$.catsSyntaxPartialOrder((Object)time2, (PartialOrder)package$.MODULE$.instantInstances()).$less((Object)Timestamp$package$Timestamp$.MODULE$.toInstant(this.end()));
    }

    public boolean isEmpty() {
        return package.order$.MODULE$.catsSyntaxEq((Object)this.start(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)this.end());
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public TimestampInterval span(TimestampInterval other) {
        return TimestampInterval$.MODULE$.between((Instant)package.order$.MODULE$.catsSyntaxOrder((Object)this.start(), (Order)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).min((Object)other.start()), (Instant)package.order$.MODULE$.catsSyntaxOrder((Object)this.end(), (Order)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).max((Object)other.end()));
    }

    public List<TimestampInterval> plus(TimestampInterval other) {
        Overlap overlap = this.overlap(other);
        Overlap overlap2 = TimestampInterval$Overlap$.None;
        Overlap overlap3 = overlap;
        if (!(overlap2 != null ? !overlap2.equals(overlap3) : overlap3 != null) && !this.abuts(other)) {
            return (List)((StrictOptimizedSeqOps)new .colon.colon((Object)this, (List)new .colon.colon((Object)other, (List)Nil$.MODULE$))).sorted(cats.package$.MODULE$.Order().catsKernelOrderingForOrder(TimestampInterval$.MODULE$.given_Order_TimestampInterval()));
        }
        return (List)new .colon.colon((Object)this.span(other), (List)Nil$.MODULE$);
    }

    public List<TimestampInterval> minus(TimestampInterval other) {
        Overlap overlap;
        block12: {
            block9: {
                Overlap overlap2;
                Overlap overlap3;
                block11: {
                    block10: {
                        Overlap overlap4;
                        Overlap overlap5;
                        block8: {
                            overlap = this.overlap(other);
                            Overlap overlap6 = TimestampInterval$Overlap$.LowerPartial;
                            Overlap overlap7 = overlap;
                            if (!(overlap6 != null ? !overlap6.equals(overlap7) : overlap7 != null)) {
                                return (List)new .colon.colon((Object)TimestampInterval$.MODULE$.between(this.start(), other.start()), (List)Nil$.MODULE$);
                            }
                            Overlap overlap8 = TimestampInterval$Overlap$.UpperPartial;
                            Overlap overlap9 = overlap;
                            if (!(overlap8 != null ? !overlap8.equals(overlap9) : overlap9 != null)) {
                                return (List)new .colon.colon((Object)TimestampInterval$.MODULE$.between(other.end(), this.end()), (List)Nil$.MODULE$);
                            }
                            Overlap overlap10 = TimestampInterval$Overlap$.ProperSuperset;
                            Overlap overlap11 = overlap;
                            if (!(overlap10 != null ? !overlap10.equals(overlap11) : overlap11 != null)) {
                                if (other.isEmpty()) {
                                    return (List)new .colon.colon((Object)this, (List)Nil$.MODULE$);
                                }
                                return ((List)new .colon.colon((Object)TimestampInterval$.MODULE$.between(this.start(), other.start()), (List)new .colon.colon((Object)TimestampInterval$.MODULE$.between(other.end(), this.end()), (List)Nil$.MODULE$))).filter((Function1 & Serializable)_$1 -> !_$1.isEmpty());
                            }
                            Overlap overlap12 = TimestampInterval$Overlap$.None;
                            Overlap overlap13 = overlap;
                            if (!(overlap12 != null ? !overlap12.equals(overlap13) : overlap13 != null)) {
                                return (List)new .colon.colon((Object)this, (List)Nil$.MODULE$);
                            }
                            overlap5 = TimestampInterval$Overlap$.ProperSubset;
                            overlap4 = overlap;
                            if (overlap5 != null) break block8;
                            if (overlap4 == null) break block9;
                            break block10;
                        }
                        if (overlap5.equals(overlap4)) break block9;
                    }
                    overlap3 = TimestampInterval$Overlap$.Equal;
                    overlap2 = overlap;
                    if (overlap3 != null) break block11;
                    if (overlap2 == null) break block9;
                    break block12;
                }
                if (!overlap3.equals(overlap2)) break block12;
            }
            return scala.package$.MODULE$.Nil();
        }
        throw new MatchError((Object)overlap);
    }

    public Overlap overlap(TimestampInterval other) {
        Comparison comparison = package.order$.MODULE$.catsSyntaxOrder((Object)this.start(), (Order)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).comparison((Object)other.start());
        cats.package$.MODULE$.Comparison();
        if (Comparison.LessThan$.MODULE$.equals(comparison)) {
            if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.end(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less$eq((Object)other.start())) {
                return TimestampInterval$Overlap$.None;
            }
            if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.end(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less((Object)other.end())) {
                return TimestampInterval$Overlap$.LowerPartial;
            }
            return TimestampInterval$Overlap$.ProperSuperset;
        }
        cats.package$.MODULE$.Comparison();
        if (Comparison.EqualTo$.MODULE$.equals(comparison)) {
            if (package.order$.MODULE$.catsSyntaxEq((Object)this.end(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)other.end())) {
                return TimestampInterval$Overlap$.Equal;
            }
            if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.end(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$less((Object)other.end())) {
                return TimestampInterval$Overlap$.ProperSubset;
            }
            return TimestampInterval$Overlap$.ProperSuperset;
        }
        cats.package$.MODULE$.Comparison();
        if (Comparison.GreaterThan$.MODULE$.equals(comparison)) {
            if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.start(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$greater$eq((Object)other.end())) {
                return TimestampInterval$Overlap$.None;
            }
            if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this.end(), (PartialOrder)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$greater((Object)other.end())) {
                return TimestampInterval$Overlap$.UpperPartial;
            }
            return TimestampInterval$Overlap$.ProperSubset;
        }
        throw new MatchError((Object)comparison);
    }

    public boolean abuts(TimestampInterval other) {
        return package.order$.MODULE$.catsSyntaxEq((Object)other.start(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)this.end()) || package.order$.MODULE$.catsSyntaxEq((Object)other.end(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)this.start());
    }

    public boolean intersects(TimestampInterval other) {
        return TimestampInterval$Overlap$.MODULE$.intersects(this.overlap(other));
    }

    public Option<TimestampInterval> intersection(TimestampInterval other) {
        Overlap overlap = this.overlap(other);
        Overlap overlap2 = TimestampInterval$Overlap$.None;
        Overlap overlap3 = overlap;
        if (!(overlap2 != null ? !overlap2.equals(overlap3) : overlap3 != null)) {
            return None$.MODULE$;
        }
        Overlap overlap4 = TimestampInterval$Overlap$.LowerPartial;
        Overlap overlap5 = overlap;
        if (!(overlap4 != null ? !overlap4.equals(overlap5) : overlap5 != null)) {
            TimestampInterval timestampInterval = (TimestampInterval)package.option$.MODULE$.catsSyntaxOptionId((Object)TimestampInterval$.MODULE$.between(other.start(), this.end()));
            return OptionIdOps$.MODULE$.some$extension((Object)timestampInterval);
        }
        Overlap overlap6 = TimestampInterval$Overlap$.UpperPartial;
        Overlap overlap7 = overlap;
        if (!(overlap6 != null ? !overlap6.equals(overlap7) : overlap7 != null)) {
            TimestampInterval timestampInterval = (TimestampInterval)package.option$.MODULE$.catsSyntaxOptionId((Object)TimestampInterval$.MODULE$.between(this.start(), other.end()));
            return OptionIdOps$.MODULE$.some$extension((Object)timestampInterval);
        }
        Overlap overlap8 = TimestampInterval$Overlap$.Equal;
        Overlap overlap9 = overlap;
        if (!(overlap8 != null ? !overlap8.equals(overlap9) : overlap9 != null)) {
            TimestampInterval timestampInterval = (TimestampInterval)package.option$.MODULE$.catsSyntaxOptionId((Object)this);
            return OptionIdOps$.MODULE$.some$extension((Object)timestampInterval);
        }
        Overlap overlap10 = TimestampInterval$Overlap$.ProperSubset;
        Overlap overlap11 = overlap;
        if (!(overlap10 != null ? !overlap10.equals(overlap11) : overlap11 != null)) {
            TimestampInterval timestampInterval = (TimestampInterval)package.option$.MODULE$.catsSyntaxOptionId((Object)this);
            return OptionIdOps$.MODULE$.some$extension((Object)timestampInterval);
        }
        Overlap overlap12 = TimestampInterval$Overlap$.ProperSuperset;
        Overlap overlap13 = overlap;
        if (!(overlap12 != null ? !overlap12.equals(overlap13) : overlap13 != null)) {
            TimestampInterval timestampInterval = (TimestampInterval)package.option$.MODULE$.catsSyntaxOptionId((Object)other);
            return OptionIdOps$.MODULE$.some$extension((Object)timestampInterval);
        }
        throw new MatchError((Object)overlap);
    }

    public Option<Object> timeBetween(TimestampInterval other) {
        if (this.intersects(other)) {
            TimeSpan$package$ timeSpan$package$ = TimeSpan$package$.MODULE$;
            TimeSpan$package$TimeSpan$ TimeSpan$_this = TimeSpan$package$TimeSpan$.MODULE$;
            TimeSpan$package$ TimeSpan$package$_this = timeSpan$package$;
            Long l = (Long)package.option$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToLong((long)TimeSpan$_this.Min()));
            return OptionIdOps$.MODULE$.some$extension((Object)l);
        }
        if (package.order$.MODULE$.catsSyntaxPartialOrder((Object)this, TimestampInterval$.MODULE$.given_Order_TimestampInterval()).$less((Object)other)) {
            return TimeSpan$package$TimeSpan$.MODULE$.between(this.end(), other.start());
        }
        return TimeSpan$package$TimeSpan$.MODULE$.between(other.end(), this.start());
    }

    public long boundedTimeBetween(TimestampInterval other) {
        return BoxesRunTime.unboxToLong((Object)this.timeBetween(other).getOrElse(TimestampInterval::boundedTimeBetween$$anonfun$1));
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof TimestampInterval) {
            TimestampInterval t = (TimestampInterval)object;
            return package.order$.MODULE$.catsSyntaxEq((Object)this.start(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)t.start()) && package.order$.MODULE$.catsSyntaxEq((Object)this.end(), (Eq)Timestamp$package$Timestamp$orderTimestamp$.MODULE$).$eq$eq$eq((Object)t.end());
        }
        return false;
    }

    public int hashCode() {
        return this.start().hashCode() * 31 + this.end().hashCode();
    }

    public String toString() {
        return "[" + Timestamp$package$Timestamp$.MODULE$.format(this.start()) + ", " + Timestamp$package$Timestamp$.MODULE$.format(this.end()) + ")";
    }

    private static final long boundedTimeSpan$$anonfun$1() {
        return TimeSpan$package$TimeSpan$.MODULE$.Max();
    }

    private static final long boundedTimeBetween$$anonfun$1() {
        return TimeSpan$package$TimeSpan$.MODULE$.Max();
    }

    public static abstract class Overlap
    implements Product,
    Enum {
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TimestampInterval$Overlap$.class.getDeclaredField("given_Eq_Overlap$lzy1"));

        public static Overlap fromOrdinal(int n) {
            return TimestampInterval$Overlap$.MODULE$.fromOrdinal(n);
        }

        public static Eq<Overlap> given_Eq_Overlap() {
            return TimestampInterval$Overlap$.MODULE$.given_Eq_Overlap();
        }

        public static boolean intersects(Overlap overlap) {
            return TimestampInterval$Overlap$.MODULE$.intersects(overlap);
        }

        public static boolean isPartial(Overlap overlap) {
            return TimestampInterval$Overlap$.MODULE$.isPartial(overlap);
        }

        public static boolean isSubset(Overlap overlap) {
            return TimestampInterval$Overlap$.MODULE$.isSubset(overlap);
        }

        public static boolean isSuperset(Overlap overlap) {
            return TimestampInterval$Overlap$.MODULE$.isSuperset(overlap);
        }

        public static boolean isTotal(Overlap overlap) {
            return TimestampInterval$Overlap$.MODULE$.isTotal(overlap);
        }

        public static Overlap valueOf(String string2) {
            return TimestampInterval$Overlap$.MODULE$.valueOf(string2);
        }

        public static Overlap[] values() {
            return TimestampInterval$Overlap$.MODULE$.values();
        }
    }
}

