/*
 * Decompiled with CFR 0.152.
 */
package lucuma.graphql.routes;

import cats.effect.kernel.GenTemporal;
import cats.effect.std.Queue$;
import cats.effect.std.QueueSource;
import cats.implicits$;
import clue.model.StreamingMessage;
import fs2.Stream;
import fs2.Stream$;
import io.circe.syntax.package;
import java.io.Serializable;
import lucuma.graphql.routes.Connection$;
import lucuma.graphql.routes.package$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.headers.Authorization;
import org.http4s.server.websocket.WebSocketBuilder2;
import org.http4s.websocket.WebSocketFrame;
import org.typelevel.ci.CIString$;
import org.typelevel.log4cats.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;
import scodec.bits.ByteVector;

public class WsRouteHandler<F> {
    private final Function1<Option<Authorization>, F> service;
    private final Logger<F> evidence$2;
    private final GenTemporal<F, Throwable> evidence$3;
    private final FiniteDuration KeepAliveDuration;

    public WsRouteHandler(Function1<Option<Authorization>, Object> service, Logger<F> evidence$2, GenTemporal<F, Throwable> evidence$3) {
        this.service = service;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.KeepAliveDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds();
    }

    public FiniteDuration KeepAliveDuration() {
        return this.KeepAliveDuration;
    }

    public F webSocketConnection(WebSocketBuilder2<F> wsb) {
        Stream keepAliveStream = Stream$.MODULE$.constant((Object)StreamingMessage.FromServer$.ConnectionKeepAlive$.MODULE$, Stream$.MODULE$.constant$default$2()).metered(this.KeepAliveDuration(), this.evidence$3);
        return (F)implicits$.MODULE$.toFlatMapOps(Queue$.MODULE$.unbounded(this.evidence$3), this.evidence$3).flatMap((Function1 & Serializable)replyQueue -> implicits$.MODULE$.toFlatMapOps(Connection$.MODULE$.apply((Function1<Option<Authorization>, Object>)this.service, replyQueue, this.evidence$2, this.evidence$3), this.evidence$3).flatMap((Function1 & Serializable)connection -> implicits$.MODULE$.toFunctorOps(wsb.withHeaders(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply("Sec-WebSocket-Protocol"), "graphql-ws"))}))).build(Stream$.MODULE$.fromQueueNoneTerminated((QueueSource)replyQueue, Stream$.MODULE$.fromQueueNoneTerminated$default$2(), this.evidence$3).mergeHaltL(keepAliveStream, this.evidence$3).evalTap((Function1 & Serializable)msg -> this.logFromServer$1((StreamingMessage.FromServer)msg), this.evidence$3).map((Function1 & Serializable)m -> {
            StreamingMessage.FromServer fromServer = (StreamingMessage.FromServer)io.circe.syntax.package$.MODULE$.EncoderOps(m);
            return WebSocketFrame.Text$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)fromServer, clue.model.json.package$.MODULE$.EncoderFromServer()).spaces2(), WebSocketFrame.Text$.MODULE$.apply$default$2());
        }), (Function1 & Serializable)_$11 -> _$11.evalTap((Function1 & Serializable)f -> this.logWebSocketFrame$1((WebSocketFrame)f), this.evidence$3).evalMap((Function1 & Serializable)x$1 -> {
            Option option;
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Text && !(option = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                String s = (String)tuple2._1();
                return Try$.MODULE$.apply(() -> WsRouteHandler.webSocketConnection$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(s)).toEither().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).fold((Function1 & Serializable)e -> cats.effect.package$.MODULE$.Concurrent().apply(this.evidence$3, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)new RuntimeException(new StringBuilder(47).append("Could not parse client message ").append(s).append(" as FromClient: ").append(e).toString())), (Function1 & Serializable)m -> connection.receive((StreamingMessage.FromClient)m));
            }
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
                ByteVector byteVector = close._1();
                return connection.close();
            }
            WebSocketFrame f = webSocketFrame;
            return cats.effect.package$.MODULE$.Concurrent().apply(this.evidence$3, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)new RuntimeException(new StringBuilder(52).append("Expected a Text WebSocketFrame from Client, but got ").append(f).toString()));
        })), this.evidence$3).map((Function1 & Serializable)response -> response)));
    }

    private static final String logFromServer$1$$anonfun$1() {
        return "Sending ConnectionKeepAlive";
    }

    private static final String logFromServer$1$$anonfun$2(StreamingMessage.FromServer msg$1) {
        return new StringBuilder(19).append("Sending to client: ").append(WsRouteHandler.trimmedMessage$1(msg$1)).toString();
    }

    private final Object logFromServer$1(StreamingMessage.FromServer msg) {
        StreamingMessage.FromServer fromServer = msg;
        if (StreamingMessage.FromServer$.ConnectionKeepAlive$.MODULE$.equals(fromServer)) {
            return package$.MODULE$.debug((Function0<String>)((Function0 & Serializable)WsRouteHandler::logFromServer$1$$anonfun$1), this.evidence$2);
        }
        return package$.MODULE$.info((Function0<String>)((Function0 & Serializable)() -> WsRouteHandler.logFromServer$1$$anonfun$2(msg)), this.evidence$2);
    }

    private static final String logWebSocketFrame$1$$anonfun$1(UnanchoredRegex AuthRegEx$1, String RedactedAuth$1, String s$1, boolean last$1) {
        return new StringBuilder(41).append("Received Text frame (last=").append(last$1).append(") from client: ").append(((Regex)AuthRegEx$1).replaceFirstIn((CharSequence)s$1, RedactedAuth$1)).toString();
    }

    private static final String logWebSocketFrame$1$$anonfun$2(WebSocketFrame f$1) {
        return new StringBuilder(30).append("Received message from client: ").append(f$1).toString();
    }

    private final Object logWebSocketFrame$1(WebSocketFrame f) {
        Option option;
        UnanchoredRegex AuthRegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\"Authorization\":)\\s*\"[^\"]*\"")).unanchored();
        String RedactedAuth = "$1 <REDACTED>";
        WebSocketFrame webSocketFrame = f;
        if (webSocketFrame instanceof WebSocketFrame.Text && !(option = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            String s = (String)tuple2._1();
            boolean last = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            return package$.MODULE$.info((Function0<String>)((Function0 & Serializable)() -> WsRouteHandler.logWebSocketFrame$1$$anonfun$1(AuthRegEx, RedactedAuth, s, last)), this.evidence$2);
        }
        return package$.MODULE$.info((Function0<String>)((Function0 & Serializable)() -> WsRouteHandler.logWebSocketFrame$1$$anonfun$2(f)), this.evidence$2);
    }

    private static final String trimmedMessage$1(StreamingMessage.FromServer m) {
        StreamingMessage.FromServer fromServer = (StreamingMessage.FromServer)io.circe.syntax.package$.MODULE$.EncoderOps((Object)m);
        String s = package.EncoderOps$.MODULE$.asJson$extension((Object)fromServer, clue.model.json.package$.MODULE$.EncoderFromServer()).spaces2();
        if (s.length() > 516) {
            return new StringBuilder(4).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), 512)).append(" ...").toString();
        }
        return s;
    }

    private static final Either webSocketConnection$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(String s$2) {
        return io.circe.parser.package$.MODULE$.decode(s$2, clue.model.json.package$.MODULE$.DecoderFromClient());
    }
}

