/*
 * Decompiled with CFR 0.152.
 */
package lucuma.itc;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.data.NonEmptyList;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import coulomb.conversion.spire.unit;
import coulomb.ops.Ord;
import coulomb.ops.SimplifiedUnit;
import coulomb.ops.ValueResolution;
import coulomb.ops.standard.div;
import coulomb.ops.standard.mul;
import coulomb.ops.standard.sub;
import coulomb.policy.spire.standard$;
import coulomb.quantity;
import coulomb.quantity$package$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.types.numeric;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import lucuma.core.math.Wavelength;
import lucuma.itc.Itc;
import lucuma.itc.Itc$CalcResult$CalculationError$;
import lucuma.itc.Itc$CalcResult$SourceTooBright$;
import lucuma.itc.Itc$CalcResult$Success$;
import lucuma.itc.Itc$CalcResultWithVersion$;
import lucuma.itc.Itc$GraphResult$;
import lucuma.itc.Itc$SNCalcResult$SNCalcSuccess$;
import lucuma.itc.Itc$SNCalcResult$WavelengthAtAboveRange$;
import lucuma.itc.Itc$SNCalcResult$WavelengthAtBelowRange$;
import lucuma.itc.ItcCalculationError;
import lucuma.itc.ItcObservingConditions;
import lucuma.itc.UpstreamException;
import lucuma.itc.legacy.ItcParameters;
import lucuma.itc.legacy.ItcRemoteResult;
import lucuma.itc.legacy.LocalItc;
import lucuma.itc.legacy.encoders$package$;
import lucuma.itc.legacy.package$package$;
import lucuma.itc.search.ObservingMode;
import lucuma.itc.search.TargetProfile;
import lucuma.refined.Predicate;
import natchez.Span;
import natchez.Trace;
import natchez.Trace$;
import natchez.TraceValue$;
import natchez.TraceableValue$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.;
import scala.$less$colon$less$;
import scala.Conversion;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.matching.Regex;
import spire.math.ConvertableFrom$;
import spire.math.ConvertableTo$;
import spire.math.Fractional$;
import spire.math.package$;

public final class ItcImpl$
implements Serializable {
    private static final Regex Error400Regex;
    public static final ItcImpl$ MODULE$;

    private ItcImpl$() {
    }

    static {
        MODULE$ = new ItcImpl$();
        Error400Regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<title>Error 400 (.*)</title>"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ItcImpl$.class);
    }

    public Regex Error400Regex() {
        return Error400Regex;
    }

    public <F> Itc<F> build(LocalItc itcLocal, MonadError<F, Throwable> evidence$2, Logger<F> evidence$3, Trace<F> evidence$4) {
        return new Itc<F>(itcLocal, evidence$2, evidence$3, evidence$4){
            private final LocalItc itcLocal$2;
            private final MonadError evidence$2$2;
            private final Trace evidence$4$2;
            private final Applicative lucuma$itc$SignalToNoiseCalculation$$evidence$1;
            private final Logger L;
            private final int MaxIterations;
            {
                this.itcLocal$2 = itcLocal$1;
                this.evidence$2$2 = evidence$2$1;
                this.evidence$4$2 = evidence$4$1;
                this.lucuma$itc$SignalToNoiseCalculation$$evidence$1 = evidence$2$1;
                this.L = Logger$.MODULE$.apply(evidence$3$1);
                this.MaxIterations = 10;
            }

            public Applicative lucuma$itc$SignalToNoiseCalculation$$evidence$1() {
                return this.lucuma$itc$SignalToNoiseCalculation$$evidence$1;
            }

            public Logger L() {
                return this.L;
            }

            public Object calculateExposureTime(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, BigDecimal signalToNoise, Option signalToNoiseAt) {
                ObservingMode observingMode2 = observingMode;
                if (observingMode2 instanceof ObservingMode.Spectroscopy) {
                    return this.spectroscopy(targetProfile, observingMode, constraints, signalToNoise, signalToNoiseAt);
                }
                throw new MatchError((Object)observingMode2);
            }

            public Object calculateGraph(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, Duration exposureTime, long exposures) {
                ObservingMode observingMode2 = observingMode;
                if (observingMode2 instanceof ObservingMode.Spectroscopy) {
                    quantity$package$ quantity$package$2;
                    quantity$package$ quantity$package$_this = quantity$package$2 = quantity$package$.MODULE$;
                    BigDecimal v$proxy1 = BigDecimal$.MODULE$.apply(((Duration)Refined.package.Refined$.MODULE$.value((Object)exposureTime)).toMillis());
                    BigDecimal ql$proxy7 = (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy1);
                    unit.infra$.BigDecimalUC conv$proxy1 = new unit.infra$.BigDecimalUC(scala.package$.MODULE$.BigDecimal().apply("0.001"));
                    quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                    quantity$package$ quantity$package$4 = quantity$package$2;
                    BigDecimal ql$proxy8 = ql$proxy7;
                    BigDecimal v$proxy2 = (BigDecimal)conv$proxy1.apply((Object)ql$proxy8);
                    return this.spectroscopyGraph(targetProfile, observingMode, constraints, (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy2), BoxesRunTime.unboxToLong((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToLong((long)exposures))));
                }
                throw new MatchError((Object)observingMode2);
            }

            public Object itc(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, BigDecimal exposureDuration, int exposures, int level) {
                Object object;
                Trace trace = Trace$.MODULE$.apply(this.evidence$4$2);
                Span.Options options = trace.span$default$2();
                quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
                BigDecimal ql$proxy9 = exposureDuration;
                ItcParameters itcParameters = (ItcParameters)io.circe.syntax.package$.MODULE$.EncoderOps((Object)package$package$.MODULE$.spectroscopyParams(targetProfile, observingMode, new package.DurationDouble(scala.concurrent.duration.package$.MODULE$.DurationDouble(ql$proxy9.toDouble())).seconds(), constraints, exposures));
                Json request = package.EncoderOps$.MODULE$.asJson$extension((Object)itcParameters, encoders$package$.MODULE$.given_Encoder_ItcParameters());
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.query");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)request.spaces2(), TraceableValue$.MODULE$.stringToTraceValue()));
                Object[] objectArray2 = new Tuple2[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.exposureDuration");
                quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                BigDecimal ql$proxy10 = exposureDuration;
                objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)BoxesRunTime.boxToInteger((int)ql$proxy10.toInt()), TraceableValue$.MODULE$.intToTraceValue()));
                Object[] objectArray3 = new Tuple2[1];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.exposures");
                objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)BoxesRunTime.boxToInteger((int)exposures), TraceableValue$.MODULE$.intToTraceValue()));
                Object[] objectArray4 = new Tuple2[1];
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.level");
                objectArray4[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)TraceValue$.MODULE$.viaTraceableValue(Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)level)), TraceableValue$.MODULE$.intToTraceValue()));
                Apply.Ops ops = package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Apply)this.evidence$2$2).$times$greater(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (Apply)this.evidence$2$2).$times$greater(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), (Apply)this.evidence$2$2).$times$greater(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4))), (Apply)this.evidence$2$2);
                Either<String, ItcRemoteResult> either = this.itcLocal$2.callLocal(request.noSpaces());
                if (either instanceof Right) {
                    ItcRemoteResult r = (ItcRemoteResult)((Right)either).value();
                    ItcRemoteResult itcRemoteResult = (ItcRemoteResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)r);
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)itcRemoteResult, (Applicative)this.evidence$2$2);
                } else if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    object = package.all$.MODULE$.catsSyntaxApply(this.L().warn(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$itc$$anonfun$1(msg)), (Apply)this.evidence$2$2).$times$greater(package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)this.evidence$2$2).raiseError((Object)new UpstreamException(msg)));
                } else {
                    throw new MatchError(either);
                }
                return trace.span("legacy-itc-query", options, ops.$times$greater(object));
            }

            public Object itcGraph(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, BigDecimal exposureDuration, long exposures) {
                Object object;
                Trace trace = Trace$.MODULE$.apply(this.evidence$4$2);
                Span.Options options = trace.span$default$2();
                quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
                BigDecimal ql$proxy11 = exposureDuration;
                ItcParameters itcParameters = (ItcParameters)io.circe.syntax.package$.MODULE$.EncoderOps((Object)package$package$.MODULE$.spectroscopyParams(targetProfile, observingMode, new package.DurationDouble(scala.concurrent.duration.package$.MODULE$.DurationDouble(ql$proxy11.toDouble())).seconds(), constraints, (int)exposures));
                Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)itcParameters, encoders$package$.MODULE$.given_Encoder_ItcParameters());
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.query");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)json.spaces2(), TraceableValue$.MODULE$.stringToTraceValue()));
                Object[] objectArray2 = new Tuple2[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.exposureDuration");
                quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                BigDecimal ql$proxy12 = exposureDuration;
                objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)BoxesRunTime.boxToInteger((int)ql$proxy12.toInt()), TraceableValue$.MODULE$.intToTraceValue()));
                Object[] objectArray3 = new Tuple2[1];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"itc.exposures");
                objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)TraceValue$.MODULE$.viaTraceableValue((Object)BoxesRunTime.boxToInteger((int)((int)exposures)), TraceableValue$.MODULE$.intToTraceValue()));
                Apply.Ops ops = package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Apply)this.evidence$2$2).$times$greater(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (Apply)this.evidence$2$2).$times$greater(Trace$.MODULE$.apply(this.evidence$4$2).put((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), (Apply)this.evidence$2$2);
                Either<String, ItcRemoteResult> either = this.itcLocal$2.callLocal(json.noSpaces());
                if (either instanceof Right) {
                    ItcRemoteResult r = (ItcRemoteResult)((Right)either).value();
                    ItcRemoteResult itcRemoteResult = (ItcRemoteResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)r);
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)itcRemoteResult, (Applicative)this.evidence$2$2);
                } else if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    object = package.all$.MODULE$.catsSyntaxApply(this.L().warn(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$itcGraph$$anonfun$1(msg)), (Apply)this.evidence$2$2).$times$greater(package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)this.evidence$2$2).raiseError((Object)new UpstreamException(msg)));
                } else {
                    throw new MatchError(either);
                }
                return trace.span("legacy-itc-query", options, ops.$times$greater(object));
            }

            public int MaxIterations() {
                return this.MaxIterations;
            }

            public Object spectroscopyGraph(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, BigDecimal exposureDuration, long exposures) {
                return package.all$.MODULE$.toFunctorOps(this.itcGraph(targetProfile, observingMode, constraints, exposureDuration, exposures), (Functor)this.evidence$2$2).map(ItcImpl$::lucuma$itc$ItcImpl$$anon$1$$_$spectroscopyGraph$$anonfun$1);
            }

            public Object spectroscopy(TargetProfile targetProfile, ObservingMode observingMode, ItcObservingConditions constraints, BigDecimal signalToNoise, Option signalToNoiseAt) {
                BigDecimal v$proxy3 = BigDecimal$.MODULE$.apply(1200.0);
                BigDecimal startExpTime = (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy3);
                int numberOfExposures = 1;
                double requestedSN = signalToNoise.toDouble();
                Trace trace = Trace$.MODULE$.apply(this.evidence$4$2);
                Predicate.given_Predicate_Int_Negative p$proxy1 = new Predicate.given_Predicate_Int_Negative();
                Predicate.given_Predicate_T_Not given_Predicate_T_Not_this = new Predicate.given_Predicate_T_Not((Predicate)p$proxy1);
                Predicate.given_Predicate_Int_Negative given_Predicate_Int_Negative_this = (Predicate.given_Predicate_Int_Negative)given_Predicate_T_Not_this.inline$p();
                return package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(this.L().info(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$1(signalToNoise)), (Apply)this.evidence$2$2).$times$greater(this.L().info(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$2(targetProfile))), (Apply)this.evidence$2$2).$times$greater(trace.span("itc.calctime.spectroscopy", trace.span$default$2(), package.all$.MODULE$.toFlatMapOps(this.itc(targetProfile, observingMode, constraints, startExpTime, numberOfExposures, BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.unsafeApply((Object)BoxesRunTime.boxToInteger((int)1)))), (FlatMap)this.evidence$2$2).flatMap((Function1 & Serializable)r -> {
                    Object object;
                    quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
                    BigDecimal ql$proxy29 = startExpTime;
                    BigDecimal halfWellTime = BigDecimal$.MODULE$.double2bigDecimal(r.maxWellDepth() / (double)2 / (double)r.maxPeakPixelFlux()).$times(ql$proxy29);
                    Apply.Ops ops = package.all$.MODULE$.catsSyntaxApply(this.L().info(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$1(r, halfWellTime)), (Apply)this.evidence$2$2);
                    if (halfWellTime.$less((Object)BigDecimal$.MODULE$.double2bigDecimal(1.0))) {
                        String msg = new StringBuilder(42).append("Target is too bright. Well half filled in ").append(halfWellTime).toString();
                        Itc.CalcResultWithVersion calcResultWithVersion = (Itc.CalcResultWithVersion)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResultWithVersion$.MODULE$.apply(Itc$CalcResult$SourceTooBright$.MODULE$.apply(msg), Itc$CalcResultWithVersion$.MODULE$.$lessinit$greater$default$2()));
                        object = package.all$.MODULE$.catsSyntaxApply(this.L().error(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$2(msg)), (Apply)this.evidence$2$2).$times$greater(package.all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension((Object)calcResultWithVersion, (Applicative)this.evidence$2$2), (Functor)this.evidence$2$2).widen());
                    } else {
                        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                        BigDecimal ql$proxy30 = startExpTime;
                        BigDecimal maxTime = ql$proxy30.min(halfWellTime);
                        object = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.calculateSignalToNoise((NonEmptyList)r.groups(), signalToNoiseAt), (FlatMap)this.evidence$2$2).flatMap((Function1 & Serializable)x$1 -> {
                            Itc.SNCalcResult sNCalcResult = x$1;
                            if (sNCalcResult instanceof Itc.SNCalcResult.SNCalcSuccess) {
                                BigDecimal bigDecimal;
                                Itc.SNCalcResult.SNCalcSuccess sNCalcSuccess = Itc$SNCalcResult$SNCalcSuccess$.MODULE$.unapply((Itc.SNCalcResult.SNCalcSuccess)sNCalcResult);
                                BigDecimal snr = bigDecimal = sNCalcSuccess._1();
                                BigDecimal v$proxy11 = BigDecimal$.MODULE$.apply(0);
                                Predicate.given_Predicate_Int_Negative p$proxy4 = new Predicate.given_Predicate_Int_Negative();
                                Predicate.given_Predicate_T_Not given_Predicate_T_Not_this = new Predicate.given_Predicate_T_Not((Predicate)p$proxy4);
                                Predicate.given_Predicate_Int_Negative given_Predicate_Int_Negative_this = (Predicate.given_Predicate_Int_Negative)given_Predicate_T_Not_this.inline$p();
                                return this.itcStep$1(targetProfile, observingMode, constraints, signalToNoiseAt, requestedSN, numberOfExposures, 0, startExpTime, (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy11), snr.toDouble(), (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)maxTime), (ItcRemoteResult)r, BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.unsafeApply((Object)BoxesRunTime.boxToInteger((int)0))));
                            }
                            if (sNCalcResult instanceof Itc.SNCalcResult.WavelengthAtAboveRange) {
                                int n;
                                Itc.SNCalcResult.WavelengthAtAboveRange wavelengthAtAboveRange = Itc$SNCalcResult$WavelengthAtAboveRange$.MODULE$.unapply((Itc.SNCalcResult.WavelengthAtAboveRange)sNCalcResult);
                                int w = n = wavelengthAtAboveRange._1();
                                Itc.CalcResult calcResult = (Itc.CalcResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResult$CalculationError$.MODULE$.apply(StringOps$.MODULE$.format$extension("S/N at %.0f nm above range", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Wavelength.package.Wavelength$.MODULE$.decimalNanometers().reverseGet().apply((Object)BoxesRunTime.boxToInteger((int)w))}))));
                                return ApplicativeIdOps$.MODULE$.pure$extension((Object)calcResult, (Applicative)this.evidence$2$2);
                            }
                            if (sNCalcResult instanceof Itc.SNCalcResult.WavelengthAtBelowRange) {
                                int n;
                                Itc.SNCalcResult.WavelengthAtBelowRange wavelengthAtBelowRange = Itc$SNCalcResult$WavelengthAtBelowRange$.MODULE$.unapply((Itc.SNCalcResult.WavelengthAtBelowRange)sNCalcResult);
                                int w = n = wavelengthAtBelowRange._1();
                                Itc.CalcResult calcResult = (Itc.CalcResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResult$CalculationError$.MODULE$.apply(StringOps$.MODULE$.format$extension("S/N at %.0f nm below range", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Wavelength.package.Wavelength$.MODULE$.decimalNanometers().reverseGet().apply((Object)BoxesRunTime.boxToInteger((int)w))}))));
                                return ApplicativeIdOps$.MODULE$.pure$extension((Object)calcResult, (Applicative)this.evidence$2$2);
                            }
                            Itc.SNCalcResult r = sNCalcResult;
                            Itc.CalcResult calcResult = (Itc.CalcResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResult$CalculationError$.MODULE$.apply(r.toString()));
                            return ApplicativeIdOps$.MODULE$.pure$extension((Object)calcResult, (Applicative)this.evidence$2$2);
                        }), (Functor)this.evidence$2$2).map(arg_0 -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$4(r, arg_0));
                    }
                    return ops.$times$greater(object);
                })));
            }

            /*
             * Enabled aggressive block sorting
             */
            private final Object itcStep$1(TargetProfile targetProfile$1, ObservingMode observingMode$1, ItcObservingConditions constraints$1, Option signalToNoiseAt$3, double requestedSN$1, int nExp, int oldNExp, BigDecimal expTime, BigDecimal oldExpTime, double snr, BigDecimal maxTime, ItcRemoteResult s2, int counter) {
                Object object;
                Apply.Ops ops;
                BigDecimal newExpTime;
                BigDecimal newNExp;
                block6: {
                    int next;
                    block4: {
                        block5: {
                            if (package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToDouble((double)snr), (Eq)algebra.instances.all.package$.MODULE$.catsKernelStdOrderForDouble()).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0))) {
                                return package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)this.evidence$2$2).raiseError((Object)new ItcCalculationError("S/N obtained is 0"));
                            }
                            quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
                            quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
                            BigDecimal ql$proxy1 = expTime;
                            int qr$proxy1 = BoxesRunTime.unboxToInt((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToInteger((int)nExp)));
                            NotGiven nev$proxy1 = NotGiven$.MODULE$.value();
                            ValueResolution.NC vres$proxy1 = new ValueResolution.NC();
                            Conversion icl$proxy1 = standard$.MODULE$.ctx_Quantity_Conversion_1V1U();
                            Conversion icr$proxy1 = standard$.MODULE$.ctx_Quantity_Conversion_2V1U(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.BigDecimalIsFractional(), ConvertableFrom$.MODULE$.ConvertableFromInt(), ConvertableTo$.MODULE$.ConvertableToBigDecimal()));
                            SimplifiedUnit.NC su$proxy1 = new SimplifiedUnit.NC();
                            mul.infra$.MulNC mul$proxy1 = new mul.infra$.MulNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$adapted$2(icl$proxy1, icr$proxy1, arg_0, arg_1));
                            BigDecimal ql$proxy2 = (BigDecimal)mul$proxy1.eval().apply((Object)ql$proxy1, (Object)BoxesRunTime.boxToInteger((int)qr$proxy1));
                            double v$proxy5 = scala.math.package$.MODULE$.pow(requestedSN$1 / snr, 2.0);
                            double qr$proxy2 = BoxesRunTime.unboxToDouble((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToDouble((double)v$proxy5)));
                            NotGiven nev$proxy2 = NotGiven$.MODULE$.value();
                            ValueResolution.NC vres$proxy2 = new ValueResolution.NC();
                            Conversion icl$proxy2 = standard$.MODULE$.ctx_Quantity_Conversion_1V1U();
                            Conversion icr$proxy2 = standard$.MODULE$.ctx_Quantity_Conversion_2V1U(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.BigDecimalIsFractional(), ConvertableFrom$.MODULE$.ConvertableFromDouble(), ConvertableTo$.MODULE$.ConvertableToBigDecimal()));
                            SimplifiedUnit.NC su$proxy2 = new SimplifiedUnit.NC();
                            mul.infra$.MulNC mul$proxy2 = new mul.infra$.MulNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$adapted$3(icl$proxy2, icr$proxy2, arg_0, arg_1));
                            BigDecimal totalTime = (BigDecimal)mul$proxy2.eval().apply((Object)ql$proxy2, (Object)BoxesRunTime.boxToDouble((double)qr$proxy2));
                            quantity$package$ quantity$package$4 = quantity$package$.MODULE$;
                            quantity$package$ quantity$package$5 = quantity$package$.MODULE$;
                            BigDecimal ql$proxy3 = totalTime;
                            BigDecimal qr$proxy3 = maxTime;
                            .eq.colon.eq eqv$proxy1 = $less$colon$less$.MODULE$.refl();
                            SimplifiedUnit.NC su$proxy3 = new SimplifiedUnit.NC();
                            div.infra$.DivNC div$proxy1 = new div.infra$.DivNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$7(eqv$proxy1, arg_0, arg_1));
                            BigDecimal ql$proxy19 = (BigDecimal)div$proxy1.eval().apply((Object)ql$proxy3, (Object)qr$proxy3);
                            newNExp = package$.MODULE$.ceil(ql$proxy19);
                            quantity$package$ quantity$package$6 = quantity$package$.MODULE$;
                            quantity$package$ quantity$package$7 = quantity$package$.MODULE$;
                            BigDecimal ql$proxy4 = totalTime;
                            BigDecimal qr$proxy4 = (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)newNExp);
                            .eq.colon.eq eqv$proxy2 = $less$colon$less$.MODULE$.refl();
                            SimplifiedUnit.NC su$proxy4 = new SimplifiedUnit.NC();
                            div.infra$.DivNC div$proxy2 = new div.infra$.DivNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$8(eqv$proxy2, arg_0, arg_1));
                            BigDecimal ql$proxy22 = (BigDecimal)div$proxy2.eval().apply((Object)ql$proxy4, (Object)qr$proxy4);
                            newExpTime = package$.MODULE$.ceil(ql$proxy22);
                            next = BoxesRunTime.unboxToInt((Object)numeric.NonNegInt$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)counter))) + 1))).getOrElse(ItcImpl$::lucuma$itc$ItcImpl$$anon$1$$_$_$$anonfun$9));
                            ops = package.all$.MODULE$.catsSyntaxApply(package.all$.MODULE$.catsSyntaxApply(this.L().info(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$1(maxTime, totalTime)), (Apply)this.evidence$2$2).$times$greater(this.L().info(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$2(counter, newNExp, newExpTime))), (Apply)this.evidence$2$2);
                            if (nExp != oldNExp) break block4;
                            quantity$package$ quantity$package$8 = quantity$package$.MODULE$;
                            quantity$package$ quantity$package$9 = quantity$package$.MODULE$;
                            BigDecimal ql$proxy5 = expTime;
                            BigDecimal qr$proxy5 = oldExpTime;
                            .eq.colon.eq eqv$proxy3 = $less$colon$less$.MODULE$.refl();
                            .eq.colon.eq equ$proxy1 = $less$colon$less$.MODULE$.refl();
                            sub.infra$.SubNC sub$proxy1 = new sub.infra$.SubNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$10(eqv$proxy3, arg_0, arg_1));
                            BigDecimal ql$proxy25 = (BigDecimal)sub$proxy1.eval().apply((Object)ql$proxy5, (Object)qr$proxy5);
                            int qr$proxy7 = BoxesRunTime.unboxToInt((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToInteger((int)1)));
                            Ord ord$proxy1 = standard$.MODULE$.ctx_ord_2V1U(NotGiven$.MODULE$.value(), $less$colon$less$.MODULE$.refl(), (ValueResolution)new ValueResolution.NC(), standard$.MODULE$.ctx_Quantity_Conversion_1V1U(), standard$.MODULE$.ctx_Quantity_Conversion_2V1U(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.BigDecimalIsFractional(), ConvertableFrom$.MODULE$.ConvertableFromInt(), ConvertableTo$.MODULE$.ConvertableToBigDecimal())), (Order)algebra.instances.all.package$.MODULE$.catsKernelStdOrderForBigDecimal());
                            if (BoxesRunTime.unboxToInt((Object)ord$proxy1.apply((Object)ql$proxy25, (Object)BoxesRunTime.boxToInteger((int)qr$proxy7))) > 0) break block5;
                            quantity$package$ quantity$package$10 = quantity$package$.MODULE$;
                            quantity$package$ quantity$package$11 = quantity$package$.MODULE$;
                            BigDecimal ql$proxy6 = oldExpTime;
                            BigDecimal qr$proxy6 = expTime;
                            .eq.colon.eq eqv$proxy4 = $less$colon$less$.MODULE$.refl();
                            .eq.colon.eq equ$proxy2 = $less$colon$less$.MODULE$.refl();
                            sub.infra$.SubNC sub$proxy2 = new sub.infra$.SubNC((arg_0, arg_1) -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$11(eqv$proxy4, arg_0, arg_1));
                            BigDecimal ql$proxy28 = (BigDecimal)sub$proxy2.eval().apply((Object)ql$proxy6, (Object)qr$proxy6);
                            int qr$proxy8 = BoxesRunTime.unboxToInt((Object)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)BoxesRunTime.boxToInteger((int)1)));
                            Ord ord$proxy2 = standard$.MODULE$.ctx_ord_2V1U(NotGiven$.MODULE$.value(), $less$colon$less$.MODULE$.refl(), (ValueResolution)new ValueResolution.NC(), standard$.MODULE$.ctx_Quantity_Conversion_1V1U(), standard$.MODULE$.ctx_Quantity_Conversion_2V1U(standard$.MODULE$.ctx_spire_VC_XF(Fractional$.MODULE$.BigDecimalIsFractional(), ConvertableFrom$.MODULE$.ConvertableFromInt(), ConvertableTo$.MODULE$.ConvertableToBigDecimal())), (Order)algebra.instances.all.package$.MODULE$.catsKernelStdOrderForBigDecimal());
                            if (!(BoxesRunTime.unboxToInt((Object)ord$proxy2.apply((Object)ql$proxy28, (Object)BoxesRunTime.boxToInteger((int)qr$proxy8))) > 0)) break block6;
                        }
                        if (BoxesRunTime.unboxToInt((Object)Refined.package.Refined$.MODULE$.value((Object)BoxesRunTime.boxToInteger((int)counter))) >= this.MaxIterations() || !newExpTime.$less((Object)BigDecimal$.MODULE$.double2bigDecimal(scala.math.package$.MODULE$.pow(2.0, 63.0) - 1.0))) break block6;
                    }
                    object = package.all$.MODULE$.toFlatMapOps(this.itc(targetProfile$1, observingMode$1, constraints$1, (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)newExpTime), newNExp.toInt(), next), (FlatMap)this.evidence$2$2).flatMap((Function1 & Serializable)s -> package.all$.MODULE$.catsSyntaxApply(this.L().debug(() -> ItcImpl$.lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$3$$anonfun$1(s)), (Apply)this.evidence$2$2).$times$greater(package.all$.MODULE$.toFlatMapOps(this.calculateSignalToNoise((NonEmptyList)s.groups(), signalToNoiseAt$3), (FlatMap)this.evidence$2$2).flatMap((Function1 & Serializable)x$1 -> {
                        Itc.SNCalcResult sNCalcResult = x$1;
                        if (sNCalcResult instanceof Itc.SNCalcResult.SNCalcSuccess) {
                            BigDecimal bigDecimal;
                            Itc.SNCalcResult.SNCalcSuccess sNCalcSuccess = Itc$SNCalcResult$SNCalcSuccess$.MODULE$.unapply((Itc.SNCalcResult.SNCalcSuccess)sNCalcResult);
                            BigDecimal snr = bigDecimal = sNCalcSuccess._1();
                            return this.itcStep$1(targetProfile$1, observingMode$1, constraints$1, signalToNoiseAt$3, requestedSN$1, newNExp.toInt(), nExp, (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)newExpTime), expTime, snr.toDouble(), maxTime, (ItcRemoteResult)s, next);
                        }
                        Itc.SNCalcResult r = sNCalcResult;
                        Itc.CalcResult calcResult = (Itc.CalcResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResult$CalculationError$.MODULE$.apply(r.toString()));
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)calcResult, (Applicative)this.evidence$2$2);
                    })));
                    return ops.$times$greater(object);
                }
                Itc.CalcResult.Success success = (Itc.CalcResult.Success)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Itc$CalcResult$Success$.MODULE$.apply(new package.DurationDouble(scala.concurrent.duration.package$.MODULE$.DurationDouble(newExpTime.toDouble())).seconds(), newNExp.toInt(), BigDecimal$.MODULE$.double2bigDecimal(s2.maxTotalSNRatio())));
                object = package.all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension((Object)success, (Applicative)this.evidence$2$2), (Functor)this.evidence$2$2).widen();
                return ops.$times$greater(object);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{lucuma$itc$ItcImpl$$anon$1$$_$itc$$anonfun$1(java.lang.String ), lucuma$itc$ItcImpl$$anon$1$$_$itcGraph$$anonfun$1(java.lang.String ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopyGraph$$anonfun$1(lucuma.itc.legacy.ItcRemoteResult ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$1(scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$2(lucuma.itc.search.TargetProfile ), spectroscopy$$anonfun$3(lucuma.itc.search.TargetProfile lucuma.itc.search.ObservingMode lucuma.itc.ItcObservingConditions scala.Option scala.math.BigDecimal int double lucuma.itc.legacy.ItcRemoteResult ), lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$3$$anonfun$1(lucuma.itc.legacy.ItcRemoteResult ), itcStep$1$$anonfun$3$$anonfun$2(lucuma.itc.search.TargetProfile lucuma.itc.search.ObservingMode lucuma.itc.ItcObservingConditions scala.Option double int scala.math.BigDecimal scala.math.BigDecimal scala.math.BigDecimal scala.math.BigDecimal int lucuma.itc.legacy.ItcRemoteResult lucuma.itc.Itc$SNCalcResult ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$adapted$2(scala.Conversion scala.Conversion java.lang.Object java.lang.Object ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$adapted$3(scala.Conversion scala.Conversion java.lang.Object java.lang.Object ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$7(scala.$eq$colon$eq scala.math.BigDecimal scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$8(scala.$eq$colon$eq scala.math.BigDecimal scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$_$$anonfun$9(), lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$1(scala.math.BigDecimal scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$2(int scala.math.BigDecimal scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$10(scala.$eq$colon$eq scala.math.BigDecimal scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$11(scala.$eq$colon$eq scala.math.BigDecimal scala.math.BigDecimal ), itcStep$1$$anonfun$3(lucuma.itc.search.TargetProfile lucuma.itc.search.ObservingMode lucuma.itc.ItcObservingConditions scala.Option double int scala.math.BigDecimal scala.math.BigDecimal scala.math.BigDecimal scala.math.BigDecimal int lucuma.itc.legacy.ItcRemoteResult ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$1(lucuma.itc.legacy.ItcRemoteResult scala.math.BigDecimal ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$2(java.lang.String ), spectroscopy$$anonfun$3$$anonfun$3(lucuma.itc.search.TargetProfile lucuma.itc.search.ObservingMode lucuma.itc.ItcObservingConditions scala.Option scala.math.BigDecimal int double lucuma.itc.legacy.ItcRemoteResult scala.math.BigDecimal lucuma.itc.Itc$SNCalcResult ), lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$4(lucuma.itc.legacy.ItcRemoteResult lucuma.itc.Itc$CalcResult )}, serializedLambda);
            }
        };
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$itc$$anonfun$1(String msg$1) {
        return new StringBuilder(15).append("Upstream error ").append(msg$1).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$itcGraph$$anonfun$1(String msg$2) {
        return new StringBuilder(15).append("Upstream error ").append(msg$2).toString();
    }

    public static final /* synthetic */ Itc.GraphResult lucuma$itc$ItcImpl$$anon$1$$_$spectroscopyGraph$$anonfun$1(ItcRemoteResult r) {
        return Itc$GraphResult$.MODULE$.fromLegacy(r.versionToken(), r.ccds(), r.groups());
    }

    private static final /* synthetic */ BigDecimal $anonfun$5(Conversion icl$proxy1$1, Conversion icr$proxy1$1, BigDecimal ql, int qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy13 = (BigDecimal)icl$proxy1$1.apply((Object)ql);
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy14 = (BigDecimal)icr$proxy1$1.apply((Object)BoxesRunTime.boxToInteger((int)qr));
        BigDecimal v$proxy4 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().times(ql$proxy13, ql$proxy14);
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy4);
    }

    public static /* bridge */ /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$adapted$2(Conversion icl$proxy1$2, Conversion icr$proxy1$2, Object ql, Object qr) {
        return ItcImpl$.$anonfun$5(icl$proxy1$2, icr$proxy1$2, (BigDecimal)ql, BoxesRunTime.unboxToInt((Object)qr));
    }

    private static final /* synthetic */ BigDecimal $anonfun$6(Conversion icl$proxy2$1, Conversion icr$proxy2$1, BigDecimal ql, double qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy15 = (BigDecimal)icl$proxy2$1.apply((Object)ql);
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy16 = (BigDecimal)icr$proxy2$1.apply((Object)BoxesRunTime.boxToDouble((double)qr));
        BigDecimal v$proxy6 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().times(ql$proxy15, ql$proxy16);
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy6);
    }

    public static /* bridge */ /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$adapted$3(Conversion icl$proxy2$2, Conversion icr$proxy2$2, Object ql, Object qr) {
        return ItcImpl$.$anonfun$6(icl$proxy2$2, icr$proxy2$2, (BigDecimal)ql, BoxesRunTime.unboxToDouble((Object)qr));
    }

    public static final /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$7(.eq.colon.eq eqv$proxy1$1, BigDecimal ql, BigDecimal qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy17 = ql;
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy18 = qr;
        BigDecimal v$proxy7 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().div(ql$proxy17, (BigDecimal)eqv$proxy1$1.apply((Object)ql$proxy18));
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy7);
    }

    public static final /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$_$$anonfun$8(.eq.colon.eq eqv$proxy2$1, BigDecimal ql, BigDecimal qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy20 = ql;
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy21 = qr;
        BigDecimal v$proxy8 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().div(ql$proxy20, (BigDecimal)eqv$proxy2$1.apply((Object)ql$proxy21));
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy8);
    }

    public static final int lucuma$itc$ItcImpl$$anon$1$$_$_$$anonfun$9() {
        throw scala.sys.package$.MODULE$.error("Should not happen");
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$1(BigDecimal maxTime$1, BigDecimal totalTime$1) {
        return new StringBuilder(22).append("Total time: ").append(totalTime$1).append(" maxTime: ").append(maxTime$1).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$2(int counter$1, BigDecimal newNExp$1, BigDecimal newExpTime$1) {
        return new StringBuilder(32).append("Exp time :").append(newExpTime$1).append(" s/Num exp ").append(newNExp$1).append("/iteration ").append(counter$1).toString();
    }

    public static final /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$10(.eq.colon.eq eqv$proxy3$1, BigDecimal ql, BigDecimal qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy23 = ql;
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy24 = qr;
        BigDecimal v$proxy9 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().minus(ql$proxy23, (BigDecimal)eqv$proxy3$1.apply((Object)ql$proxy24));
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy9);
    }

    public static final /* synthetic */ BigDecimal lucuma$itc$ItcImpl$$anon$1$$_$_$_$$anonfun$11(.eq.colon.eq eqv$proxy4$1, BigDecimal ql, BigDecimal qr) {
        quantity$package$ quantity$package$2 = quantity$package$.MODULE$;
        BigDecimal ql$proxy26 = ql;
        quantity$package$ quantity$package$3 = quantity$package$.MODULE$;
        BigDecimal ql$proxy27 = qr;
        BigDecimal v$proxy10 = algebra.instances.all.package$.MODULE$.bigDecimalAlgebra().minus(ql$proxy26, (BigDecimal)eqv$proxy4$1.apply((Object)ql$proxy27));
        return (BigDecimal)quantity.package.Quantity$.MODULE$.apply(quantity.package.Quantity$.Applier$.MODULE$.ctx_Applier()).apply((Object)v$proxy10);
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$itcStep$1$$anonfun$3$$anonfun$1(ItcRemoteResult s$1) {
        return new StringBuilder(8).append("-> S/N: ").append(s$1.maxTotalSNRatio()).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$1(BigDecimal signalToNoise$1) {
        return new StringBuilder(12).append("Desired S/N ").append(signalToNoise$1).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$2(TargetProfile targetProfile$4) {
        return new StringBuilder(27).append("Target brightness ").append(targetProfile$4).append(" at band ").append(targetProfile$4.band()).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$1(ItcRemoteResult r$1, BigDecimal halfWellTime$1) {
        return new StringBuilder(57).append("Results CCD wellDepth: ").append(r$1.maxWellDepth()).append(", peakPixelFlux: ").append(r$1.maxPeakPixelFlux()).append(", totalSNRatio: ").append(r$1.maxTotalSNRatio()).append(" ").append(halfWellTime$1).toString();
    }

    public static final String lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$2(String msg$3) {
        return msg$3;
    }

    public static final /* synthetic */ Itc.CalcResultWithVersion lucuma$itc$ItcImpl$$anon$1$$_$spectroscopy$$anonfun$3$$anonfun$4(ItcRemoteResult r$3, Itc.CalcResult x) {
        String string = (String)package.all$.MODULE$.catsSyntaxOptionId((Object)r$3.versionToken());
        return Itc$CalcResultWithVersion$.MODULE$.apply(x, (Option<String>)OptionIdOps$.MODULE$.some$extension((Object)string));
    }
}

