/*
 * Decompiled with CFR 0.152.
 */
package lucuma.schemas.model;

import cats.arrow.Compose;
import cats.arrow.Compose$;
import cats.kernel.Eq;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lucuma.core.math.Epoch;
import lucuma.core.model.SiderealTracking;
import lucuma.core.model.SiderealTracking$;
import lucuma.core.model.Target;
import lucuma.core.util.WithGid;
import lucuma.schemas.model.SiderealTargetWithId$;
import lucuma.schemas.model.TargetWithId;
import lucuma.schemas.model.TargetWithId$;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SiderealTargetWithId
implements Product,
Serializable {
    private final WithGid.Id id;
    private final Target.Sidereal target;

    public static SiderealTargetWithId apply(WithGid.Id id, Target.Sidereal sidereal) {
        return SiderealTargetWithId$.MODULE$.apply(id, sidereal);
    }

    public static Eq<SiderealTargetWithId> derived$Eq() {
        return SiderealTargetWithId$.MODULE$.derived$Eq();
    }

    public static SiderealTargetWithId fromProduct(Product product) {
        return SiderealTargetWithId$.MODULE$.fromProduct(product);
    }

    public static SiderealTargetWithId unapply(SiderealTargetWithId siderealTargetWithId) {
        return SiderealTargetWithId$.MODULE$.unapply(siderealTargetWithId);
    }

    public SiderealTargetWithId(WithGid.Id id, Target.Sidereal target) {
        this.id = id;
        this.target = target;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SiderealTargetWithId)) return false;
        SiderealTargetWithId siderealTargetWithId = (SiderealTargetWithId)object;
        WithGid.Id id = this.id();
        WithGid.Id id2 = siderealTargetWithId.id();
        if (id == null) {
            if (id2 != null) {
                return false;
            }
        } else if (!id.equals(id2)) return false;
        Target.Sidereal sidereal = this.target();
        Target.Sidereal sidereal2 = siderealTargetWithId.target();
        if (sidereal == null) {
            if (sidereal2 != null) {
                return false;
            }
        } else if (!sidereal.equals(sidereal2)) return false;
        if (!siderealTargetWithId.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SiderealTargetWithId;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "SiderealTargetWithId";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "id";
        }
        if (1 == n2) {
            return "target";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public WithGid.Id id() {
        return this.id;
    }

    public Target.Sidereal target() {
        return this.target;
    }

    public TargetWithId toTargetWithId() {
        return TargetWithId$.MODULE$.apply(this.id(), (Target)this.target());
    }

    public SiderealTargetWithId at(Instant i) {
        LocalDateTime ldt = LocalDateTime.ofInstant(i, ZoneOffset.UTC);
        Epoch epoch = (Epoch)Epoch.Julian$.MODULE$.fromLocalDateTime(ldt).getOrElse(this::$anonfun$1);
        Function1 & Serializable trackingUpdate = (Function1 & Serializable)tracking -> (SiderealTracking)tracking.at(i).fold(() -> SiderealTargetWithId.$anonfun$2$$anonfun$1(tracking), (Function1 & Serializable)c -> {
            Function1 update = (Function1)package.all$.MODULE$.toComposeOps((Object)SiderealTracking$.MODULE$.baseCoordinates().replace(c), (Compose)Compose$.MODULE$.catsInstancesForFunction1()).$greater$greater$greater((Object)SiderealTracking$.MODULE$.epoch().replace((Object)epoch));
            return (SiderealTracking)update.apply(tracking);
        });
        Target.Sidereal sidereal = (Target.Sidereal)Target.Sidereal$.MODULE$.tracking().modify((Function1)trackingUpdate).apply((Object)this.target());
        WithGid.Id id = this.copy$default$1();
        return this.copy(id, sidereal);
    }

    public SiderealTargetWithId copy(WithGid.Id id, Target.Sidereal target) {
        return new SiderealTargetWithId(id, target);
    }

    public WithGid.Id copy$default$1() {
        return this.id();
    }

    public Target.Sidereal copy$default$2() {
        return this.target();
    }

    public WithGid.Id _1() {
        return this.id();
    }

    public Target.Sidereal _2() {
        return this.target();
    }

    private final Epoch $anonfun$1() {
        return this.target().tracking().epoch();
    }

    private static final SiderealTracking $anonfun$2$$anonfun$1(SiderealTracking tracking$1) {
        return tracking$1;
    }
}

