// Copyright (c) 2016-2023 Association of Universities for Research in Astronomy, Inc. (AURA)
// For license information see LICENSE or https://opensource.org/licenses/BSD-3-Clause

package lucuma.schemas.odb

import clue.GraphQLSubquery
import lucuma.schemas.ObservationDB
import io.circe.refined.*


object FluxDensitySubquery extends GraphQLSubquery[ObservationDB]("FluxDensityEntry") {
  import ObservationDB.Scalars._
  ignoreUnusedImportScalars()
  import ObservationDB.Enums._
  ignoreUnusedImportEnums()
  import ObservationDB.Types._
  ignoreUnusedImportTypes()
  override val subquery: String = """
        {
          wavelength {
            picometers
          }
          density
        }
      """
  case class Data(val wavelength: Data.Wavelength, val density: PosBigDecimal)
  object Data {
    case class Wavelength(val picometers: PosInt)
    object Wavelength {
      val picometers: monocle.Lens[Data.Wavelength, PosInt] = monocle.macros.GenLens[Data.Wavelength](_.picometers)
      implicit val eqWavelength: cats.Eq[Data.Wavelength] = cats.Eq.fromUniversalEquals
      implicit val showWavelength: cats.Show[Data.Wavelength] = cats.Show.fromToString
      implicit val jsonDecoderWavelength: io.circe.Decoder[Data.Wavelength] = io.circe.generic.semiauto.deriveDecoder[Data.Wavelength]
    }
    val wavelength: monocle.Lens[Data, Data.Wavelength] = monocle.macros.GenLens[Data](_.wavelength)
    val density: monocle.Lens[Data, PosBigDecimal] = monocle.macros.GenLens[Data](_.density)
    implicit val eqData: cats.Eq[Data] = cats.Eq.fromUniversalEquals
    implicit val showData: cats.Show[Data] = cats.Show.fromToString
    implicit val jsonDecoderData: io.circe.Decoder[Data] = io.circe.generic.semiauto.deriveDecoder[Data]
  }
  val dataDecoder: io.circe.Decoder[Data] = Data.jsonDecoderData
}


