// Copyright (c) 2016-2023 Association of Universities for Research in Astronomy, Inc. (AURA)
// For license information see LICENSE or https://opensource.org/licenses/BSD-3-Clause

package lucuma.schemas.odb

import clue.GraphQLSubquery
import lucuma.schemas.ObservationDB


object GcalStepConfigSubquery extends GraphQLSubquery[ObservationDB]("Gcal") {
  import ObservationDB.Scalars._
  ignoreUnusedImportScalars()
  import ObservationDB.Enums._
  ignoreUnusedImportEnums()
  import ObservationDB.Types._
  ignoreUnusedImportTypes()
  override val subquery: String = """
        {
          continuum
          arcs
          filter
          diffuser
          shutter
        }
      """
  case class Data(val continuum: Option[GcalContinuum] = None, val arcs: List[GcalArc], val filter: GcalFilter, val diffuser: GcalDiffuser, val shutter: GcalShutter)
  object Data {
    val continuum: monocle.Lens[Data, Option[GcalContinuum]] = monocle.macros.GenLens[Data](_.continuum)
    val arcs: monocle.Lens[Data, List[GcalArc]] = monocle.macros.GenLens[Data](_.arcs)
    val filter: monocle.Lens[Data, GcalFilter] = monocle.macros.GenLens[Data](_.filter)
    val diffuser: monocle.Lens[Data, GcalDiffuser] = monocle.macros.GenLens[Data](_.diffuser)
    val shutter: monocle.Lens[Data, GcalShutter] = monocle.macros.GenLens[Data](_.shutter)
    implicit val eqData: cats.Eq[Data] = cats.Eq.fromUniversalEquals
    implicit val showData: cats.Show[Data] = cats.Show.fromToString
    implicit val jsonDecoderData: io.circe.Decoder[Data] = io.circe.generic.semiauto.deriveDecoder[Data]
  }
  val dataDecoder: io.circe.Decoder[Data] = Data.jsonDecoderData
}


