// Copyright (c) 2016-2023 Association of Universities for Research in Astronomy, Inc. (AURA)
// For license information see LICENSE or https://opensource.org/licenses/BSD-3-Clause

package lucuma.schemas.odb

import clue.GraphQLSubquery
import lucuma.schemas.ObservationDB


object GmosCcdModeSubquery extends GraphQLSubquery[ObservationDB]("GmosCcdMode") {
  import ObservationDB.Scalars._
  ignoreUnusedImportScalars()
  import ObservationDB.Enums._
  ignoreUnusedImportEnums()
  import ObservationDB.Types._
  ignoreUnusedImportTypes()
  override val subquery: String = """
        {
          xBin
          yBin
          ampCount
          ampGain
          ampReadMode
        }
      """
  case class Data(val xBin: GmosXBinning, val yBin: GmosYBinning, val ampCount: GmosAmpCount, val ampGain: GmosAmpGain, val ampReadMode: GmosAmpReadMode)
  object Data {
    val xBin: monocle.Lens[Data, GmosXBinning] = monocle.macros.GenLens[Data](_.xBin)
    val yBin: monocle.Lens[Data, GmosYBinning] = monocle.macros.GenLens[Data](_.yBin)
    val ampCount: monocle.Lens[Data, GmosAmpCount] = monocle.macros.GenLens[Data](_.ampCount)
    val ampGain: monocle.Lens[Data, GmosAmpGain] = monocle.macros.GenLens[Data](_.ampGain)
    val ampReadMode: monocle.Lens[Data, GmosAmpReadMode] = monocle.macros.GenLens[Data](_.ampReadMode)
    implicit val eqData: cats.Eq[Data] = cats.Eq.fromUniversalEquals
    implicit val showData: cats.Show[Data] = cats.Show.fromToString
    implicit val jsonDecoderData: io.circe.Decoder[Data] = io.circe.generic.semiauto.deriveDecoder[Data]
  }
  val dataDecoder: io.circe.Decoder[Data] = Data.jsonDecoderData
}


