/*
 * Decompiled with CFR 0.152.
 */
package lucuma.sso.client;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.SemigroupK;
import cats.UnorderedFoldable$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import fs2.Stream;
import java.io.Serializable;
import java.time.Instant;
import lucuma.core.model.User;
import lucuma.sso.client.ApiKey;
import lucuma.sso.client.ApiKey$;
import lucuma.sso.client.SsoClient;
import lucuma.sso.client.SsoJwtClaim;
import lucuma.sso.client.SsoJwtReader;
import org.http4s.Credentials;
import org.http4s.EntityDecoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.QueryParamKeyLike$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Uri;
import org.http4s.client.Client;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SsoClient$ {
    public static final SsoClient$ MODULE$ = new SsoClient$();
    private static volatile boolean bitmap$init$0;

    public <F> F initial(Client<F> httpClient, Uri ssoRoot, SsoJwtReader<F> jwtReader, String serviceJwt, FiniteDuration gracePeriod, GenConcurrent<F, Throwable> evidence$1, Clock<F> evidence$2) {
        return (F)package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance(evidence$1)), (Object)TreeMap$.MODULE$.empty(ApiKey$.MODULE$.OrderingApiKey())), evidence$1).map((Function1 & Serializable)ref -> {
            CIString Bearer = CIString$.MODULE$.apply("Bearer");
            return new SsoClient.AbstractSsoClient<F, SsoClient.UserInfo>(evidence$1, Bearer, evidence$2, gracePeriod, (Ref)ref, httpClient, jwtReader, ssoRoot, serviceJwt){
                private final CIString Bearer$1;
                private final GenConcurrent evidence$1$1;
                private final Clock evidence$2$1;
                private final FiniteDuration gracePeriod$1;
                private final Ref ref$1;
                private final Client httpClient$1;
                private final SsoJwtReader jwtReader$1;
                private final Uri ssoRoot$1;
                private final String serviceJwt$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public F get(Authorization authorization) {
                    Object object;
                    Credentials credentials = authorization.credentials();
                    if (credentials instanceof Credentials.Token) {
                        Credentials.Token token = (Credentials.Token)credentials;
                        CIString cIString = token.authScheme();
                        String ba = token.token();
                        CIString cIString2 = this.Bearer$1;
                        CIString cIString3 = cIString;
                        if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                            object = SsoClient$.lucuma$sso$client$SsoClient$$getUserInfo$1(ba, this.evidence$1$1, this.evidence$2$1, this.gracePeriod$1, this.ref$1, this.httpClient$1, this.jwtReader$1, this.ssoRoot$1, this.serviceJwt$1, this.Bearer$1);
                            return (F)object;
                        }
                    }
                    object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none()), (Applicative)this.evidence$1$1);
                    return (F)object;
                }

                public F find(Request<F> req) {
                    Object object;
                    Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance()));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Authorization a = (Authorization)some.value();
                        object = this.get(a);
                    } else if (None$.MODULE$.equals(option)) {
                        object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none()), (Applicative)this.evidence$1$1);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return object;
                }
                {
                    this.Bearer$1 = Bearer$1;
                    this.evidence$1$1 = evidence$1$1;
                    this.evidence$2$1 = evidence$2$1;
                    this.gracePeriod$1 = gracePeriod$1;
                    this.ref$1 = ref$1;
                    this.httpClient$1 = httpClient$1;
                    this.jwtReader$1 = jwtReader$1;
                    this.ssoRoot$1 = ssoRoot$1;
                    this.serviceJwt$1 = serviceJwt$1;
                    super(evidence$1$1);
                }
            };
        });
    }

    public <F> FiniteDuration initial$default$5() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).minutes();
    }

    private static final Authorization authorization$1(String jwt, CIString Bearer$1) {
        return new Authorization((Credentials)new Credentials.Token(Bearer$1, jwt));
    }

    public static final /* synthetic */ boolean $anonfun$initial$5(Instant t$1, SsoClient.UserInfo x$3) {
        return x$3.claim().expiration().isAfter(t$1);
    }

    private static final Object getCachedApiInfo$1(ApiKey apiKey, Clock evidence$2$1, GenConcurrent evidence$1$1, FiniteDuration gracePeriod$1, Ref ref$1) {
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(package$.MODULE$.Clock().apply(evidence$2$1).realTimeInstant(), (Functor)evidence$1$1).map((Function1 & Serializable)x$1 -> x$1.plusSeconds(gracePeriod$1.toSeconds())), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)t -> package.all$.MODULE$.toFunctorOps(ref$1.get(), (Functor)evidence$1$1).map((Function1 & Serializable)x$2 -> x$2.get((Object)apiKey).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SsoClient$.$anonfun$initial$5(t, x$3)))));
    }

    private static final Request exchangeRequest$1(ApiKey apiKey, Uri ssoRoot$1, String serviceJwt$1, CIString Bearer$1) {
        Method x$1 = Method$.MODULE$.GET();
        Uri x$2 = (Uri)ssoRoot$1.$div("api").$div("v1").$div("exchange-api-key").withQueryParam((Object)"key", (Object)apiKey, ApiKey$.MODULE$.queryParamEncoder(), QueryParamKeyLike$.MODULE$.stringKey());
        List x$3 = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)SsoClient$.authorization$1(serviceJwt$1, Bearer$1), Authorization$.MODULE$.headerInstance())}));
        HttpVersion x$4 = Request$.MODULE$.apply$default$3();
        Stream x$5 = Request$.MODULE$.apply$default$5();
        Vault x$6 = Request$.MODULE$.apply$default$6();
        return Request$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private static final Object fetchApiInfo$1(ApiKey apiKey, Client httpClient$1, GenConcurrent evidence$1$1, SsoJwtReader jwtReader$1, Ref ref$1, Uri ssoRoot$1, String serviceJwt$1, CIString Bearer$1) {
        return package.all$.MODULE$.toFlatMapOps(httpClient$1.expect(SsoClient$.exchangeRequest$1(apiKey, ssoRoot$1, serviceJwt$1, Bearer$1), EntityDecoder$.MODULE$.text(evidence$1$1, EntityDecoder$.MODULE$.text$default$2())), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)jwt -> package.all$.MODULE$.toFlatMapOps(jwtReader$1.decodeClaim((String)jwt), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)claim -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(claim.getUser()), (ApplicativeError)evidence$1$1), (Functor)evidence$1$1).map((Function1 & Serializable)user -> {
            SsoClient.UserInfo info = new SsoClient.UserInfo((User)user, (SsoJwtClaim)claim, SsoClient$.authorization$1(jwt, Bearer$1));
            return new Tuple2(user, (Object)info);
        }), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SsoClient.UserInfo info = (SsoClient.UserInfo)tuple2._2();
            Object object = package.all$.MODULE$.toFunctorOps(ref$1.update((Function1 & Serializable)m -> (TreeMap)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apiKey), (Object)info))), (Functor)evidence$1$1).map((Function1 & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                SsoClient.UserInfo userInfo = info;
                return userInfo;
            });
            return object;
        })));
    }

    private static final Object getOrFetchApiInfo$1(ApiKey apiKey, GenConcurrent evidence$1$1, Clock evidence$2$1, FiniteDuration gracePeriod$1, Ref ref$1, Client httpClient$1, SsoJwtReader jwtReader$1, Uri ssoRoot$1, String serviceJwt$1, CIString Bearer$1) {
        return new OptionT(SsoClient$.getCachedApiInfo$1(apiKey, evidence$2$1, evidence$1$1, gracePeriod$1, ref$1)).getOrElseF((Function0 & Serializable)() -> SsoClient$.fetchApiInfo$1(apiKey, httpClient$1, evidence$1$1, jwtReader$1, ref$1, ssoRoot$1, serviceJwt$1, Bearer$1), (Monad)evidence$1$1);
    }

    private static final Option getApiKey$1(String bearerAuthorization) {
        return ApiKey$.MODULE$.fromString().getOption((Object)bearerAuthorization);
    }

    private static final Object getApiInfo$1(String bearerAuthorization, GenConcurrent evidence$1$1, Clock evidence$2$1, FiniteDuration gracePeriod$1, Ref ref$1, Client httpClient$1, SsoJwtReader jwtReader$1, Uri ssoRoot$1, String serviceJwt$1, CIString Bearer$1) {
        return package.all$.MODULE$.toTraverseOps((Object)SsoClient$.getApiKey$1(bearerAuthorization), UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)apiKey -> SsoClient$.getOrFetchApiInfo$1(apiKey, evidence$1$1, evidence$2$1, gracePeriod$1, ref$1, httpClient$1, jwtReader$1, ssoRoot$1, serviceJwt$1, Bearer$1), (Applicative)evidence$1$1);
    }

    private static final Object getJwtInfo$1(String bearerAuthorization, SsoJwtReader jwtReader$1, GenConcurrent evidence$1$1, CIString Bearer$1) {
        return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(jwtReader$1.decodeClaim(bearerAuthorization), (FlatMap)evidence$1$1).flatMap((Function1 & Serializable)claim -> package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(claim.getUser()), (ApplicativeError)evidence$1$1), (Functor)evidence$1$1).map((Function1 & Serializable)user -> {
            SsoClient.UserInfo info = new SsoClient.UserInfo((User)user, (SsoJwtClaim)claim, SsoClient$.authorization$1(bearerAuthorization, Bearer$1));
            return new Tuple2(user, (Object)info);
        }), (Functor)evidence$1$1).map((Function1 & Serializable)x$6 -> {
            SsoClient.UserInfo info;
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SsoClient.UserInfo userInfo = info = (SsoClient.UserInfo)tuple2._2();
            return userInfo;
        })), (ApplicativeError)evidence$1$1), (ApplicativeError)evidence$1$1), (Functor)evidence$1$1).map((Function1 & Serializable)x$7 -> x$7.toOption());
    }

    public static final Object lucuma$sso$client$SsoClient$$getUserInfo$1(String bearerAuthorization, GenConcurrent evidence$1$1, Clock evidence$2$1, FiniteDuration gracePeriod$1, Ref ref$1, Client httpClient$1, SsoJwtReader jwtReader$1, Uri ssoRoot$1, String serviceJwt$1, CIString Bearer$1) {
        return ((OptionT)package.all$.MODULE$.toSemigroupKOps((Object)new OptionT(SsoClient$.getApiInfo$1(bearerAuthorization, evidence$1$1, evidence$2$1, gracePeriod$1, ref$1, httpClient$1, jwtReader$1, ssoRoot$1, serviceJwt$1, Bearer$1)), (SemigroupK)OptionT$.MODULE$.catsDataMonoidKForOptionT((Monad)evidence$1$1)).$less$plus$greater((Object)new OptionT(SsoClient$.getJwtInfo$1(bearerAuthorization, jwtReader$1, evidence$1$1, Bearer$1)))).value();
    }

    private SsoClient$() {
    }
}

