/*
 * Decompiled with CFR 0.152.
 */
package lucuma.sso.client.util;

import cats.Applicative;
import cats.Functor;
import cats.data.EitherT;
import cats.effect.kernel.GenConcurrent;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.http4s.DecodeResult$;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.MalformedMessageBodyFailure;
import scala.DummyImplicit$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class GpgPublicKeyReader$ {
    public static final GpgPublicKeyReader$ MODULE$ = new GpgPublicKeyReader$();

    public Either<Throwable, PublicKey> publicKey(String pgpArmorText) {
        Left left;
        try {
            InputStream is = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(pgpArmorText.getBytes("US-ASCII")));
            PGPPublicKeyRingCollection kr = new PGPPublicKeyRingCollection(is, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey pk = ((PGPPublicKeyRing)kr.iterator().next()).getPublicKey();
            JcaPGPKeyConverter kc = new JcaPGPKeyConverter();
            left = package$.MODULE$.Right().apply((Object)kc.getPublicKey(pk));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left2 = package$.MODULE$.Left().apply((Object)e);
            left = left2;
        }
        return left;
    }

    public Either<Throwable, String> armorText(PublicKey publicKey) {
        Left left;
        try {
            JcaPGPKeyConverter kc = new JcaPGPKeyConverter();
            PGPPublicKey pk = kc.getPGPPublicKey(3, publicKey, new Date());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArmoredOutputStream aos = new ArmoredOutputStream((OutputStream)baos, new Hashtable());
            pk.encode((OutputStream)aos, true);
            aos.flush();
            aos.close();
            baos.close();
            left = package$.MODULE$.Right().apply((Object)new String(baos.toByteArray(), "US-ASCII"));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left2 = package$.MODULE$.Left().apply((Object)e);
            left = left2;
        }
        return left;
    }

    public <F> EntityDecoder<F, PublicKey> entityDecoder(GenConcurrent<F, Throwable> evidence$1) {
        return EntityDecoder$.MODULE$.text(evidence$1, EntityDecoder$.MODULE$.text$default$2()).map((Function1 & Serializable)pgpArmorText -> MODULE$.publicKey((String)pgpArmorText), evidence$1).flatMapR((Function1 & Serializable)x0$1 -> {
            EitherT eitherT;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                eitherT = DecodeResult$.MODULE$.failure(cats.effect.package$.MODULE$.Concurrent().apply(evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).pure((Object)new MalformedMessageBodyFailure("Invalid public key.", (Option)new Some((Object)err))), (Functor)evidence$1);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                PublicKey pubKey = (PublicKey)right.value();
                eitherT = DecodeResult$.MODULE$.success(ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)pubKey), (Applicative)evidence$1), (Functor)evidence$1);
            } else {
                throw new MatchError((Object)either);
            }
            return eitherT;
        }, evidence$1);
    }

    public <F> EntityEncoder<F, PublicKey> entityEncoder() {
        return EntityEncoder$.MODULE$.apply(EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1())).contramap((Function1 & Serializable)pubKey -> {
            String armorText;
            Either<Throwable, String> either = MODULE$.armorText((PublicKey)pubKey);
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                throw err;
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Right right = (Right)either;
            String string = armorText = (String)right.value();
            return string;
        });
    }

    private GpgPublicKeyReader$() {
    }
}

