/*
 * Decompiled with CFR 0.152.
 */
package lucuma.sso.client;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.OptionT$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.OptionIdOps$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import lucuma.core.model.ServiceUser;
import lucuma.core.model.StandardUser;
import lucuma.core.model.User;
import lucuma.sso.client.SsoJwtClaim;
import lucuma.sso.client.SsoJwtClaim$;
import lucuma.sso.client.SsoJwtReader;
import lucuma.sso.client.SsoJwtReader$;
import lucuma.sso.client.util.JwtDecoder;
import org.http4s.Credentials;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.InvalidMessageBodyFailure$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import pdi.jwt.JwtClaim;
import pdi.jwt.exceptions.JwtException;
import scala.DummyImplicit$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class SsoJwtReader$
implements Serializable {
    private static final String JwtCookie;
    private static final String lucumaUser;
    public static final SsoJwtReader$ MODULE$;

    private SsoJwtReader$() {
    }

    static {
        MODULE$ = new SsoJwtReader$();
        JwtCookie = "lucuma-jwt";
        lucumaUser = SsoJwtClaim$.MODULE$.lucumaUser();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SsoJwtReader$.class);
    }

    public String JwtCookie() {
        return JwtCookie;
    }

    public String lucumaUser() {
        return lucumaUser;
    }

    public <F> SsoJwtReader<F> apply(JwtDecoder<F> jwtDecoder, GenConcurrent<F, Throwable> evidence$1) {
        return new SsoJwtReader<F>(evidence$1, jwtDecoder){
            private final JwtDecoder jwtDecoder$3;
            private final GenConcurrent evidence$1$3;
            private final EntityDecoder entityDecoder;
            private final CIString Bearer;
            {
                this.jwtDecoder$3 = jwtDecoder$1;
                this.evidence$1$3 = evidence$1$1;
                this.entityDecoder = EntityDecoder$.MODULE$.text(evidence$1$1, EntityDecoder$.MODULE$.text$default$2()).flatMapR(arg_0 -> SsoJwtReader$.lucuma$sso$client$SsoJwtReader$$anon$1$$_$$lessinit$greater$$anonfun$1(jwtDecoder$1, evidence$1$1, arg_0), (Monad)evidence$1$1);
                this.Bearer = CIString$.MODULE$.apply("Bearer");
            }

            public EntityDecoder entityDecoder() {
                return this.entityDecoder;
            }

            public CIString Bearer() {
                return this.Bearer;
            }

            public Object decodeClaim(String jwt) {
                return implicits$.MODULE$.toFunctorOps(this.jwtDecoder$3.decode(jwt), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeClaim$$anonfun$1);
            }

            public Object decodeUser(String jwt) {
                return implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.decodeClaim(jwt), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeUser$$anonfun$1), (FlatMap)this.evidence$1$3).flatMap((Function1 & Serializable)_$6 -> {
                    Either either = implicits$.MODULE$.catsSyntaxEither(_$6);
                    return EitherOps$.MODULE$.liftTo$extension(either, (ApplicativeError)this.evidence$1$3);
                });
            }

            public Object decodeStandardUser(String jwt) {
                return implicits$.MODULE$.toFlatMapOps(this.decodeUser(jwt), (FlatMap)this.evidence$1$3).flatMap((Function1 & Serializable)x$1 -> {
                    User user = x$1;
                    if (user instanceof StandardUser) {
                        StandardUser u = (StandardUser)user;
                        StandardUser standardUser = (StandardUser)implicits$.MODULE$.catsSyntaxApplicativeId((Object)u);
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)standardUser, (Applicative)this.evidence$1$3);
                    }
                    return package$.MODULE$.Concurrent().apply(this.evidence$1$3, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)new RuntimeException("Not a standard user."));
                });
            }

            public Object attemptFindClaim(Request req) {
                return implicits$.MODULE$.toFlatMapOps(this.findBearerAuthorization(req), (FlatMap)this.evidence$1$3).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        Option option2 = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none());
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)option2, (Applicative)this.evidence$1$3);
                    }
                    if (option instanceof Some) {
                        String c = (String)((Some)option).value();
                        return implicits$.MODULE$.toFunctorOps(this.jwtDecoder$3.attemptDecode(c), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$attemptFindClaim$$anonfun$1$$anonfun$1);
                    }
                    throw new MatchError((Object)option);
                });
            }

            public Object findBearerAuthorization(Request req) {
                Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance())).collect((PartialFunction)new Serializable(this){
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Authorization x) {
                        Authorization authorization;
                        Credentials credentials;
                        Authorization authorization2 = x;
                        if (authorization2 != null && (credentials = (authorization = Authorization$.MODULE$.unapply(authorization2))._1()) instanceof Credentials.Token) {
                            Credentials.Token token = Credentials.Token$.MODULE$.unapply((Credentials.Token)credentials);
                            CIString cIString = token._1();
                            String string = token._2();
                            CIString cIString2 = this.$outer.Bearer();
                            CIString cIString3 = cIString;
                            if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                                String token2 = string;
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Authorization x, Function1 function1) {
                        Authorization authorization;
                        Credentials credentials;
                        Authorization authorization2 = x;
                        if (authorization2 != null && (credentials = (authorization = Authorization$.MODULE$.unapply(authorization2))._1()) instanceof Credentials.Token) {
                            Credentials.Token token = Credentials.Token$.MODULE$.unapply((Credentials.Token)credentials);
                            CIString cIString = token._1();
                            String string = token._2();
                            CIString cIString2 = this.$outer.Bearer();
                            CIString cIString3 = cIString;
                            if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                                String token2 = string;
                                return token2;
                            }
                        }
                        return function1.apply((Object)x);
                    }
                }));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)this.evidence$1$3);
            }

            public Object findClaim(Request req) {
                return OptionT$.MODULE$.apply(this.findBearerAuthorization(req)).flatMapF((Function1 & Serializable)token -> implicits$.MODULE$.toFunctorOps(this.jwtDecoder$3.decodeOption((String)token), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$findClaim$$anonfun$1$$anonfun$1), (Monad)this.evidence$1$3).value();
            }

            public Object findClaim(Response res) {
                return res.as((MonadError)this.evidence$1$3, this.entityDecoder());
            }

            public Object findUser(Request req) {
                return implicits$.MODULE$.toFunctorOps(this.findClaim(req), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$findUser$$anonfun$1);
            }

            public Object findServiceUser(Request req) {
                return implicits$.MODULE$.toFunctorOps(this.findUser(req), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$findServiceUser$$anonfun$1);
            }

            public Object findStandardUser(Request req) {
                return implicits$.MODULE$.toFunctorOps(this.findUser(req), (Functor)this.evidence$1$3).map(SsoJwtReader$::lucuma$sso$client$SsoJwtReader$$anon$1$$_$findStandardUser$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{lucuma$sso$client$SsoJwtReader$$anon$1$$_$$lessinit$greater$$anonfun$1(lucuma.sso.client.util.JwtDecoder cats.effect.kernel.GenConcurrent java.lang.String ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeClaim$$anonfun$1(pdi.jwt.JwtClaim ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeUser$$anonfun$1(lucuma.sso.client.SsoJwtClaim ), decodeUser$$anonfun$2(scala.util.Either ), decodeStandardUser$$anonfun$1(lucuma.core.model.User ), attemptFindClaim$$anonfun$1(scala.Option ), findClaim$$anonfun$1(java.lang.String ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$findUser$$anonfun$1(scala.Option ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$findServiceUser$$anonfun$1(scala.Option ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$findStandardUser$$anonfun$1(scala.Option ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$attemptFindClaim$$anonfun$1$$anonfun$1(scala.util.Either ), lucuma$sso$client$SsoJwtReader$$anon$1$$_$findClaim$$anonfun$1$$anonfun$1(scala.Option )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ EitherT lucuma$sso$client$SsoJwtReader$$anon$1$$_$$lessinit$greater$$anonfun$1(JwtDecoder jwtDecoder$2, GenConcurrent evidence$1$2, String token) {
        return EitherT$.MODULE$.apply(jwtDecoder$2.attemptDecode(token)).map((Function1 & Serializable)_$3 -> SsoJwtClaim$.MODULE$.apply((JwtClaim)_$3), (Functor)evidence$1$2).leftMap((Function1 & Serializable)x$1 -> {
            JwtException jwtException = x$1;
            if (jwtException != null) {
                JwtException e = jwtException;
                return InvalidMessageBodyFailure$.MODULE$.apply("Invalid or missing JWT.", (Option)Some$.MODULE$.apply((Object)e));
            }
            throw new MatchError((Object)jwtException);
        }, (Functor)evidence$1$2);
    }

    public static final /* synthetic */ SsoJwtClaim lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeClaim$$anonfun$1(JwtClaim _$4) {
        return SsoJwtClaim$.MODULE$.apply(_$4);
    }

    public static final /* synthetic */ Either lucuma$sso$client$SsoJwtReader$$anon$1$$_$decodeUser$$anonfun$1(SsoJwtClaim _$5) {
        return _$5.getUser();
    }

    public static final /* synthetic */ Option lucuma$sso$client$SsoJwtReader$$anon$1$$_$attemptFindClaim$$anonfun$1$$anonfun$1(Either _$7) {
        Either either = (Either)implicits$.MODULE$.catsSyntaxOptionId((Object)_$7.map((Function1 & Serializable)_$8 -> SsoJwtClaim$.MODULE$.apply((JwtClaim)_$8)));
        return OptionIdOps$.MODULE$.some$extension((Object)either);
    }

    public static final /* synthetic */ Option lucuma$sso$client$SsoJwtReader$$anon$1$$_$findClaim$$anonfun$1$$anonfun$1(Option _$9) {
        return _$9.map((Function1 & Serializable)_$10 -> SsoJwtClaim$.MODULE$.apply((JwtClaim)_$10));
    }

    public static final /* synthetic */ Option lucuma$sso$client$SsoJwtReader$$anon$1$$_$findUser$$anonfun$1(Option _$11) {
        return _$11.flatMap((Function1 & Serializable)_$12 -> _$12.getUser().toOption());
    }

    public static final /* synthetic */ Option lucuma$sso$client$SsoJwtReader$$anon$1$$_$findServiceUser$$anonfun$1(Option _$13) {
        return _$13.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(User x) {
                User user = x;
                if (user instanceof ServiceUser) {
                    ServiceUser u = (ServiceUser)user;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(User x, Function1 function1) {
                User user = x;
                if (user instanceof ServiceUser) {
                    ServiceUser u = (ServiceUser)user;
                    return u;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public static final /* synthetic */ Option lucuma$sso$client$SsoJwtReader$$anon$1$$_$findStandardUser$$anonfun$1(Option _$14) {
        return _$14.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(User x) {
                User user = x;
                if (user instanceof StandardUser) {
                    StandardUser u = (StandardUser)user;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(User x, Function1 function1) {
                User user = x;
                if (user instanceof StandardUser) {
                    StandardUser u = (StandardUser)user;
                    return u;
                }
                return function1.apply((Object)x);
            }
        });
    }
}

