/*
 * Decompiled with CFR 0.152.
 */
package lucuma.sso.client.util;

import cats.Applicative;
import cats.Functor;
import cats.effect.kernel.GenConcurrent;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.http4s.DecodeResult$;
import org.http4s.EntityDecoder;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.MalformedMessageBodyFailure$;
import scala.DummyImplicit$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class GpgPublicKeyReader$
implements Serializable {
    public static final GpgPublicKeyReader$ MODULE$ = new GpgPublicKeyReader$();

    private GpgPublicKeyReader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GpgPublicKeyReader$.class);
    }

    public Either<Throwable, PublicKey> publicKey(String pgpArmorText) {
        Left left;
        try {
            InputStream is = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(pgpArmorText.getBytes("US-ASCII")));
            PGPPublicKeyRingCollection kr = new PGPPublicKeyRingCollection(is, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey pk = ((PGPPublicKeyRing)kr.iterator().next()).getPublicKey();
            JcaPGPKeyConverter kc = new JcaPGPKeyConverter();
            left = package$.MODULE$.Right().apply((Object)kc.getPublicKey(pk));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                left = package$.MODULE$.Left().apply((Object)e);
            }
            throw throwable;
        }
        return left;
    }

    public Either<Throwable, String> armorText(PublicKey publicKey) {
        Left left;
        try {
            JcaPGPKeyConverter kc = new JcaPGPKeyConverter();
            PGPPublicKey pk = kc.getPGPPublicKey(3, publicKey, new Date());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArmoredOutputStream aos = new ArmoredOutputStream((OutputStream)baos, new Hashtable());
            pk.encode((OutputStream)aos, true);
            aos.flush();
            aos.close();
            baos.close();
            left = package$.MODULE$.Right().apply((Object)new String(baos.toByteArray(), "US-ASCII"));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                left = package$.MODULE$.Left().apply((Object)e);
            }
            throw throwable;
        }
        return left;
    }

    public <F> EntityDecoder<F, PublicKey> entityDecoder(GenConcurrent<F, Throwable> evidence$1) {
        return EntityDecoder$.MODULE$.text(evidence$1, EntityDecoder$.MODULE$.text$default$2()).map((Function1 & Serializable)pgpArmorText -> MODULE$.publicKey((String)pgpArmorText), evidence$1).flatMapR((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Throwable err = (Throwable)((Left)either).value();
                return DecodeResult$.MODULE$.failure(cats.effect.package$.MODULE$.Concurrent().apply(evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).pure((Object)MalformedMessageBodyFailure$.MODULE$.apply("Invalid public key.", (Option)Some$.MODULE$.apply((Object)err))), (Functor)evidence$1);
            }
            if (either instanceof Right) {
                PublicKey pubKey = (PublicKey)((Right)either).value();
                PublicKey publicKey = (PublicKey)package.all$.MODULE$.catsSyntaxApplicativeId((Object)pubKey);
                return DecodeResult$.MODULE$.success(ApplicativeIdOps$.MODULE$.pure$extension((Object)publicKey, (Applicative)evidence$1), (Functor)evidence$1);
            }
            throw new MatchError((Object)either);
        }, evidence$1);
    }

    public <F> EntityEncoder<F, PublicKey> entityEncoder() {
        return EntityEncoder$.MODULE$.apply(EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1())).contramap((Function1 & Serializable)pubKey -> {
            Either<Throwable, String> either = MODULE$.armorText((PublicKey)pubKey);
            if (either instanceof Left) {
                Throwable err = (Throwable)((Left)either).value();
                throw err;
            }
            if (either instanceof Right) {
                String armorText = (String)((Right)either).value();
                return armorText;
            }
            throw new MatchError(either);
        });
    }
}

