/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.concrete.sql;

import com.google.common.io.CharStreams;
import edu.jhu.hlt.acute.archivers.Archivable;
import edu.jhu.hlt.acute.archivers.tar.TarArchiver;
import edu.jhu.hlt.concrete.Communication;
import edu.jhu.hlt.concrete.serialization.archiver.ArchivableCommunication;
import edu.jhu.hlt.concrete.sql.SQLiteImpl;
import edu.jhu.hlt.utilt.ex.LoggedUncaughtExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationIDListRetriever
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommunicationIDListRetriever.class);
    private final SQLiteImpl db;
    private final TarArchiver arch;

    public CommunicationIDListRetriever(Path db, Path output) {
        try {
            TarArchiver _tarArchiver;
            SQLiteImpl _sQLiteImpl;
            this.db = _sQLiteImpl = new SQLiteImpl(db);
            boolean _exists = Files.exists(output, new LinkOption[0]);
            if (_exists) {
                throw new IllegalArgumentException("Output path exists. Not overwriting.");
            }
            OutputStream _newOutputStream = Files.newOutputStream(output, new OpenOption[0]);
            GzipCompressorOutputStream _gzipCompressorOutputStream = new GzipCompressorOutputStream(_newOutputStream);
            this.arch = _tarArchiver = new TarArchiver(_gzipCompressorOutputStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void close() throws IOException, SQLException {
        this.db.close();
        this.arch.close();
    }

    public void query(Path idFile) {
        try {
            BufferedReader br = Files.newBufferedReader(idFile, StandardCharsets.UTF_8);
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String line) {
                    try {
                        Optional<Communication> comm = CommunicationIDListRetriever.this.db.get(line);
                        boolean _isPresent = comm.isPresent();
                        if (_isPresent) {
                            Communication act = comm.get();
                            ArchivableCommunication _archivableCommunication = new ArchivableCommunication(act);
                            CommunicationIDListRetriever.this.arch.addEntry((Archivable)_archivableCommunication);
                        } else {
                            LOGGER.info("Did not find comm: {}", (Object)line);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            CharStreams.readLines((Readable)br).forEach(_function);
            br.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        try {
            boolean _not_1;
            boolean _not;
            LoggedUncaughtExceptionHandler _loggedUncaughtExceptionHandler = new LoggedUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)_loggedUncaughtExceptionHandler);
            Path db = Paths.get(args[0], new String[0]);
            Path output = Paths.get(args[1], new String[0]);
            Path fileWithIDsPerLine = Paths.get(args[2], new String[0]);
            boolean _exists = Files.exists(db, new LinkOption[0]);
            boolean bl = _not = !_exists;
            if (_not) {
                LOGGER.info("Database does not exist.");
                return;
            }
            boolean _exists_1 = Files.exists(fileWithIDsPerLine, new LinkOption[0]);
            boolean bl2 = _not_1 = !_exists_1;
            if (_not_1) {
                LOGGER.info("File with IDs does not exist.");
                return;
            }
            boolean _exists_2 = Files.exists(output, new LinkOption[0]);
            if (_exists_2) {
                LOGGER.info("Output path exists. Not overwriting.");
                return;
            }
            CommunicationIDListRetriever retr = new CommunicationIDListRetriever(db, output);
            retr.query(fileWithIDsPerLine);
            retr.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

