/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.hlt.concrete.sql;

import edu.jhu.hlt.concrete.Communication;
import edu.jhu.hlt.concrete.serialization.TarGzCompactCommunicationSerializer;
import edu.jhu.hlt.concrete.util.ConcreteException;
import edu.jhu.hlt.utilt.ex.LoggedUncaughtExceptionHandler;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteImpl
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteImpl.class);
    private static final TarGzCompactCommunicationSerializer cs = new TarGzCompactCommunicationSerializer();
    private final Path p;
    private final Connection conn;
    private final PreparedStatement ps;
    private final Set<String> idSet;

    public SQLiteImpl(String pathStr) {
        this(Paths.get(pathStr, new String[0]));
    }

    public SQLiteImpl(Path p) {
        try {
            boolean _equals;
            this.p = p;
            boolean exists = Files.exists(p, new LinkOption[0]);
            if (!exists) {
                LOGGER.info("Creating db file at: {}", (Object)p.toAbsolutePath().toString());
                Files.createFile(p, new FileAttribute[0]);
            }
            Class.forName("org.sqlite.JDBC");
            String _string = p.toAbsolutePath().toString();
            String _plus = "jdbc:sqlite:" + _string;
            this.conn = DriverManager.getConnection(_plus);
            long _size = Files.size(p);
            boolean bl = _equals = _size == 0L;
            if (_equals) {
                LOGGER.info("Init db file at: {}", (Object)p.toAbsolutePath().toString());
                this.init();
            }
            this.conn.setAutoCommit(false);
            this.ps = this.conn.prepareStatement("INSERT INTO concrete VALUES (?, ?, ?)");
            HashSet<String> _hashSet = new HashSet<String>();
            this.idSet = _hashSet;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void init() {
        try {
            Statement stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS concrete (id STRING PRIMARY KEY, type STRING, concrete_bytes)");
            stmt.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void drop() {
        try {
            Statement stmt = this.conn.createStatement();
            stmt.executeUpdate("DROP TABLE IF EXISTS concrete");
            stmt.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.ps.close();
        this.conn.commit();
        this.conn.close();
    }

    public Optional<Communication> get(String id) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("SELECT concrete_bytes FROM concrete WHERE ID = ?");
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            Optional<Communication> _xifexpression = null;
            boolean _next = rs.next();
            _xifexpression = _next ? Optional.of(cs.fromBytes(rs.getBytes("concrete_bytes"))) : Optional.empty();
            Optional<Communication> toRet = _xifexpression;
            rs.close();
            stmt.close();
            return toRet;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void add(Communication c) {
        try {
            boolean _not;
            String oid = c.getId();
            String _xifexpression = null;
            boolean _contains = this.idSet.contains(oid);
            if (_contains) {
                String _xblockexpression = null;
                LOGGER.info("{} already ingested; appending duplicate.", (Object)oid);
                _xifexpression = _xblockexpression = oid + ".duplicate";
            } else {
                _xifexpression = oid;
            }
            String cid = _xifexpression;
            boolean _add = this.idSet.add(cid);
            boolean bl = _not = !_add;
            if (_not) {
                throw new IllegalArgumentException("somehow already added: " + cid);
            }
            this.ps.setString(1, cid);
            this.ps.setString(2, c.getType());
            this.ps.setBytes(3, cs.toBytes(c));
            this.ps.addBatch();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public int[] execute() {
        try {
            return this.ps.executeBatch();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void ingest(Path p) throws ConcreteException {
        try {
            InputStream is = Files.newInputStream(p, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            Iterator iter = cs.fromTarGz((InputStream)bis);
            Procedures.Procedure1<Communication> _function = new Procedures.Procedure1<Communication>(){

                public void apply(Communication comm) {
                    SQLiteImpl.this.add(comm);
                }
            };
            IteratorExtensions.forEach((Iterator)iter, (Procedures.Procedure1)_function);
            bis.close();
            is.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        try {
            LoggedUncaughtExceptionHandler _loggedUncaughtExceptionHandler = new LoggedUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)_loggedUncaughtExceptionHandler);
            Path db = Paths.get(args[0], new String[0]);
            Path input = Paths.get(args[1], new String[0]);
            SQLiteImpl impl = new SQLiteImpl(db);
            impl.ingest(input);
            impl.execute();
            impl.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

