/*
 * Copyright 2017 Karlsruhe Institute of Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package edu.kit.datamanager.entities.repo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import lombok.Data;

/**
 *
 * @author jejkal
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@XmlAccessorType(XmlAccessType.FIELD)
public class GeoLocation{

  private long id;
  @XmlElement(name = "geoLocationPoint")
  private Point point;
  @XmlElement(name = "geoLocationBox")
  private Box box;
  @XmlElement(name = "geoLocationPolygon")
  private Polygon polygon;
  @XmlElement(name = "geoLocationPlace")
  private String place;

  /**
   * Basic factory method.
   *
   * @param place A place location
   *
   * @return A new instance of GeoLocation
   */
  public static GeoLocation factoryGeoLocation(String place){
    GeoLocation result = new GeoLocation();
    result.setPlace(place);
    return result;
  }
}
