/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.configuration;

import edu.kit.datamanager.annotations.SearchIndex;
import edu.kit.datamanager.annotations.SearchIndexUrl;
import java.net.URL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
@Validated
public class SearchConfiguration {
    @Value(value="${repo.search.enabled:FALSE}")
    private boolean searchEnabled;
    @Value(value="${repo.search.url:http://localhost:9200}")
    @SearchIndexUrl
    private URL url;
    @Value(value="${repo.search.index:*}")
    @SearchIndex
    private String index;

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getIndex() {
        return this.index;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchConfiguration)) {
            return false;
        }
        SearchConfiguration other = (SearchConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSearchEnabled() != other.isSearchEnabled()) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSearchEnabled() ? 79 : 97);
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    public String toString() {
        return "SearchConfiguration(searchEnabled=" + this.isSearchEnabled() + ", url=" + this.getUrl() + ", index=" + this.getIndex() + ")";
    }
}

