/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.kit.datamanager.configuration.SearchConfiguration;
import edu.kit.datamanager.util.ElasticSearchUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.converters.models.PageableAsQueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.gateway.mvc.ProxyExchange;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/"})
@Schema(description="Search controller for Elastic integration")
@ConditionalOnExpression(value="${repo.search.enabled:false}")
public class SearchController {
    static final Logger LOG = LoggerFactory.getLogger(SearchController.class);
    @Autowired
    private SearchConfiguration searchConfiguration;
    public static final String POST_FILTER = "post_filter";

    @Operation(operationId="search", summary="Search for resources.", description="Search for resources using the configured Elastic backend. This endpoint serves as direct proxy to the RESTful endpoint of Elastic. In the body, a query document following the Elastic query format has to be provided. Format errors are returned directly from Elastic. This endpoint also supports authentication and authorization. User information obtained via JWT is applied to the provided query as post filter. If a post filter was already provided with the query it will be replaced. Furthermore, this endpoint supports pagination. 'page' and 'size' query parameters are translated into the Elastic attributes 'from' and 'size' automatically, if not already provided within the query by the caller.", security={@SecurityRequirement(name="bearer-jwt")})
    @RequestMapping(value={"/_search"}, method={RequestMethod.POST})
    @ResponseBody
    @PageableAsQueryParam
    public ResponseEntity<?> proxy(@RequestBody JsonNode body, ProxyExchange<JsonNode> proxy, @Parameter(hidden=true) Pageable pgbl) throws Exception {
        LOG.trace("Provided Elastic query: '{}'", (Object)body.toString());
        ObjectNode on = (ObjectNode)body;
        ElasticSearchUtil.addPaginationInformation(on, pgbl.getPageNumber(), pgbl.getPageSize());
        ElasticSearchUtil.buildPostFilter(on);
        return proxy.uri(this.searchConfiguration.getUrl() + "/" + this.searchConfiguration.getIndex() + "/_search").post();
    }

    @Operation(operationId="search", summary="Search for resources.", description="This endpoint is identical to _search but kept for legacy reasons. In future implementations _search should be used as Elatic also offers _search and some libraries expect _search as default endpoint.", security={@SecurityRequirement(name="bearer-jwt")})
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    @ResponseBody
    @PageableAsQueryParam
    public ResponseEntity<?> proxy_legacy(@RequestBody JsonNode body, ProxyExchange<JsonNode> proxy, @Parameter(hidden=true) Pageable pgbl) throws Exception {
        return this.proxy(body, proxy, pgbl);
    }
}

