/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.dao;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;

public class StringFieldSpecification<C> {
    public static <C> Specification<C> createSpecification(String fieldName, String fieldValue, boolean exactMatch) {
        Specification newSpec = Specification.where(null);
        if (fieldName == null || fieldValue == null) {
            return newSpec;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            query.distinct(true);
            if (!exactMatch) {
                return builder.like((Expression)root.get(fieldName), "%" + fieldValue + "%");
            }
            return builder.equal((Expression)root.get(fieldName), (Object)fieldValue);
        };
    }

    public static <C> Specification<C> createSpecification(String fieldName, String ... fieldValues) {
        Specification newSpec = Specification.where(null);
        if (fieldName == null || fieldValues == null || fieldValues.length == 0) {
            return newSpec;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            query.distinct(true);
            return builder.and(new Predicate[]{root.get(fieldName).in((Object[])fieldValues)});
        };
    }
}

