/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.entities;

import edu.kit.datamanager.annotations.Searchable;
import edu.kit.datamanager.annotations.SecureUpdate;
import edu.kit.datamanager.entities.BaseEnum;
import edu.kit.datamanager.util.EnumUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.validation.constraints.NotBlank;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Objects;
import java.util.UUID;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Identifier {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @SecureUpdate(value={"FORBIDDEN"})
    @Searchable
    private Long id;
    @NotBlank
    private String value;
    @Enumerated(value=EnumType.STRING)
    private IDENTIFIER_TYPE identifierType;

    public static Identifier factoryIdentifier(String value, IDENTIFIER_TYPE type) {
        Identifier result = new Identifier();
        result.value = value;
        result.identifierType = type;
        return result;
    }

    public static Identifier factoryInternalIdentifier(String identifier) {
        Identifier result = new Identifier();
        result.setIdentifierType(IDENTIFIER_TYPE.INTERNAL);
        result.setValue(identifier);
        return result;
    }

    public static Identifier factoryInternalIdentifier() {
        return Identifier.factoryInternalIdentifier(UUID.randomUUID().toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return EnumUtils.equals(this.identifierType, other.identifierType);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        hash = 79 * hash + Objects.hashCode(this.value);
        hash = 79 * hash + EnumUtils.hashCode(this.identifierType);
        return hash;
    }

    public Long getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public IDENTIFIER_TYPE getIdentifierType() {
        return this.identifierType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setIdentifierType(IDENTIFIER_TYPE identifierType) {
        this.identifierType = identifierType;
    }

    public String toString() {
        return "Identifier(id=" + this.getId() + ", value=" + this.getValue() + ", identifierType=" + this.getIdentifierType() + ")";
    }

    public static enum IDENTIFIER_TYPE implements BaseEnum
    {
        ARK("ARK"),
        AR_XIV("arXiv"),
        BIBCODE("bibcode"),
        DOI("DOI"),
        EAN_13("EAN13"),
        EISSN("EISSN"),
        HANDLE("Handle"),
        IGSN("IGSN"),
        ISBN("ISBN"),
        ISSN("ISSN"),
        ISTC("ISTC"),
        LISSN("LISSN"),
        LSID("LSID"),
        PMID("PMID"),
        PURL("PURL"),
        UPC("UPC"),
        URL("URL"),
        URN("URN"),
        W_3_ID("w3id"),
        INTERNAL("INTERNAL"),
        OTHER("OTHER");

        private final String value;

        private IDENTIFIER_TYPE(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

