/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class JwtServiceToken
extends JwtAuthenticationToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtServiceToken.class);
    public static final String SELF_SERVICE_NAME = "SELF";
    private String[] sources;

    public JwtServiceToken(String token, Collection<? extends GrantedAuthority> authorities) {
        super(token, authorities);
    }

    @Override
    public Class getClassForClaim(String claim) {
        if ("groups".equals(claim)) {
            return List.class;
        }
        return String.class;
    }

    @Override
    public String[] getSupportedClaims() {
        return new String[]{"servicename", "sources", "groups"};
    }

    @Override
    public void setValueFromClaim(String claim, Object value) {
        switch (claim) {
            case "servicename": {
                this.setPrincipalName((String)value);
                break;
            }
            case "sources": {
                this.parseSources((String)value);
                break;
            }
            case "groups": {
                this.setGroups((List)value);
                break;
            }
            default: {
                LOGGER.warn("Invalid claim {} with value {} received. Claim will be ignored.", (Object)claim, value);
            }
        }
    }

    private void parseSources(String value) {
        if (value == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.sources = (String[])mapper.readValue(value, String[].class);
        }
        catch (IOException ex) {
            throw new InvalidAuthenticationException("Failed to read sources from claim value " + value + ".");
        }
    }

    @Override
    public void validate() throws InvalidAuthenticationException {
        if (this.sources == null && !SELF_SERVICE_NAME.equals(this.getPrincipal())) {
            LOGGER.warn("No sources provided in service token for service '" + this.getPrincipal() + ". Possible security risk!");
        }
    }

    public String[] getSources() {
        return this.sources;
    }

    @Override
    public JwtAuthenticationToken.TOKEN_TYPE getTokenType() {
        return JwtAuthenticationToken.TOKEN_TYPE.SERVICE;
    }
}

