/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class JwtUserToken
extends JwtAuthenticationToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtUserToken.class);
    private String firstname = null;
    private String lastname = null;
    private String email = null;

    public JwtUserToken(String token, Collection<? extends GrantedAuthority> authorities) {
        super(token, authorities);
    }

    @Override
    public String[] getSupportedClaims() {
        return new String[]{"username", "firstname", "lastname", "email", "groups"};
    }

    @Override
    public Class getClassForClaim(String claim) {
        if ("groups".equals(claim)) {
            return List.class;
        }
        return String.class;
    }

    @Override
    public void setValueFromClaim(String claim, Object value) {
        switch (claim) {
            case "username": {
                this.setPrincipalName((String)value);
                break;
            }
            case "firstname": {
                this.firstname = (String)value;
                break;
            }
            case "lastname": {
                this.lastname = (String)value;
                break;
            }
            case "email": {
                this.email = (String)value;
                break;
            }
            case "groups": {
                this.setGroups((List)value);
                break;
            }
            default: {
                LOGGER.warn("Invalid claim {} with value {} received. Claim will be ignored.", (Object)claim, value);
            }
        }
    }

    @Override
    public void validate() throws InvalidAuthenticationException {
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    @Override
    public JwtAuthenticationToken.TOKEN_TYPE getTokenType() {
        return JwtAuthenticationToken.TOKEN_TYPE.USER;
    }
}

