/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.util.StandardCharset;
import edu.kit.datamanager.entities.RepoServiceRole;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import io.jsonwebtoken.Jwts;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class NoAuthenticationFilter
extends OncePerRequestFilter {
    private final String secretKey;
    private final AuthenticationManager authenticationManager;
    private static final String USERS_GROUP = "USERS";

    public NoAuthenticationFilter(String secretKey, AuthenticationManager authenticationManager) {
        this.secretKey = secretKey;
        this.authenticationManager = authenticationManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException, AuthenticationException {
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        claimsMap.put("groups", Arrays.asList(USERS_GROUP));
        claimsMap.put("tokenType", JwtAuthenticationToken.TOKEN_TYPE.SERVICE.toString());
        claimsMap.put("servicename", "SELF");
        HashSet<String> rolesAsString = new HashSet<String>();
        rolesAsString.add(RepoServiceRole.SERVICE_WRITE.getValue());
        try {
            claimsMap.put("roles", new ObjectMapper().writeValueAsString((Object)rolesAsString.toArray(new String[0])));
        }
        catch (JsonProcessingException ex) {
            throw new InvalidAuthenticationException("Failed to create JWToken.", ex);
        }
        SecretKeySpec key = new SecretKeySpec(this.secretKey.getBytes(StandardCharset.UTF_8), "HmacSHA256");
        String token = Jwts.builder().claims(claimsMap).expiration(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).signWith((Key)key).compact();
        JwtAuthenticationToken res = JwtAuthenticationToken.factoryToken(token, claimsMap);
        SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

