/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.security.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.util.StandardCharset;
import edu.kit.datamanager.exceptions.InvalidAuthenticationException;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import io.jsonwebtoken.Jwts;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class PublicAuthenticationFilter
extends OncePerRequestFilter {
    public static final String PUBLIC_USER = "anonymousUser";
    public static final String ROLE_PUBLIC_READ = "ROLE_ANONYMOUS";
    private static final Logger LOG = LoggerFactory.getLogger(PublicAuthenticationFilter.class);
    private final String secretKey;
    private static final String USERS_GROUP = "PUBLIC";

    public PublicAuthenticationFilter(String secretKey) {
        this.secretKey = secretKey;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException, AuthenticationException {
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            LOG.trace("Set public authorization!");
            HashMap<String, Object> claimsMap = new HashMap<String, Object>();
            claimsMap.put("groups", Arrays.asList(USERS_GROUP));
            claimsMap.put("tokenType", JwtAuthenticationToken.TOKEN_TYPE.USER.toString());
            claimsMap.put("username", PUBLIC_USER);
            HashSet<String> rolesAsString = new HashSet<String>();
            rolesAsString.add(ROLE_PUBLIC_READ);
            try {
                claimsMap.put("roles", new ObjectMapper().writeValueAsString(rolesAsString.toArray(String[]::new)));
            }
            catch (JsonProcessingException ex) {
                throw new InvalidAuthenticationException("Failed to create JWToken.", ex);
            }
            SecretKeySpec key = new SecretKeySpec(this.secretKey.getBytes(StandardCharset.UTF_8), "HmacSHA256");
            String token = Jwts.builder().claims(claimsMap).expiration(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).signWith((Key)key).compact();
            JwtAuthenticationToken res = JwtAuthenticationToken.factoryToken(token, claimsMap);
            SecurityContextHolder.getContext().setAuthentication((Authentication)res);
        } else {
            LOG.trace("Nothing to do as user is already authenticated!");
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

