/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import edu.kit.datamanager.entities.PERMISSION;
import edu.kit.datamanager.entities.RepoUserRole;
import edu.kit.datamanager.security.filter.JwtAuthenticationToken;
import edu.kit.datamanager.security.filter.JwtServiceToken;
import edu.kit.datamanager.security.filter.JwtTemporaryToken;
import edu.kit.datamanager.security.filter.JwtUserToken;
import edu.kit.datamanager.security.filter.ScopedPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationHelper {
    public static final String ANONYMOUS_USER_PRINCIPAL = "anonymousUser";

    private AuthenticationHelper() {
    }

    public static Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            auth = new AnonymousAuthenticationToken("anonymous", (Object)ANONYMOUS_USER_PRINCIPAL, Arrays.asList(new SimpleGrantedAuthority(RepoUserRole.GUEST.getValue())));
        }
        return auth;
    }

    public static boolean hasAuthority(String authority) {
        return AuthenticationHelper.getAuthentication().getAuthorities().stream().filter(a -> a.getAuthority().equals(authority)).count() > 0L;
    }

    public static String getFirstname() {
        if (AuthenticationHelper.getAuthentication() instanceof JwtUserToken) {
            return ((JwtUserToken)AuthenticationHelper.getAuthentication()).getFirstname();
        }
        return null;
    }

    public static String getLastname() {
        if (AuthenticationHelper.getAuthentication() instanceof JwtUserToken) {
            return ((JwtUserToken)AuthenticationHelper.getAuthentication()).getLastname();
        }
        return null;
    }

    public static String getPrincipal() {
        return (String)AuthenticationHelper.getAuthentication().getPrincipal();
    }

    public static List<String> getAuthorizationIdentities() {
        List<String> groupIds;
        ArrayList<String> identities = new ArrayList<String>();
        identities.add(AuthenticationHelper.getPrincipal());
        if (AuthenticationHelper.getAuthentication() instanceof JwtAuthenticationToken && (groupIds = ((JwtAuthenticationToken)AuthenticationHelper.getAuthentication()).getGroups()) != null && !groupIds.isEmpty()) {
            identities.addAll(groupIds);
        }
        identities.add(ANONYMOUS_USER_PRINCIPAL);
        return identities;
    }

    public static boolean isPrincipal(String principal) {
        Optional<String> oUserId = Optional.of(principal);
        return oUserId.isPresent() && oUserId.get().equals((String)AuthenticationHelper.getAuthentication().getPrincipal());
    }

    public static boolean hasIdentity(String identity) {
        return AuthenticationHelper.getAuthorizationIdentities().contains(identity);
    }

    public static boolean isAnonymous() {
        return AuthenticationHelper.isPrincipal(ANONYMOUS_USER_PRINCIPAL);
    }

    public static boolean isAuthenticatedAsService() {
        return AuthenticationHelper.getAuthentication() instanceof JwtServiceToken;
    }

    public static PERMISSION getScopedPermission(String resourceType, String resourceId) {
        if (AuthenticationHelper.getAuthentication() instanceof JwtTemporaryToken) {
            ScopedPermission[] scopedPermissions;
            for (ScopedPermission permission : scopedPermissions = ((JwtTemporaryToken)AuthenticationHelper.getAuthentication()).getScopedPermissions()) {
                if (!permission.getResourceType().equals(resourceType) || !permission.getResourceId().equals(resourceId)) continue;
                return permission.getPermission();
            }
        }
        return PERMISSION.NONE;
    }
}

