/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import edu.kit.datamanager.entities.EtagSupport;
import edu.kit.datamanager.entities.RepoUserRole;
import edu.kit.datamanager.exceptions.AccessForbiddenException;
import edu.kit.datamanager.exceptions.BadArgumentException;
import edu.kit.datamanager.exceptions.EtagMismatchException;
import edu.kit.datamanager.exceptions.EtagMissingException;
import edu.kit.datamanager.exceptions.RangeNotSatisfyableException;
import edu.kit.datamanager.exceptions.UnauthorizedAccessException;
import edu.kit.datamanager.util.AuthenticationHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.context.request.WebRequest;

public class ControllerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerUtils.class);
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("([\\d]+)[-]([\\d]+)[/]([\\d]+)");

    ControllerUtils() {
    }

    public static PageRequest checkPaginationInformation(Pageable pgbl) {
        return ControllerUtils.checkPaginationInformation(pgbl, pgbl.getSort());
    }

    public static PageRequest checkPaginationInformation(Pageable pgbl, Sort sort) {
        if (pgbl == null) {
            return PageRequest.of((int)0, (int)20);
        }
        int pageSize = pgbl.getPageSize();
        if (pageSize > 100) {
            LOGGER.debug("Restricting user-provided page size {} to max. page size 100.", (Object)pageSize);
            pageSize = 100;
        }
        LOGGER.trace("Rebuilding page request for page {}, size {} and sort {}.", new Object[]{pgbl.getPageNumber(), pageSize, pgbl.getSort()});
        return PageRequest.of((int)pgbl.getPageNumber(), (int)pageSize, (Sort)(sort != null ? sort : Sort.unsorted()));
    }

    public static void checkAnonymousAccess() throws UnauthorizedAccessException {
        if (AuthenticationHelper.isAnonymous()) {
            String message = "Please login in order to be able to perform this operation.";
            LOGGER.info(message);
            throw new UnauthorizedAccessException(message);
        }
    }

    public static void checkAdministratorAccess() {
        if (!AuthenticationHelper.hasAuthority(RepoUserRole.ADMINISTRATOR.getValue())) {
            LOGGER.warn("Caller is not allowed to perform the requested operation, ROLE_ADMINISTRATOR is required. Throwing AccessForbiddenException.");
            throw new AccessForbiddenException("Insufficient role. ROLE_ADMINISTRATOR required.");
        }
    }

    public static void checkEtag(WebRequest request, EtagSupport resource) throws EtagMismatchException {
        String etagValue = ControllerUtils.getEtagFromHeader(request);
        ControllerUtils.checkEtag(etagValue, resource);
    }

    public static String getEtagFromHeader(WebRequest request) {
        String etagValue = request.getHeader("If-Match");
        LOGGER.trace("Received ETag: {}", (Object)etagValue);
        if (etagValue == null) {
            String message = "If-Match header with valid etag is missing.";
            LOGGER.trace(message);
            throw new EtagMissingException(message);
        }
        return etagValue;
    }

    public static void checkEtag(String etagValue, EtagSupport resource) throws EtagMismatchException {
        String etag = resource.getEtag();
        LOGGER.trace("Checking ETag for resource with ETag {}.", (Object)etag);
        if (!etagValue.equals("\"" + etag + "\"")) {
            String message = String.format("ETag not matching or not provided. (provided: '%s' <-> resource: '%s')", etagValue, etag);
            LOGGER.trace(message);
            throw new EtagMismatchException(message);
        }
    }

    public static String getLocalHostname() {
        String hostname = "localhost";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getHostName();
            LOGGER.trace("get local hostname: {} -> {}", (Object)inetAddress, (Object)hostname);
        }
        catch (UnknownHostException ex) {
            LOGGER.warn("Unable to determine local host address. Returning default hostname 'localhost'.", (Throwable)ex);
        }
        return hostname;
    }

    public static Long parseIdToLong(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            String message = "Provided id must be numeric.";
            LOGGER.trace(message);
            throw new BadArgumentException(message);
        }
    }

    public static String getContentRangeHeader(int currentPage, int pageSize, long totalElements) {
        if (totalElements > 0L) {
            int indexStart = currentPage * pageSize;
            if ((long)indexStart > totalElements - 1L) {
                String message = "Current page '" + currentPage + "' is out of range!\n(Pagesize: '" + pageSize + "', total no of elements: '" + totalElements + "'";
                LOGGER.trace(message);
                throw new RangeNotSatisfyableException(message);
            }
            int indexEnd = (int)Math.min((long)(indexStart + pageSize - 1), Math.max(0L, totalElements - 1L));
            return indexStart + "-" + indexEnd + "/" + totalElements;
        }
        return "*/0";
    }

    public static ContentRange parseContentRangeHeader(String headerValue) {
        ContentRange range = new ContentRange();
        if (headerValue == null || headerValue.startsWith("*")) {
            range.indexStart = 0;
            range.indexEnd = 0;
            range.totalElements = 0L;
        } else {
            Matcher m = CONTENT_RANGE_PATTERN.matcher(headerValue);
            if (m.find()) {
                range.indexStart = Integer.parseInt(m.group(1));
                range.indexEnd = Integer.parseInt(m.group(2));
                range.totalElements = Long.parseLong(m.group(3));
            }
        }
        return range;
    }

    public static class ContentRange {
        private int indexStart = 0;
        private int indexEnd = 0;
        private long totalElements = 0L;

        public static ContentRange empty() {
            return new ContentRange();
        }

        public int getIndexStart() {
            return this.indexStart;
        }

        public int getIndexEnd() {
            return this.indexEnd;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public void setIndexStart(int indexStart) {
            this.indexStart = indexStart;
        }

        public void setIndexEnd(int indexEnd) {
            this.indexEnd = indexEnd;
        }

        public void setTotalElements(long totalElements) {
            this.totalElements = totalElements;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentRange)) {
                return false;
            }
            ContentRange other = (ContentRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndexStart() != other.getIndexStart()) {
                return false;
            }
            if (this.getIndexEnd() != other.getIndexEnd()) {
                return false;
            }
            return this.getTotalElements() == other.getTotalElements();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndexStart();
            result = result * 59 + this.getIndexEnd();
            long $totalElements = this.getTotalElements();
            result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
            return result;
        }

        public String toString() {
            return "ControllerUtils.ContentRange(indexStart=" + this.getIndexStart() + ", indexEnd=" + this.getIndexEnd() + ", totalElements=" + this.getTotalElements() + ")";
        }
    }
}

