/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.kit.datamanager.util.AuthenticationHelper;
import edu.kit.datamanager.validator.SearchIndexValidator;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ElasticSearchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchUtil.class);
    static final JsonNodeFactory factory = JsonNodeFactory.instance;
    public static final String RESULTS_FROM = "from";
    public static final String RESULTS_SIZE = "size";
    static final String SID_READ = "read";
    private static final int NO_OF_RETRIES = 3;

    public static boolean testForElasticsearch(URL elasticsearchURL) {
        boolean validElasticSearchServer = false;
        if (elasticsearchURL != null) {
            String baseUrl = elasticsearchURL.toString();
            if (baseUrl.trim().endsWith("/")) {
                LOGGER.error("Invalid elasticsearch URL. Please remove trailing '/' from URL '{}'!", (Object)baseUrl);
            } else {
                String accessUrl = baseUrl + "/_search";
                RestTemplate restTemplate = new RestTemplate();
                LOGGER.trace("Trying to connect to elasticsearch instance.");
                for (int retries = 1; retries <= 3; ++retries) {
                    try {
                        ResponseEntity entity = restTemplate.getForEntity(accessUrl, String.class, new Object[]{baseUrl});
                        LOGGER.trace("Status code value: " + entity.getStatusCodeValue());
                        LOGGER.trace("HTTP Header 'ContentType': " + entity.getHeaders().getContentType());
                        if (entity.getStatusCodeValue() == HttpStatus.OK.value()) {
                            LOGGER.info("Elasticsearch server at '{}' seems to be up and running!", (Object)baseUrl);
                            validElasticSearchServer = true;
                            break;
                        }
                        LOGGER.debug("Invalid response from elasticsearch server. Expected HTTP 200, received HTTP " + entity.getStatusCodeValue() + ". Aborting.");
                    }
                    catch (RestClientException ex) {
                        LOGGER.warn("Failed accessing elasticsearch server.", (Throwable)ex);
                    }
                    LOGGER.warn("Attempt {}/{} failed!", (Object)retries, (Object)3);
                    if (retries >= 3) continue;
                    LOGGER.warn("Retrying in 5 seconds...");
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!validElasticSearchServer) {
                LOGGER.trace("Unable to connect to elasticsearch instance at '{}' within '{}' attempts!", (Object)baseUrl, (Object)3);
            }
        } else {
            LOGGER.warn("No elasticsearch URL provided. Aborting.");
        }
        return validElasticSearchServer;
    }

    public static String testForValidIndex(String elasticsearchIndex) {
        String validIndex = elasticsearchIndex;
        boolean valid = new SearchIndexValidator().isValid(validIndex, null);
        if (!valid) {
            String pattern = "[  \"\\<|>/?{}\\[\\]`A-Z]";
            validIndex = validIndex.toLowerCase().replaceAll(pattern, "_");
        }
        return validIndex;
    }

    public static void buildPostFilter(ObjectNode queryNode) {
        boolean havePostFilter = false;
        if (queryNode.has("post_filter")) {
            LOGGER.warn("PostFilter found in provided query. Filter will be replaced!");
            havePostFilter = true;
        }
        LOGGER.trace("Adding PostFilter to elastic query.");
        ArrayNode arrayNode = factory.arrayNode();
        for (String sid : AuthenticationHelper.getAuthorizationIdentities()) {
            JsonNode match = factory.objectNode().set("match", (JsonNode)factory.objectNode().put(SID_READ, sid));
            arrayNode.add(match);
        }
        ObjectNode should = (ObjectNode)factory.objectNode().set("should", (JsonNode)arrayNode);
        should.put("minimum_should_match", 1);
        JsonNode postFilter = factory.objectNode().set("bool", (JsonNode)should);
        if (havePostFilter) {
            ArrayNode mustNode = (ArrayNode)queryNode.get("post_filter").get("bool").get("must");
            mustNode.add(postFilter);
        } else {
            LOGGER.trace("PostFilter: '{}'", (Object)postFilter);
            queryNode.replace("post_filter", postFilter);
        }
    }

    public static void addPaginationInformation(ObjectNode queryNode, int page, int size) {
        if (queryNode.has(RESULTS_FROM) || queryNode.has(RESULTS_SIZE)) {
            LOGGER.trace("Provided query already specifies 'from' and/or 'size'. Ignoring pagination information from request.");
        } else {
            LOGGER.trace("Provided query does not specify 'from' and/or 'size'. Using pagination information with page {} and size {}", (Object)page, (Object)size);
            queryNode.replace(RESULTS_FROM, (JsonNode)factory.numberNode(page * size));
            queryNode.replace(RESULTS_SIZE, (JsonNode)factory.numberNode(size));
        }
    }
}

