/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilenameUtils {
    private static final Pattern PATTERN = Pattern.compile("[%\"\\*/:<>\\?\\\\\\|\\+,;=\\[\\]]");
    private static final int MAX_LENGTH = 255;

    private FilenameUtils() {
    }

    public static String escapeStringAsFilename(String in) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN.matcher(in);
        while (m.find()) {
            String replacement = "%" + Integer.toHexString(m.group().charAt(0)).toUpperCase();
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        String encoded = sb.toString();
        int end = Math.min(encoded.length(), 255);
        String substring = encoded.substring(0, end);
        String regex = "\\.(?=.*\\.)";
        return substring.replaceAll(regex, "%2E");
    }
}

