/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static boolean isHostname(String address) {
        if (address.isEmpty() || NetworkUtils.isIp(address)) {
            return false;
        }
        try {
            InetAddress res = InetAddress.getByName(address);
            return res instanceof Inet4Address || res instanceof Inet6Address;
        }
        catch (UnknownHostException ex) {
            LOGGER.warn("Failed to check " + address + ". Returning 'false'.", (Throwable)ex);
            return false;
        }
    }

    public static boolean matches(String ipOrHostname1, String ipOrHostname2) {
        try {
            LOGGER.debug("Checking if {} and {} are matching.", (Object)ipOrHostname1, (Object)ipOrHostname2);
            if (StringUtils.equals((CharSequence)ipOrHostname1, (CharSequence)ipOrHostname2)) {
                LOGGER.debug("Both arguments are equal.");
                return true;
            }
            InetAddress[] all1 = InetAddress.getAllByName(ipOrHostname1);
            InetAddress[] all2 = InetAddress.getAllByName(ipOrHostname2);
            for (InetAddress a1 : all1) {
                for (InetAddress a2 : all2) {
                    LOGGER.debug("Comparing InetAddress1 {} and InetAddress2 {}", (Object)a1, (Object)a2);
                    if (a1.isLoopbackAddress() && a2.isLoopbackAddress()) {
                        LOGGER.debug("Both addresses are loopback addresses. Returning 'true'.");
                        return true;
                    }
                    if (!a1.equals(a2)) continue;
                    LOGGER.debug("Both addresses are equal. Returning 'true'.");
                    return true;
                }
            }
            LOGGER.debug("Addresses {} and {} are not matching. Returning 'false'.", (Object)ipOrHostname1, (Object)ipOrHostname2);
        }
        catch (UnknownHostException ex) {
            LOGGER.error("Failed to resolve at least one IP or hostname. Aborting and returning 'false'.", (Throwable)ex);
        }
        return false;
    }

    public static boolean isIp(String ip) {
        return NetworkUtils.isIpV4(ip) || NetworkUtils.isIpV6(ip);
    }

    public static boolean isIpV4(String ip) {
        return InetAddressValidator.getInstance().isValidInet4Address(ip);
    }

    public static boolean isIpV6(String ip) {
        return InetAddressValidator.getInstance().isValidInet6Address(ip);
    }
}

