/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import edu.kit.datamanager.annotations.SecureUpdate;
import edu.kit.datamanager.entities.PERMISSION;
import edu.kit.datamanager.exceptions.CustomInternalServerError;
import edu.kit.datamanager.exceptions.PatchApplicationException;
import edu.kit.datamanager.exceptions.UpdateForbiddenException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class PatchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchUtil.class);

    private PatchUtil() {
    }

    public static <C> C applyPatch(C resource, JsonPatch patch, Class<C> resourceClass, Collection<? extends GrantedAuthority> authorities) {
        Object updated;
        ObjectMapper tmpObjectMapper = new ObjectMapper();
        tmpObjectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode resourceAsNode = (JsonNode)tmpObjectMapper.convertValue(resource, JsonNode.class);
        try {
            JsonNode patchedDataResourceAsNode = patch.apply(resourceAsNode);
            updated = tmpObjectMapper.treeToValue((TreeNode)patchedDataResourceAsNode, resourceClass);
        }
        catch (JsonProcessingException | JsonPatchException ex) {
            LOGGER.error("Failed to apply patch '" + patch.toString() + " to resource " + resource, ex);
            throw new PatchApplicationException("Failed to apply patch to resource.");
        }
        if (!PatchUtil.canUpdate(resource, updated, authorities)) {
            String message = "Patch not applicable.";
            LOGGER.warn(message);
            throw new UpdateForbiddenException(message);
        }
        return (C)updated;
    }

    public static boolean canUpdate(Object originalObj, Object patched, Collection<? extends GrantedAuthority> authorities) {
        for (Field field : patched.getClass().getDeclaredFields()) {
            SecureUpdate secureUpdate = field.getAnnotation(SecureUpdate.class);
            if (secureUpdate == null) continue;
            try {
                field.setAccessible(true);
                Object persistedField = field.get(patched);
                Object originalField = field.get(originalObj);
                String[] allowedRoles = secureUpdate.value();
                if (Objects.equals(persistedField, originalField)) continue;
                boolean canUpdate = false;
                for (String role : allowedRoles) {
                    for (GrantedAuthority grantedAuthority : authorities) {
                        String auth = grantedAuthority.getAuthority();
                        if (auth.toLowerCase().startsWith("role") && role.toLowerCase().startsWith("role")) {
                            if (!grantedAuthority.getAuthority().equalsIgnoreCase(role)) continue;
                            canUpdate = true;
                            break;
                        }
                        if (auth.toLowerCase().startsWith("permission") && role.toLowerCase().startsWith("permission")) {
                            PERMISSION permissionAccepted;
                            PERMISSION userPermission = PERMISSION.fromValue(auth);
                            if (!userPermission.atLeast(permissionAccepted = PERMISSION.fromValue(role))) continue;
                            canUpdate = true;
                            break;
                        }
                        if (!grantedAuthority.getAuthority().equalsIgnoreCase(role)) continue;
                        canUpdate = true;
                        break;
                    }
                    if (canUpdate) break;
                }
                if (canUpdate) continue;
                LOGGER.warn("Updating of field " + field + " is allowed by " + Arrays.asList(allowedRoles) + ", but caller only offered the following authorities: " + authorities + ".");
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOGGER.error("Failed to check update applicability.", (Throwable)e);
                throw new CustomInternalServerError("Unable to check if update is applicable. Message: " + e.getMessage());
            }
        }
        return true;
    }
}

