/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static void zip(File pDirectory, File pZipOut) throws IOException {
        ZipUtils.zip(pDirectory, pDirectory.getCanonicalPath(), pZipOut);
    }

    public static void zip(File pDirectory, String pBasePath, File pZipOut) throws IOException {
        LOGGER.info("Zipping directory '{}'", (Object)pDirectory.getPath());
        ZipUtils.zip(pDirectory.listFiles(), pBasePath, pZipOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] pFiles, String pBasePath, File pZipOut) throws IOException {
        StringBuilder errorMessage = new StringBuilder();
        if (pFiles == null) {
            errorMessage.append("Argument pFiles must not be null.\n");
        }
        if (pBasePath == null) {
            errorMessage.append("Argument pBasePath must not be null.\n");
        }
        if (pZipOut == null) {
            errorMessage.append("Argument pZipOut must not be null.\n");
        }
        if (errorMessage.length() > 0) {
            LOGGER.warn(errorMessage.toString());
            throw new IllegalArgumentException(errorMessage.toString());
        }
        ZipOutputStream zipOut = null;
        try {
            zipOut = new ZipOutputStream(new FileOutputStream(pZipOut));
            ZipUtils.zip(pFiles, pBasePath, zipOut);
            zipOut.finish();
            zipOut.flush();
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (IOException ignored) {
                LOGGER.trace("Failed to close zip output stream. Error will be ignored.", (Throwable)ignored);
            }
        }
    }

    public static boolean zipDirectory(File pDirectory, File pZipFile, String ... pExtension) {
        boolean success = false;
        File[] files = pDirectory.listFiles((dir, name) -> {
            boolean accept = false;
            String lowerCase = name.toLowerCase();
            if (pExtension != null) {
                for (String extension : pExtension) {
                    if (!lowerCase.endsWith(extension.toLowerCase())) continue;
                    accept = true;
                    break;
                }
            } else {
                accept = true;
            }
            return accept;
        });
        if (LOGGER.isDebugEnabled()) {
            String fileSeparator = ", ";
            LOGGER.debug("Zip files to " + pZipFile.getName());
            StringBuilder sb = new StringBuilder("Selected files: ");
            for (File file : files) {
                sb.append(file.getName()).append(fileSeparator);
            }
            int lastIndex = sb.lastIndexOf(fileSeparator);
            sb.delete(lastIndex, lastIndex + fileSeparator.length());
            LOGGER.debug(sb.toString());
        }
        try {
            ZipUtils.zip(files, pDirectory.getPath(), pZipFile);
            success = true;
        }
        catch (IOException ex) {
            LOGGER.error("Error while zipping files!", (Throwable)ex);
        }
        return success;
    }

    public static void zipSingleFile(File pSourceFile, File pTargetDir) throws IOException {
        File zipFile = new File(pTargetDir.getAbsolutePath() + File.separator + pSourceFile.getName() + ".zip");
        ZipUtils.zip(new File[]{pSourceFile}, pSourceFile.getParent(), zipFile);
    }

    public static void zip(File[] pFileList, String pBasePath, ZipOutputStream pZipOut) throws IOException {
        String basePath = new File(pBasePath).getCanonicalPath();
        byte[] buf = new byte[1024];
        try {
            LOGGER.debug("Adding {} files to archive", (Object)pFileList.length);
            for (File pFileList1 : pFileList) {
                String entryName = pFileList1.getCanonicalPath().replaceAll(Pattern.quote(basePath), "");
                if (entryName.startsWith(File.separator)) {
                    entryName = entryName.substring(1);
                }
                if (pFileList1.isDirectory()) {
                    LOGGER.debug("Start adding directory {}.", (Object)pFileList1);
                    pZipOut.putNextEntry(new ZipEntry((entryName + File.separator).replaceAll("\\\\", "/")));
                    pZipOut.closeEntry();
                    File[] fileList = pFileList1.listFiles();
                    if (fileList.length != 0) {
                        LOGGER.debug("Start adding {} sub-elements of directory {}.", (Object)fileList.length, (Object)pFileList1);
                        ZipUtils.zip(fileList, pBasePath, pZipOut);
                        LOGGER.debug("Finished adding sub-elements of directory {}.", (Object)pFileList1);
                        continue;
                    }
                    LOGGER.debug("Finished adding directory {} as it is empty.", (Object)pFileList1);
                    continue;
                }
                LOGGER.debug("Start adding file {}.", (Object)pFileList1);
                try (FileInputStream in = new FileInputStream(pFileList1);){
                    int len;
                    pZipOut.putNextEntry(new ZipEntry(entryName.replaceAll("\\\\", "/")));
                    while ((len = in.read(buf)) > 0) {
                        pZipOut.write(buf, 0, len);
                    }
                    LOGGER.debug("Finishing adding file {}.", (Object)pFileList1);
                    pZipOut.closeEntry();
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Aborting zip process due to an IOException caused by any zip stream (FileInput or ZipOutput)", (Throwable)ioe);
            throw ioe;
        }
        catch (RuntimeException e) {
            LOGGER.error("Aborting zip process due to an unexpected exception", (Throwable)e);
            throw new IOException("Unexpected exception during zip operation", e);
        }
    }

    public static void unzip(File fSourceZip, boolean delete) {
        File zipPath = fSourceZip.getAbsoluteFile().getParentFile();
        ZipUtils.unzip(fSourceZip, zipPath, delete);
    }

    public static void unzip(File pZipFile) throws IOException {
        ZipUtils.unzip(pZipFile, ".");
    }

    public static void unzip(File pZipFile, File pDestination) throws IOException {
        ZipUtils.unzip(pZipFile, pDestination, false);
    }

    public static void unzip(File pZipFile, String pDestination) throws IOException {
        ZipUtils.unzip(pZipFile, new File(pDestination));
    }

    public static void unzip(File fSourceZip, File outputDir, boolean delete) {
        try {
            if (outputDir.mkdirs()) {
                LOGGER.debug("Create directory '{}'", (Object)outputDir.getAbsolutePath());
            }
            try (ZipFile zipFile = new ZipFile(fSourceZip);){
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipUtils.extractEntry(outputDir, zipFile, e.nextElement());
                }
            }
            if (delete && fSourceZip != null && fSourceZip.exists() && !FileUtils.deleteQuietly((File)fSourceZip)) {
                LOGGER.error("Error deleting '{}'!?", (Object)fSourceZip.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Error while unzipping file!", (Throwable)ioe);
        }
    }

    private static void extractEntry(File pOutputDir, ZipFile pZipFile, ZipEntry pEntry) throws IOException {
        File destinationFilePath = new File(pOutputDir, pEntry.getName());
        if (pEntry.isDirectory()) {
            if (destinationFilePath.mkdirs()) {
                LOGGER.trace("create directory: '{}'", (Object)destinationFilePath.getPath());
            }
        } else if (destinationFilePath.getParentFile().mkdirs()) {
            LOGGER.trace("create directory: '{}'", (Object)destinationFilePath.getPath());
        }
        if (!pEntry.isDirectory()) {
            LOGGER.debug("Extracting " + destinationFilePath);
            byte[] buffer = new byte[1024];
            try (BufferedInputStream bis = new BufferedInputStream(pZipFile.getInputStream(pEntry));
                 FileOutputStream fos = new FileOutputStream(destinationFilePath);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);){
                int noOfBytes;
                while ((noOfBytes = bis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, noOfBytes);
                }
                bos.flush();
            }
        }
    }
}

