/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.util.xml;

import edu.kit.datamanager.entities.repo.Agent;
import edu.kit.datamanager.entities.repo.Box;
import edu.kit.datamanager.entities.repo.Contributor;
import edu.kit.datamanager.entities.repo.DataResource;
import edu.kit.datamanager.entities.repo.Date;
import edu.kit.datamanager.entities.repo.Description;
import edu.kit.datamanager.entities.repo.FunderIdentifier;
import edu.kit.datamanager.entities.repo.FundingReference;
import edu.kit.datamanager.entities.repo.GeoLocation;
import edu.kit.datamanager.entities.repo.Identifier;
import edu.kit.datamanager.entities.repo.Point;
import edu.kit.datamanager.entities.repo.Polygon;
import edu.kit.datamanager.entities.repo.PrimaryIdentifier;
import edu.kit.datamanager.entities.repo.RelatedIdentifier;
import edu.kit.datamanager.entities.repo.ResourceType;
import edu.kit.datamanager.entities.repo.Scheme;
import edu.kit.datamanager.entities.repo.Subject;
import edu.kit.datamanager.entities.repo.Title;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.purl.dc.elements._1.ElementContainer;
import org.purl.dc.elements._1.ObjectFactory;
import org.purl.dc.elements._1.SimpleLiteral;

public class DublinCoreMapper {
    private static ObjectFactory factory = new ObjectFactory();
    private static DateTimeFormatter fmt = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);

    public static ElementContainer dataResourceToDublinCoreContainer(DataResource resource) {
        ElementContainer container = new ElementContainer();
        DublinCoreMapper.mapTitles(resource, container);
        DublinCoreMapper.mapCreators(resource, container);
        DublinCoreMapper.mapSubjects(resource, container);
        DublinCoreMapper.mapDescriptions(resource, container);
        DublinCoreMapper.mapPublisher(resource, container);
        DublinCoreMapper.mapContributors(resource, container);
        DublinCoreMapper.mapDates(resource, container);
        DublinCoreMapper.mapResourceType(resource, container);
        DublinCoreMapper.mapFormats(resource, container);
        DublinCoreMapper.mapIdentifier(resource, container);
        DublinCoreMapper.mapRelatedIdentifiers(resource, container);
        DublinCoreMapper.mapLanguage(resource, container);
        DublinCoreMapper.mapRights(resource, container);
        return container;
    }

    private static void mapTitles(DataResource resource, ElementContainer container) {
        for (Title t : resource.getTitles()) {
            container.getAny().add(factory.createTitle(DublinCoreMapper.createSimpleLiteral(t.getValue(), t.getLang())));
        }
    }

    private static void mapCreators(DataResource resource, ElementContainer container) {
        for (Agent a : resource.getCreators()) {
            if (a.getGivenName() != null && a.getFamilyName() != null) {
                container.getAny().add(factory.createCreator(DublinCoreMapper.createSimpleLiteral(a.getFamilyName() + ", " + a.getGivenName())));
                continue;
            }
            if (a.getGivenName() == null && a.getFamilyName() == null) continue;
            if (a.getGivenName() == null) {
                container.getAny().add(factory.createCreator(DublinCoreMapper.createSimpleLiteral(a.getFamilyName())));
                continue;
            }
            container.getAny().add(factory.createCreator(DublinCoreMapper.createSimpleLiteral(a.getGivenName())));
        }
    }

    private static void mapSubjects(DataResource resource, ElementContainer container) {
        for (Subject s : resource.getSubjects()) {
            container.getAny().add(factory.createSubject(DublinCoreMapper.createSimpleLiteral(s.getValue(), s.getLang())));
        }
    }

    private static void mapDescriptions(DataResource resource, ElementContainer container) {
        for (Description d : resource.getDescriptions()) {
            container.getAny().add(factory.createDescription(DublinCoreMapper.createSimpleLiteral(d.getDescription(), d.getLang())));
        }
    }

    private static void mapPublisher(DataResource resource, ElementContainer container) {
        if (resource.getPublisher() != null) {
            container.getAny().add(factory.createPublisher(DublinCoreMapper.createSimpleLiteral(resource.getPublisher())));
        }
    }

    private static void mapContributors(DataResource resource, ElementContainer container) {
        for (Contributor d : resource.getContributors()) {
            Agent a = d.getUser();
            if (a.getGivenName() != null && a.getFamilyName() != null) {
                container.getAny().add(factory.createContributor(DublinCoreMapper.createSimpleLiteral(a.getFamilyName() + ", " + a.getGivenName())));
                continue;
            }
            if (a.getGivenName() == null && a.getFamilyName() == null) continue;
            if (a.getGivenName() == null) {
                container.getAny().add(factory.createContributor(DublinCoreMapper.createSimpleLiteral(a.getFamilyName())));
                continue;
            }
            container.getAny().add(factory.createContributor(DublinCoreMapper.createSimpleLiteral(a.getGivenName())));
        }
    }

    private static void mapDates(DataResource resource, ElementContainer container) {
        for (Date d : resource.getDates()) {
            container.getAny().add(factory.createDate(DublinCoreMapper.createSimpleLiteral(fmt.format(d.getValue()))));
        }
    }

    private static void mapResourceType(DataResource resource, ElementContainer container) {
        if (resource.getResourceType() != null) {
            container.getAny().add(factory.createType(DublinCoreMapper.createSimpleLiteral(resource.getResourceType().getTypeGeneral().getValue())));
        }
    }

    private static void mapFormats(DataResource resource, ElementContainer container) {
        for (String f : resource.getFormats()) {
            container.getAny().add(factory.createFormat(DublinCoreMapper.createSimpleLiteral(f)));
        }
    }

    private static void mapIdentifier(DataResource resource, ElementContainer container) {
        if (resource.getIdentifier() != null) {
            container.getAny().add(factory.createIdentifier(DublinCoreMapper.createSimpleLiteral(resource.getIdentifier().getValue())));
        }
    }

    private static void mapRelatedIdentifiers(DataResource resource, ElementContainer container) {
        for (RelatedIdentifier i : resource.getRelatedIdentifiers()) {
            if (RelatedIdentifier.RELATION_TYPES.IS_NEW_VERSION_OF.equals(i.getRelationType()) || RelatedIdentifier.RELATION_TYPES.IS_DERIVED_FROM.equals(i.getRelationType())) {
                container.getAny().add(factory.createSource(DublinCoreMapper.createSimpleLiteral(i.getValue())));
                continue;
            }
            container.getAny().add(factory.createRelation(DublinCoreMapper.createSimpleLiteral(i.getValue())));
        }
    }

    private static void mapLanguage(DataResource resource, ElementContainer container) {
        if (resource.getLanguage() != null) {
            container.getAny().add(factory.createLanguage(DublinCoreMapper.createSimpleLiteral(resource.getLanguage())));
        }
    }

    private static void mapRights(DataResource resource, ElementContainer container) {
        for (Scheme r : resource.getRights()) {
            container.getAny().add(factory.createRights(DublinCoreMapper.createSimpleLiteral(r.getSchemeUri())));
        }
    }

    private static SimpleLiteral createSimpleLiteral(String value) {
        return DublinCoreMapper.createSimpleLiteral(value, null);
    }

    private static SimpleLiteral createSimpleLiteral(String value, String lang) {
        SimpleLiteral lit = factory.createSimpleLiteral();
        lit.getContent().add(value);
        lit.setLang(lang);
        return lit;
    }

    public static void main(String[] args) throws Exception {
        DataResource res = new DataResource();
        PrimaryIdentifier id = new PrimaryIdentifier();
        id.setIdentifierType("DOI");
        id.setValue("test");
        res.setIdentifier(id);
        Identifier alt = new Identifier();
        alt.setIdentifierType(Identifier.IDENTIFIER_TYPE.DOI);
        alt.setValue("altTest");
        res.getAlternateIdentifiers().add(alt);
        RelatedIdentifier rel = new RelatedIdentifier();
        rel.setIdentifierType(RelatedIdentifier.RELATED_IDENTIFIER_TYPE.HANDLE);
        rel.setRelationType(RelatedIdentifier.RELATION_TYPES.DOCUMENTS);
        rel.setRelatedMetadataScheme("scheme1");
        rel.setValue("relatedDocument");
        Scheme s = new Scheme();
        s.setSchemeId("scheme1");
        s.setSchemeUri("http://heise.de");
        rel.setScheme(s);
        res.getRelatedIdentifiers().add(rel);
        RelatedIdentifier relSource = new RelatedIdentifier();
        relSource.setIdentifierType(RelatedIdentifier.RELATED_IDENTIFIER_TYPE.HANDLE);
        relSource.setRelationType(RelatedIdentifier.RELATION_TYPES.IS_DERIVED_FROM);
        relSource.setRelatedMetadataScheme("scheme1");
        relSource.setValue("ThisIsASource");
        res.getRelatedIdentifiers().add(relSource);
        Agent a = new Agent();
        a.setGivenName("Thomas");
        a.setFamilyName("Jejkal");
        res.getCreators().add(a);
        Title t = new Title();
        t.setLang("en");
        t.setTitleType(Title.TITLE_TYPE.SUBTITLE);
        t.setValue("This is the title");
        res.getTitles().add(t);
        ResourceType type = new ResourceType();
        type.setTypeGeneral(ResourceType.TYPE_GENERAL.DATASET);
        type.setValue("Custom Dataset");
        res.setResourceType(type);
        Contributor con = new Contributor();
        con.setUser(a);
        con.setContributionType(Contributor.CONTRIBUTOR_TYPE.DATA_COLLECTOR);
        res.getContributors().add(con);
        Subject su = new Subject();
        su.setLang("en");
        su.setValue("My Subject");
        su.setValueUri("http://google.com");
        Scheme s2 = new Scheme();
        s2.setSchemeId("scheme2");
        s2.setSchemeUri("http://golem.de");
        su.setScheme(s2);
        res.getSubjects().add(su);
        Date d = new Date();
        d.setType(Date.DATE_TYPE.ACCEPTED);
        d.setValue(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        res.getDates().add(d);
        res.getSizes().add("test");
        res.getFormats().add("image/jpg");
        Description des = new Description();
        des.setLang("en");
        des.setDescription("This is the decriptions");
        des.setType(Description.TYPE.ABSTRACT);
        res.getDescriptions().add(des);
        Scheme rights = new Scheme();
        rights.setSchemeUri("http://apachecommons.org");
        rights.setSchemeId("Apache 2.0");
        res.getRights().add(rights);
        FundingReference ref = new FundingReference();
        Scheme award = new Scheme();
        award.setSchemeId("awardId");
        award.setSchemeUri("http://bmbf.de");
        ref.setAwardNumber(award);
        ref.setFunderName("BMBF");
        ref.setAwardTitle("BMBF Award");
        FunderIdentifier fid = new FunderIdentifier();
        fid.setValue("BMBF");
        fid.setType(FunderIdentifier.FUNDER_TYPE.GRID);
        ref.setFunderIdentifier(fid);
        res.getFundingReferences().add(ref);
        GeoLocation geo = new GeoLocation();
        Point po = new Point();
        po.setLatitude(1.0f);
        po.setLongitude(2.0f);
        geo.setPoint(po);
        geo.setPlace("Karlsruhe");
        Box box = new Box();
        box.setEastLongitude(0.0f);
        box.setNorthLatitude(1.0f);
        box.setSouthLatitude(2.0f);
        box.setWestLongitude(3.0f);
        geo.setBox(box);
        Polygon poly = new Polygon();
        Point p1 = new Point();
        p1.setLatitude(1.0f);
        p1.setLongitude(2.0f);
        Point p2 = new Point();
        p2.setLatitude(3.0f);
        p2.setLongitude(4.0f);
        Point p3 = new Point();
        p3.setLatitude(5.0f);
        p3.setLongitude(6.0f);
        poly.getPoints().add(p1);
        poly.getPoints().add(p2);
        poly.getPoints().add(p3);
        geo.setPolygon(poly);
        res.getGeoLocations().add(geo);
        res.setLanguage("en");
        ElementContainer cont = DublinCoreMapper.dataResourceToDublinCoreContainer(res);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ElementContainer.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cont, (OutputStream)System.out);
    }
}

