/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.validator;

import edu.kit.datamanager.annotations.SearchIndexUrl;
import edu.kit.datamanager.util.ElasticSearchUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUrlValidator
implements ConstraintValidator<SearchIndexUrl, URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchUrlValidator.class);

    public boolean isValid(URL value, ConstraintValidatorContext context) {
        boolean validElasticsearchUrl = false;
        if (value == null) {
            LOGGER.error("Provided value is null.");
            return validElasticsearchUrl;
        }
        validElasticsearchUrl = ElasticSearchUtil.testForElasticsearch(value);
        return validElasticsearchUrl;
    }
}

