/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.datamanager.validator;

import edu.kit.datamanager.annotations.LocalFileURL;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileValidator
implements ConstraintValidator<LocalFileURL, URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileValidator.class);

    public boolean isValid(URL value, ConstraintValidatorContext context) {
        boolean validLocalFile = false;
        if (value == null) {
            LOGGER.error("Provided value is null.");
            return validLocalFile;
        }
        try {
            LOGGER.trace("Successfully validated file URL {}. Checking local path.", (Object)value.toURI().toString());
            File localFile = new File(value.getPath());
            String pathToLocalFile = localFile.getAbsolutePath();
            if (!localFile.exists()) {
                LOGGER.error("File at {} does not exist!", (Object)pathToLocalFile);
            } else if (!localFile.isFile()) {
                LOGGER.error("File at {} is not a file!", (Object)pathToLocalFile);
            } else if (!localFile.canRead()) {
                LOGGER.error("File at {} is not readable!", (Object)pathToLocalFile);
            } else {
                LOGGER.trace("File at {} exists and is readable.", (Object)pathToLocalFile);
                validLocalFile = true;
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Failed to validate folder property with value " + value + ". -> Not a valid URL!", (Throwable)ex);
        }
        return validLocalFile;
    }
}

